/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.json.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.FrameworkUtil;

public class Util {
    public static String getValueOrDefault(JsonObject jsonObject, String element, String defaultValue) {
        if (jsonObject.has(element)) {
            return jsonObject.get(element).getAsString();
        }
        return defaultValue;
    }

    public static int getValueOrDefault(JsonObject jsonObject, String element, int defaultValue) {
        if (jsonObject.has(element)) {
            return jsonObject.get(element).getAsInt();
        }
        return defaultValue;
    }

    public static double getValueOrDefault(JsonObject jsonObject, String element, double defaultValue) {
        if (jsonObject.has(element)) {
            return jsonObject.get(element).getAsDouble();
        }
        return defaultValue;
    }

    public static String replace(JsonObject object, String input) {
        String result = Util.doReplace(object, input);
        JsonObject vars = object.getAsJsonObject("variables");
        if (vars != null) {
            result = Util.replace(vars, result);
        }
        return result;
    }

    private static String doReplace(JsonObject object, String input) {
        String result = input;
        for (Map.Entry entry : object.entrySet()) {
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (!jsonElement.isJsonPrimitive()) continue;
            String search = "${" + (String)entry.getKey() + "}";
            String replace = jsonElement.getAsString();
            int index = result.indexOf(search);
            while (index > -1) {
                result = String.valueOf(result.substring(0, index)) + replace + result.substring(index + search.length());
                index = result.indexOf(search);
            }
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject getJson(String input) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            InputStreamReader reader;
            ByteArrayInputStream stream;
            block13: {
                JsonObject jsonObject;
                block14: {
                    stream = new ByteArrayInputStream(input.getBytes());
                    reader = new InputStreamReader(stream);
                    JsonElement element = new JsonParser().parse((Reader)reader);
                    if (!(element instanceof JsonObject)) break block13;
                    jsonObject = (JsonObject)element;
                    if (reader == null) break block14;
                    reader.close();
                }
                if (stream == null) return jsonObject;
                ((InputStream)stream).close();
                return jsonObject;
            }
            if (reader != null) {
                reader.close();
            }
            if (stream == null) return null;
            {
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    ((InputStream)stream).close();
                    throw throwable;
                }
            }
            {
                ((InputStream)stream).close();
                return null;
                catch (Throwable throwable3) {
                    if (reader == null) throw throwable3;
                    reader.close();
                    throw throwable3;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    public static IStatus isValidUrl(String pUrl) {
        String symbolicName = FrameworkUtil.getBundle(Util.class).getSymbolicName();
        try {
            URL url = new URL(pUrl);
            HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
            int responseCode = httpCon.getResponseCode();
            if (responseCode != 200) {
                return new Status(4, symbolicName, MessageFormat.format("Received response code {0} from {1}.", String.valueOf(responseCode), pUrl));
            }
            if (httpCon.getContentLength() <= 0) {
                return new Status(4, symbolicName, MessageFormat.format("Received empty file from {0}.", pUrl));
            }
        }
        catch (Exception e) {
            return new Status(4, symbolicName, MessageFormat.format("Received empty file from {0}.", pUrl), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

