/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.util.FileNameMatcher;

class ImportStructureVisitor
implements ICVSResourceVisitor {
    private static final String KEYWORD_OPTION = "-k";
    private static final String QUOTE = "'";
    protected Session session;
    protected IProgressMonitor monitor;
    private FileNameMatcher ignoreMatcher;
    private FileNameMatcher wrapMatcher;

    public ImportStructureVisitor(Session session, String[] wrappers, IProgressMonitor monitor) {
        this.session = session;
        this.monitor = Policy.infiniteSubMonitorFor(monitor, 512);
        this.wrapMatcher = this.initWrapMatcher(wrappers);
    }

    private FileNameMatcher initWrapMatcher(String[] wrappers) {
        if (wrappers == null) {
            return null;
        }
        FileNameMatcher wrapMatcher = new FileNameMatcher();
        String[] stringArray = wrappers;
        int n = wrappers.length;
        int n2 = 0;
        while (n2 < n) {
            String wrapper = stringArray[n2];
            if (wrapper.contains(KEYWORD_OPTION)) {
                StringTokenizer st = new StringTokenizer(wrapper);
                String pattern = st.nextToken();
                String option = st.nextToken();
                StringTokenizer quoteSt = new StringTokenizer(st.nextToken(), QUOTE);
                option = String.valueOf(option) + quoteSt.nextToken();
                wrapMatcher.register(pattern, option);
            }
            ++n2;
        }
        return wrapMatcher;
    }

    @Override
    public void visitFile(ICVSFile mFile) throws CVSException {
        String mode;
        boolean binary;
        if (this.ignoreMatcher != null && this.ignoreMatcher.match(mFile.getName())) {
            return;
        }
        boolean bl = binary = Team.getFileContentManager().getType((IStorage)((IFile)mFile.getIResource())) == 2;
        if (this.wrapMatcher != null && (mode = this.wrapMatcher.getMatch(mFile.getName())) != null) {
            binary = Command.KSubstOption.fromMode(mode).isBinary();
        }
        this.session.sendModified(mFile, binary, this.monitor);
    }

    @Override
    public void visitFolder(ICVSFolder mFolder) throws CVSException {
        if (this.ignoreMatcher != null && this.ignoreMatcher.match(mFolder.getName())) {
            return;
        }
        String localPath = mFolder.getRelativePath(this.session.getLocalRoot());
        this.monitor.subTask(NLS.bind((String)CVSMessages.AbstractStructureVisitor_sendingFolder, (Object[])new String[]{localPath}));
        this.session.sendConstructedDirectory(localPath);
        mFolder.acceptChildren(this);
    }
}

