/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core.commands;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.commands.AbstractCommand;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class GetEnvCommand
extends AbstractCommand<Map<String, String>> {
    private final DataOutputStream out;
    private final DataInputStream in;

    public GetEnvCommand(ProxyConnection conn) {
        super(conn);
        this.out = new DataOutputStream(conn.getCommandChannel().getOutputStream());
        this.in = new DataInputStream(conn.getCommandChannel().getInputStream());
    }

    @Override
    public Map<String, String> call() throws ProxyException {
        try {
            StreamChannel chan = this.openChannel();
            DataInputStream resultStream = new DataInputStream(chan.getInputStream());
            this.out.writeByte(1);
            this.out.writeShort(104);
            this.out.writeByte(chan.getId());
            this.out.flush();
            byte res = this.in.readByte();
            if (res != 0) {
                String errMsg = this.in.readUTF();
                throw new ProxyException(errMsg);
            }
            int len = resultStream.readInt();
            HashMap<String, String> env = new HashMap<String, String>(len);
            int i = 0;
            while (i < len) {
                String key = resultStream.readUTF();
                String value = resultStream.readUTF();
                env.put(key, value);
                ++i;
            }
            chan.close();
            return env;
        }
        catch (IOException e) {
            throw new ProxyException(e.getMessage());
        }
    }
}

