/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.usage;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.internal.common.TypedModelConfiguration;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.usage.DomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class DirectedDomainUsageAnalysis
implements DomainUsageAnalysis.Root {
    protected final @NonNull RootDomainUsageAnalysis domainUsageAnalysis;
    protected final @NonNull TypedModelsConfiguration typedModelsConfiguration;
    private final @NonNull Set<@NonNull Property> dirtyProperties = new HashSet<Property>();
    private final @NonNull Set<@NonNull EReference> dirtyEReferences = new HashSet<EReference>();
    private RootDomainUsageAnalysis.DomainUsageConstant inputUsage = null;
    private RootDomainUsageAnalysis.DomainUsageConstant intermediateUsage = null;
    private RootDomainUsageAnalysis.DomainUsageConstant outputUsage = null;
    private @NonNull Map<@NonNull Domain, @NonNull Boolean> domain2isOutput = new HashMap<Domain, Boolean>();

    public DirectedDomainUsageAnalysis(@NonNull RootDomainUsageAnalysis domainUsageAnalysis, @NonNull TypedModelsConfiguration typedModelsConfiguration) {
        this.domainUsageAnalysis = domainUsageAnalysis;
        this.typedModelsConfiguration = typedModelsConfiguration;
    }

    protected void addDirtyProperty(@NonNull Property property) {
        this.dirtyProperties.add(property);
        EObject eProperty = property.getESObject();
        if (eProperty instanceof EReference) {
            this.dirtyEReferences.add((EReference)eProperty);
        }
    }

    protected void analyzeIntermediateTypedModels() {
    }

    protected void analyzePropertyAssignments(@NonNull Transformation transformation) {
        for (Property dirtyProperty : this.dirtyProperties) {
            if (!dirtyProperty.isIsTransient()) {
                QVTruntimeUtil.errPrintln((String)("Dirty " + dirtyProperty + " is not transient"));
            }
            if (dirtyProperty.isIsReadOnly()) {
                QVTruntimeUtil.errPrintln((String)("Dirty " + dirtyProperty + " is readonly"));
            }
            if (!dirtyProperty.isIsRequired()) continue;
            QVTruntimeUtil.errPrintln((String)("Dirty " + dirtyProperty + " is required"));
        }
    }

    protected @NonNull Map<@NonNull Domain, @NonNull Boolean> analyzeRelations(@NonNull Transformation transformation) {
        Map<@Nullable TypedModel, @NonNull Integer> typedModel2inputDistance = this.analyzeTypedModelDistances();
        Integer globalOutputDistance = typedModel2inputDistance.get(null);
        assert (globalOutputDistance != null);
        HashMap<@NonNull Domain, @NonNull Boolean> domain2direction = new HashMap<Domain, Boolean>();
        Iterable<@NonNull TypedModel> outputTypedModels = this.typedModelsConfiguration.getOutputTypedModels();
        for (Rule rule : QVTbaseUtil.getOwnedRules((Transformation)transformation)) {
            Integer distance;
            Integer minimumExplicitOutputDistance = null;
            Integer maximumDistance = null;
            boolean hasIntermediate = false;
            for (Domain domain : QVTbaseUtil.getOwnedDomains((Rule)rule)) {
                TypedModel typedModel = QVTbaseUtil.getTypedModel((Domain)domain);
                if (typedModel.isIsPrimitive() || typedModel.isIsTrace() || typedModel.isIsThis()) continue;
                Boolean isOutput = null;
                distance = typedModel2inputDistance.get(typedModel);
                if (distance == null) continue;
                if (distance >= globalOutputDistance) {
                    isOutput = Boolean.TRUE;
                } else if (domain.isNotOutput()) {
                    isOutput = Boolean.FALSE;
                } else if (distance <= 0 && !Iterables.contains(outputTypedModels, (Object)typedModel)) {
                    isOutput = Boolean.FALSE;
                }
                if (isOutput == Boolean.TRUE && (minimumExplicitOutputDistance == null || distance <= minimumExplicitOutputDistance)) {
                    minimumExplicitOutputDistance = distance;
                }
                if (isOutput != null) {
                    domain2direction.put(domain, isOutput);
                } else {
                    hasIntermediate = true;
                }
                if (maximumDistance != null && distance <= maximumDistance) continue;
                maximumDistance = distance;
            }
            if (!hasIntermediate) continue;
            assert (maximumDistance != null);
            Integer outputDistance = minimumExplicitOutputDistance != null ? minimumExplicitOutputDistance : maximumDistance;
            for (Domain domain : QVTbaseUtil.getOwnedDomains((Rule)rule)) {
                TypedModel typedModel;
                if (domain2direction.containsKey(domain) || (typedModel = QVTbaseUtil.getTypedModel((Domain)domain)).isIsPrimitive() || typedModel.isIsTrace() || typedModel.isIsThis() || (distance = typedModel2inputDistance.get(typedModel)) == null) continue;
                assert (distance < globalOutputDistance);
                if (distance == 0) {
                    distance = globalOutputDistance;
                }
                Boolean isOutput = distance >= outputDistance;
                domain2direction.put(domain, isOutput);
            }
        }
        return domain2direction;
    }

    public void analyzeTransformation() {
        int inputMask = 0;
        int intermediateMask = 0;
        int outputMask = 0;
        Transformation transformation = this.domainUsageAnalysis.getTransformation();
        for (TypedModel typedModel : QVTbaseUtil.getModelParameters((Transformation)transformation)) {
            if (typedModel.isIsPrimitive() || typedModel.isIsThis() || typedModel.isIsTrace()) continue;
            DomainUsage domainUsage = this.domainUsageAnalysis.getUsage((Element)typedModel);
            int bitMask = domainUsage.getMask();
            TypedModelConfiguration typedModelConfiguration = this.typedModelsConfiguration.getTypedModelConfiguration(typedModel);
            if (typedModelConfiguration.isInput()) {
                inputMask |= bitMask;
            }
            if (typedModelConfiguration.isIntermediate()) {
                intermediateMask |= bitMask;
            }
            if (!typedModelConfiguration.isOutput()) continue;
            outputMask |= bitMask;
        }
        this.setInputUsage(inputMask);
        this.setIntermediateUsage(intermediateMask);
        this.setOutputUsage(outputMask);
        this.analyzePropertyAssignments(transformation);
        if (intermediateMask != 0) {
            this.analyzeIntermediateTypedModels();
        }
        this.domain2isOutput = this.analyzeRelations(transformation);
    }

    protected @NonNull Map<@Nullable TypedModel, @NonNull Integer> analyzeTypedModelDistances() {
        HashMap<@Nullable TypedModel, @NonNull Integer> typedModel2inputDistance = new HashMap<TypedModel, Integer>();
        Iterable<@NonNull TypedModel> inputTypedModels = this.typedModelsConfiguration.getInputTypedModels();
        Iterable<@NonNull TypedModel> intermediateTypedModels = this.typedModelsConfiguration.getIntermediateTypedModels();
        Iterable<@NonNull TypedModel> outputTypedModels = this.typedModelsConfiguration.getOutputTypedModels();
        int distance = 0;
        for (TypedModel inputTypedModel : inputTypedModels) {
            assert (!Iterables.contains(intermediateTypedModels, (Object)inputTypedModel));
            typedModel2inputDistance.put(inputTypedModel, distance);
        }
        for (TypedModel intermediateTypedModel : intermediateTypedModels) {
            assert (!Iterables.contains(inputTypedModels, (Object)intermediateTypedModel));
            assert (!Iterables.contains(outputTypedModels, (Object)intermediateTypedModel));
            typedModel2inputDistance.put(intermediateTypedModel, ++distance);
        }
        typedModel2inputDistance.put(null, ++distance);
        for (TypedModel outputTypedModel : outputTypedModels) {
            assert (!Iterables.contains(intermediateTypedModels, (Object)outputTypedModel));
            if (typedModel2inputDistance.containsKey(outputTypedModel)) continue;
            typedModel2inputDistance.put(outputTypedModel, distance);
        }
        return typedModel2inputDistance;
    }

    @Override
    public @Nullable DomainUsage basicGetUsage(@Nullable Element element) {
        return this.domainUsageAnalysis.basicGetUsage(element);
    }

    public @NonNull DomainUsage getInputUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.inputUsage);
    }

    public @NonNull DomainUsage getIntermediateUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.intermediateUsage);
    }

    public @NonNull DomainUsage getOutputUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.outputUsage);
    }

    @Override
    public @NonNull DomainUsage getUsage(@NonNull Element element) {
        return this.domainUsageAnalysis.getUsage(element);
    }

    @Override
    @Deprecated
    public @NonNull DomainUsage getConstantUsage(int bitMask) {
        return this.domainUsageAnalysis.getConstantUsage(bitMask);
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.domainUsageAnalysis.getEnvironmentFactory();
    }

    public boolean isDirty(@NonNull EReference eReference) {
        return this.dirtyEReferences.contains(eReference);
    }

    public boolean isDirty(@NonNull Property property) {
        return property.isIsTransient() || this.dirtyProperties.contains(property);
    }

    public boolean isInput(@NonNull DomainUsage usage) {
        return (usage.getMask() & this.inputUsage.bitMask) != 0;
    }

    public boolean isInputInRule(@NonNull Rule rule, @NonNull Element element) {
        if (element instanceof Parameter && QVTbaseUtil.isThis((VariableDeclaration)((Parameter)element))) {
            return false;
        }
        assert (rule == QVTbaseUtil.getContainingRule((EObject)element));
        DomainUsage usage = this.getUsage(element);
        TypedModel typedModel = usage.getTypedModel(element);
        assert (typedModel != null);
        if (typedModel.isIsPrimitive() || typedModel.isIsThis() || typedModel.isIsTrace()) {
            return false;
        }
        Domain domain2 = QVTbaseUtil.basicGetDomain((Rule)rule, (TypedModel)typedModel);
        Boolean isInput2 = domain2 != null && this.domain2isOutput.get(domain2) == Boolean.FALSE;
        assert (isInput2 != null);
        return isInput2;
    }

    public boolean isIntermediate(@NonNull DomainUsage usage) {
        return (usage.getMask() & this.intermediateUsage.bitMask) != 0;
    }

    public boolean isOutput(@NonNull DomainUsage usage) {
        return (usage.getMask() & this.outputUsage.bitMask) != 0;
    }

    public boolean isOutputInRule(@NonNull Rule rule, @NonNull Element element) {
        if (element instanceof Parameter && QVTbaseUtil.isThis((VariableDeclaration)((Parameter)element))) {
            return false;
        }
        assert (rule == QVTbaseUtil.basicGetContainingRule((EObject)element));
        DomainUsage usage = this.getUsage(element);
        TypedModel typedModel = usage.getTypedModel(element);
        assert (typedModel != null);
        if (typedModel.isIsPrimitive() || typedModel.isIsThis() || typedModel.isIsTrace()) {
            return false;
        }
        Domain domain2 = QVTbaseUtil.basicGetDomain((Rule)rule, (TypedModel)typedModel);
        Boolean isOutput2 = domain2 != null && this.domain2isOutput.get(domain2) == Boolean.TRUE;
        assert (isOutput2 != null);
        return isOutput2;
    }

    protected void setInputUsage(int inputMask) {
        int anyMask = this.domainUsageAnalysis.getAnyMask();
        this.inputUsage = this.domainUsageAnalysis.getConstantUsage(anyMask & inputMask);
    }

    protected void setIntermediateUsage(int intermediateMask) {
        int anyMask = this.domainUsageAnalysis.getAnyMask();
        this.intermediateUsage = this.domainUsageAnalysis.getConstantUsage(anyMask & intermediateMask);
    }

    protected void setOutputUsage(int outputMask) {
        int anyMask = this.domainUsageAnalysis.getAnyMask();
        this.outputUsage = this.domainUsageAnalysis.getConstantUsage(anyMask & outputMask);
    }
}

