/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.ApiFilterStore;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.builder.ReferenceAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.SinceTagChecker;
import org.eclipse.pde.api.tools.internal.builder.TagValidator;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.IVersionRange;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiAnalyzer;
import org.eclipse.pde.api.tools.internal.provisional.builder.IBuildContext;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.UseScanManager;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.SinceTagVersion;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Version;

public class BaseApiAnalyzer
implements IApiAnalyzer {
    private static final String QUALIFIER = "qualifier";
    static final String[] NO_TYPES = new String[0];
    private ArrayList<IApiProblem> fProblems = new ArrayList(25);
    private List<IDelta> fPendingDeltaInfos = new ArrayList<IDelta>(3);
    private BuildState fBuildState = null;
    private IApiFilterStore fFilterStore = null;
    private IJavaProject fJavaProject = null;
    private Properties fPreferences = null;
    private boolean fContinueOnResolutionError = false;

    @Override
    public void analyzeComponent(BuildState state, IApiFilterStore filterStore, Properties preferences, IApiBaseline baseline, IApiComponent component, IBuildContext context, IProgressMonitor monitor) {
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_analyzing_api, (int)6);
        try {
            boolean isNested;
            IBuildContext bcontext;
            ResolverError[] errors;
            this.fJavaProject = this.getJavaProject(component);
            this.fFilterStore = filterStore;
            this.fPreferences = preferences;
            if (!this.ignoreUnusedProblemFilterCheck()) {
                ((ApiFilterStore)component.getFilterStore()).recordFilterUsage();
            }
            if ((errors = component.getErrors()) != null) {
                StringBuilder buffer = null;
                int i = 0;
                int max = errors.length;
                while (i < max) {
                    ResolverError error = errors[i];
                    VersionConstraint constraint = error.getUnsatisfiedConstraint();
                    if (constraint != null) {
                        VersionRange versionRange = constraint.getVersionRange();
                        if (buffer == null) {
                            buffer = new StringBuilder();
                        }
                        if (i > 0) {
                            buffer.append(',').append(' ');
                        }
                        buffer.append(NLS.bind((String)BuilderMessages.reportUnsatisfiedConstraint, (Object[])new String[]{constraint.getName(), versionRange != null ? versionRange.toString() : BuilderMessages.undefinedRange}));
                    }
                    ++i;
                }
                if (buffer != null) {
                    this.createApiComponentResolutionProblem(component, String.valueOf(buffer));
                    if (baseline == null) {
                        this.checkDefaultBaselineSet();
                    }
                    if (!this.fContinueOnResolutionError) {
                        return;
                    }
                }
            }
            if ((bcontext = context) == null) {
                bcontext = new BuildContext();
            }
            if (isNested = this.checkIfNested(component)) {
                return;
            }
            try {
                boolean checkfilters = false;
                if (baseline != null) {
                    IApiComponent bestMatchReference;
                    Set<IApiComponent> baselineAllComponents;
                    IApiComponent reference = baseline.getApiComponent(component.getSymbolicName());
                    if (reference != null && !(baselineAllComponents = baseline.getAllApiComponents(component.getSymbolicName())).isEmpty() && (bestMatchReference = this.getBestMatchFromMultipleComponents(baselineAllComponents, component)) != null) {
                        reference = bestMatchReference;
                    }
                    this.fBuildState = state;
                    if (this.fBuildState == null) {
                        this.fBuildState = this.getBuildState();
                    }
                    if (reference != null) {
                        localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_comparing_api_profiles, (Object[])new String[]{reference.getSymbolicName(), baseline.getName()}));
                        if (bcontext.hasTypes()) {
                            String[] changedtypes = bcontext.getStructurallyChangedTypes();
                            this.checkCompatibility(changedtypes, reference, component, localMonitor.split(1));
                        } else {
                            this.checkCompatibility(reference, component, (IProgressMonitor)localMonitor.split(1));
                        }
                        this.fBuildState.setReexportedComponents(Util.getReexportedComponents(component));
                    } else {
                        localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_comparing_api_profiles, (Object[])new String[]{component.getSymbolicName(), baseline.getName()}));
                        this.checkCompatibility(null, component, (IProgressMonitor)localMonitor.split(1));
                    }
                    this.checkApiComponentVersion(reference, component);
                    localMonitor.split(1);
                    checkfilters = true;
                } else {
                    this.checkDefaultBaselineSet();
                    localMonitor.split(2);
                }
                this.checkEEDescriptions();
                this.checkApiUsage(bcontext, component, (IProgressMonitor)localMonitor.split(1));
                this.checkTagValidation(bcontext, component, (IProgressMonitor)localMonitor.split(1));
                if (checkfilters) {
                    this.checkUnusedProblemFilters(bcontext, component, (IProgressMonitor)localMonitor.split(1));
                }
                localMonitor.setWorkRemaining(1);
                if (component instanceof ProjectComponent) {
                    this.checkExternalDependencies(component, bcontext, null, (IProgressMonitor)localMonitor.split(1));
                }
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
            catch (OperationCanceledException operationCanceledException) {
                if (ApiPlugin.DEBUG_API_ANALYZER) {
                    System.out.println("Trapped OperationCanceledException");
                }
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
    }

    private boolean checkIfNested(IApiComponent component) {
        if (!ApiPlugin.isRunningInFramework()) {
            return false;
        }
        if (this.fJavaProject != null) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        Path componentLocation = new Path(component.getLocation());
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IPath projectLocation = project.getLocation();
            if (projectLocation != null && projectLocation.isPrefixOf((IPath)componentLocation) && componentLocation.segmentCount() == projectLocation.segmentCount() + 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IApiComponent getBestMatchFromMultipleComponents(Set<IApiComponent> baselineAllComponents, IApiComponent component) {
        IApiComponent bestMatchReference = null;
        Version compVer = new Version(component.getVersion());
        for (IApiComponent baselineComp : baselineAllComponents) {
            Version verBaseline = new Version(baselineComp.getVersion());
            if (compVer.compareTo(verBaseline) < 0) continue;
            bestMatchReference = baselineComp;
            break;
        }
        return bestMatchReference;
    }

    public void setContinueOnResolverError(boolean continueOnError) {
        this.fContinueOnResolutionError = continueOnError;
    }

    public boolean isContinueOnResolverError() {
        return this.fContinueOnResolutionError;
    }

    void checkEEDescriptions() {
        String[] ees;
        if (this.ignoreEEDescriptionCheck()) {
            if (ApiPlugin.DEBUG_API_ANALYZER) {
                System.out.println("Ignoring check for API EE descriptions");
            }
            return;
        }
        if (ApiPlugin.DEBUG_API_ANALYZER) {
            System.out.println("Checking if there are any API EE descriptions installed if the preference is set to not be 'ignore'");
        }
        if ((ees = StubApiComponent.getInstalledMetadata()).length < 1) {
            IApiProblem problem = ApiProblemFactory.newApiUsageProblem(Path.EMPTY.toString(), null, new String[]{this.fJavaProject.getElementName()}, new String[]{"apiMarkerID"}, new Object[]{3}, -1, -1, -1, 7, 11);
            this.addProblem(problem);
        }
    }

    private boolean ignoreEEDescriptionCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("INVALID_REFERENCE_IN_SYSTEM_LIBRARIES", this.fJavaProject.getProject().getProject()) == 0;
    }

    public void checkExternalDependencies(IApiComponent apiComponent, IBuildContext bcontext, Properties properties, IProgressMonitor monitor) throws CoreException {
        boolean checkState;
        if (!this.isSeverityEnabled(properties)) {
            return;
        }
        String[] apiUseTypes = this.getApiUseTypes(bcontext);
        if (ApiPlugin.DEBUG_API_ANALYZER) {
            if (apiUseTypes.length < 1) {
                System.out.println("Checking use scan dependencies for: " + apiComponent.getSymbolicName() + " (" + apiComponent.getVersion() + ")");
            } else {
                System.out.println("Checking use scan dependencies for: " + Arrays.asList(apiUseTypes));
            }
        }
        if (!(checkState = this.hasCheckedAPIScanLocation())) {
            return;
        }
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.checking_external_dependencies, (int)10);
        IReferenceDescriptor[] externalDependencies = UseScanManager.getInstance().getExternalDependenciesFor(apiComponent, apiUseTypes, (IProgressMonitor)localmonitor.split(10));
        try {
            if (externalDependencies != null) {
                localmonitor.setWorkRemaining(externalDependencies.length);
                HashMap<String, IApiProblem> problems = new HashMap<String, IApiProblem>();
                IReferenceDescriptor[] iReferenceDescriptorArray = externalDependencies;
                int n = externalDependencies.length;
                int n2 = 0;
                while (n2 < n) {
                    IReferenceDescriptor externalDependency = iReferenceDescriptorArray[n2];
                    localmonitor.split(1);
                    Reference externalReference = null;
                    IApiTypeRoot type = null;
                    IMemberDescriptor referencedMember = externalDependency.getReferencedMember();
                    IReferenceTypeDescriptor referenceMemberType = referencedMember.getEnclosingType();
                    if (referenceMemberType != null) {
                        type = apiComponent.findTypeRoot(referenceMemberType.getQualifiedName());
                    }
                    switch (referencedMember.getElementType()) {
                        case 2: {
                            referenceMemberType = (IReferenceTypeDescriptor)referencedMember;
                            type = apiComponent.findTypeRoot(referenceMemberType.getQualifiedName());
                            if (type == null) break;
                            externalReference = Reference.typeReference(type.getStructure(), referenceMemberType.getQualifiedName(), externalDependency.getReferenceKind());
                            break;
                        }
                        case 6: {
                            if (type == null) break;
                            externalReference = Reference.methodReference(type.getStructure(), referenceMemberType.getQualifiedName(), referencedMember.getName(), ((IMethodDescriptor)referencedMember).getSignature(), externalDependency.getReferenceKind());
                            break;
                        }
                        case 5: {
                            if (type == null) break;
                            externalReference = Reference.fieldReference(type.getStructure(), referenceMemberType.getQualifiedName(), referencedMember.getName(), externalDependency.getReferenceKind());
                            break;
                        }
                    }
                    if (type == null) {
                        this.createExternalDependenciesProblem(problems, externalDependency, referenceMemberType.getQualifiedName(), referencedMember, externalDependency.getReferencedMember().getElementType(), 2);
                    } else {
                        externalReference.resolve();
                        if (externalReference.getResolvedReference() == null) {
                            this.createExternalDependenciesProblem(problems, externalDependency, referenceMemberType.getQualifiedName(), referencedMember, externalDependency.getReferencedMember().getElementType(), 1);
                        }
                    }
                    ++n2;
                }
                for (IApiProblem apiProblem : problems.values()) {
                    this.addProblem(apiProblem);
                }
            }
        }
        finally {
            localmonitor.done();
        }
    }

    private boolean hasCheckedAPIScanLocation() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.api.tools");
        String location = node.get("API_USE_SCAN_LOCATION", null);
        if (location == null || location.length() == 0) {
            return false;
        }
        ArrayList<String> checkedLocations = new ArrayList<String>();
        if (location != null && location.length() > 0) {
            String[] locations;
            String[] stringArray = locations = location.split("\\|");
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                String locationString = stringArray[n2];
                String[] values = locationString.split("\\*");
                if (Boolean.parseBoolean(values[1])) {
                    checkedLocations.add(values[0]);
                }
                ++n2;
            }
        }
        return checkedLocations.size() > 0;
    }

    public boolean isSeverityEnabled(Properties properties) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.api.tools");
        if (properties == null) {
            if (!this.isIgnore(node.get("API_USE_SCAN_TYPE_SEVERITY", "Ignore"))) {
                return true;
            }
            if (!this.isIgnore(node.get("API_USE_SCAN_METHOD_SEVERITY", "Ignore"))) {
                return true;
            }
            return this.isIgnore(node.get("API_USE_SCAN_FIELD_SEVERITY", "Ignore"));
        }
        if (properties.isEmpty()) {
            return true;
        }
        if (!this.isIgnore(properties.get("API_USE_SCAN_TYPE_SEVERITY"))) {
            return true;
        }
        if (!this.isIgnore(properties.get("API_USE_SCAN_METHOD_SEVERITY"))) {
            return true;
        }
        return !this.isIgnore(properties.get("API_USE_SCAN_FIELD_SEVERITY"));
    }

    private boolean isIgnore(Object value) {
        return value == null || !value.toString().equalsIgnoreCase("Error") && !value.toString().equalsIgnoreCase("Warning");
    }

    protected IApiProblem createExternalDependenciesProblem(HashMap<String, IApiProblem> problems, IReferenceDescriptor dependency, String referenceTypeName, IMemberDescriptor referencedMember, int elementType, int flag) {
        String resource = referenceTypeName;
        String primaryTypeName = referenceTypeName.replace('$', '.');
        int charStart = -1;
        int charEnd = -1;
        int lineNumber = -1;
        if (this.fJavaProject != null) {
            IResource res;
            IType type;
            block16: {
                type = this.fJavaProject.findType(primaryTypeName);
                IType typeInProject = Util.getTypeInSameJavaProject(type, primaryTypeName, this.fJavaProject);
                if (typeInProject != null) {
                    type = typeInProject;
                }
                if ((res = Util.getResource(this.fJavaProject.getProject(), type)) != null) break block16;
                return null;
            }
            try {
                resource = !Util.isManifest(res.getProjectRelativePath()) ? res.getProjectRelativePath().toString() : ".";
                if (type != null) {
                    ISourceRange range = type.getNameRange();
                    charStart = range.getOffset();
                    charEnd = charStart + range.getLength();
                    try {
                        IDocument document = Util.getDocument(type.getCompilationUnit());
                        lineNumber = document.getLineOfOffset(charStart);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            catch (CoreException e) {
                ApiPlugin.log("Failed to resolve problem details for " + referenceTypeName + " in " + this.fJavaProject.getElementName(), e);
            }
        }
        String[] msgArgs = new String[]{referenceTypeName, referencedMember.getName(), dependency.getComponent().getId()};
        int kind = 0;
        switch (elementType) {
            case 2: {
                kind = 1;
                break;
            }
            case 6: {
                kind = 2;
                msgArgs[1] = String.valueOf(BuilderMessages.BaseApiAnalyzer_Method) + ' ' + msgArgs[1];
                if ((dependency.getReferenceKind() & 0x40) <= 0) break;
                msgArgs[1] = String.valueOf(BuilderMessages.BaseApiAnalyzer_Constructor) + ' ' + msgArgs[1];
                break;
            }
            case 5: {
                kind = 3;
                break;
            }
        }
        int dependencyNameIndex = 2;
        int problemId = ApiProblemFactory.createProblemId(Integer.MIN_VALUE, elementType, kind, flag);
        String problemKey = String.valueOf(referenceTypeName) + problemId;
        IApiProblem similarProblem = problems.get(problemKey);
        if (similarProblem != null) {
            String[] existingMsgArgs = similarProblem.getMessageArguments()[dependencyNameIndex].split(", ");
            if (!Arrays.asList(existingMsgArgs).contains(msgArgs[dependencyNameIndex])) {
                msgArgs[dependencyNameIndex] = String.valueOf(similarProblem.getMessageArguments()[dependencyNameIndex]) + ',' + ' ' + msgArgs[dependencyNameIndex];
            } else {
                return similarProblem;
            }
        }
        IApiProblem problem = ApiProblemFactory.newApiUseScanProblem(resource, primaryTypeName, msgArgs, new String[]{"apiUseScanType"}, new String[]{primaryTypeName}, lineNumber, charStart, charEnd, elementType, kind, flag);
        problems.put(problemKey, problem);
        return problem;
    }

    private void checkCompatibility(String[] changedtypes, IApiComponent reference, IApiComponent component, SubMonitor localMonitor) throws CoreException {
        localMonitor.setWorkRemaining(changedtypes.length);
        String[] stringArray = changedtypes;
        int n = changedtypes.length;
        int n2 = 0;
        while (n2 < n) {
            String changedtype = stringArray[n2];
            if (changedtype != null) {
                this.checkCompatibility(changedtype, reference, component, (IProgressMonitor)localMonitor.split(1));
            }
            ++n2;
        }
    }

    private void checkUnusedProblemFilters(IBuildContext context, IApiComponent reference, IProgressMonitor monitor) {
        if (this.ignoreUnusedProblemFilterCheck()) {
            if (ApiPlugin.DEBUG_API_ANALYZER) {
                System.out.println("Ignoring unused problem filter check");
            }
            return;
        }
        try {
            ApiFilterStore store = (ApiFilterStore)reference.getFilterStore();
            IProject project = this.fJavaProject.getProject();
            boolean autoremove = ApiPlugin.getDefault().getEnableState("automatically_removed_unused_problem_filters", project);
            ArrayList<IApiProblemFilter> toremove = null;
            if (autoremove) {
                toremove = new ArrayList<IApiProblemFilter>(8);
            }
            IApiProblemFilter[] filters = null;
            if (context.hasTypes()) {
                String[] types;
                IResource resource = null;
                String[] stringArray = types = this.getApiUseTypes(context);
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    if (type != null) {
                        IType type2 = this.fJavaProject.findType(Signatures.getPrimaryTypeName(type));
                        IType typeInProject = Util.getTypeInSameJavaProject(type2, Signatures.getPrimaryTypeName(type), this.fJavaProject);
                        if (typeInProject != null) {
                            type2 = typeInProject;
                        }
                        if ((resource = Util.getResource(project, type2)) != null) {
                            filters = store.getUnusedFilters(resource, type, null);
                            if (autoremove) {
                                Collections.addAll(toremove, filters);
                            } else {
                                this.createUnusedApiFilterProblems(filters);
                            }
                        }
                    }
                    ++n2;
                }
                if (autoremove) {
                    this.removeUnusedProblemFilters(store, toremove, monitor);
                }
            } else {
                filters = store.getUnusedFilters(null, null, null);
                if (autoremove) {
                    Collections.addAll(toremove, filters);
                    this.removeUnusedProblemFilters(store, toremove, monitor);
                } else {
                    this.createUnusedApiFilterProblems(filters);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    void removeUnusedProblemFilters(IApiFilterStore store, List<IApiProblemFilter> filterlist, IProgressMonitor monitor) throws CoreException {
        if (filterlist.size() > 0) {
            IWorkspaceRunnable runner = lmonitor -> {
                boolean bl = store.removeFilters(filterlist.toArray(new IApiProblemFilter[filterlist.size()]));
            };
            ResourcesPlugin.getWorkspace().run(runner, null, 1, monitor);
        }
    }

    private void createUnusedApiFilterProblems(IApiProblemFilter[] filters) {
        if (this.fJavaProject == null) {
            return;
        }
        IApiProblemFilter filter = null;
        IApiProblem problem = null;
        IApiProblemFilter[] iApiProblemFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IApiProblemFilter f = iApiProblemFilterArray[n2];
            filter = f;
            problem = filter.getUnderlyingProblem();
            if (problem == null) {
                return;
            }
            IResource resource = null;
            IType type = null;
            int lineNumber = 0;
            int charStart = -1;
            int charEnd = -1;
            if (this.fJavaProject != null) {
                try {
                    IProject project;
                    IType sourceType;
                    String typeName = problem.getTypeName();
                    if (typeName != null) {
                        type = this.fJavaProject.findType(typeName.replace('$', '.'));
                    }
                    if (type instanceof BinaryType && (sourceType = Util.findSourceTypeinJavaProject(this.fJavaProject, typeName.replace('$', '.'))) != null) {
                        type = sourceType;
                    }
                    if ((resource = Util.getResource(project = this.fJavaProject.getProject(), type)) == null) {
                        return;
                    }
                    if (!Util.isManifest(resource.getProjectRelativePath()) && !type.isBinary()) {
                        ISourceRange range = type.getNameRange();
                        charStart = range.getOffset();
                        charEnd = charStart + range.getLength();
                        try {
                            IDocument document = Util.getDocument(type.getCompilationUnit());
                            lineNumber = document.getLineOfOffset(charStart);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
            String path = null;
            if (resource != null) {
                path = resource.getProjectRelativePath().toPortableString();
            }
            this.addProblem(ApiProblemFactory.newApiUsageProblem(path, problem.getTypeName(), new String[]{filter.getUnderlyingProblem().getMessage()}, new String[]{"filterhandle", "apiMarkerID"}, new Object[]{((ApiProblemFilter)filter).getHandle(), 9}, lineNumber, charStart, charEnd, problem.getElementKind(), 10));
            ++n2;
        }
    }

    private ReexportedBundleVersionInfo checkBundleVersionsOfReexportedBundles(IApiComponent reference, IApiComponent component) throws CoreException {
        IRequiredComponentDescription[] requiredComponents = component.getRequiredComponents();
        int length = requiredComponents.length;
        ReexportedBundleVersionInfo info = null;
        if (length != 0) {
            int i = 0;
            while (i < length) {
                IRequiredComponentDescription description = requiredComponents[i];
                if (description.isExported()) {
                    String id = description.getId();
                    IRequiredComponentDescription[] requiredComponents2 = reference.getRequiredComponents();
                    IRequiredComponentDescription referenceDescription = null;
                    int length2 = requiredComponents2.length;
                    int j = 0;
                    while (j < length2) {
                        IRequiredComponentDescription description2 = requiredComponents2[j];
                        IRequiredComponentDescription bestMatch = this.getBestMatchFromMultipleReqComponents(requiredComponents2, description);
                        if (bestMatch != null) {
                            description2 = bestMatch;
                        }
                        if (description2.getId().equals(id) && description2.isExported()) {
                            referenceDescription = description2;
                            break;
                        }
                        ++j;
                    }
                    if (referenceDescription != null) {
                        IVersionRange versionRange = description.getVersionRange();
                        IVersionRange versionRange2 = referenceDescription.getVersionRange();
                        Version currentLowerBound = new Version(versionRange.getMinimumVersion());
                        Version referenceLowerBound = new Version(versionRange2.getMinimumVersion());
                        int currentLowerMajorVersion = currentLowerBound.getMajor();
                        int referenceLowerMajorVersion = referenceLowerBound.getMajor();
                        int currentLowerMinorVersion = currentLowerBound.getMinor();
                        int referenceLowerMinorVersion = referenceLowerBound.getMinor();
                        if (currentLowerMajorVersion < referenceLowerMajorVersion || currentLowerMinorVersion < referenceLowerMinorVersion) {
                            return new ReexportedBundleVersionInfo(id, 5);
                        }
                        if (currentLowerMajorVersion > referenceLowerMajorVersion) {
                            return new ReexportedBundleVersionInfo(id, 5);
                        }
                        if (currentLowerMinorVersion > referenceLowerMinorVersion) {
                            info = new ReexportedBundleVersionInfo(id, 6);
                        }
                    }
                }
                ++i;
            }
        }
        return info;
    }

    private IRequiredComponentDescription getBestMatchFromMultipleReqComponents(IRequiredComponentDescription[] requiredComponents2, IRequiredComponentDescription description) {
        IVersionRange versionRange = description.getVersionRange();
        Version currentLowerBound = new Version(versionRange.getMinimumVersion());
        int major = currentLowerBound.getMajor();
        IRequiredComponentDescription[] iRequiredComponentDescriptionArray = requiredComponents2;
        int n = requiredComponents2.length;
        int n2 = 0;
        while (n2 < n) {
            IVersionRange versionRange2;
            Version currentLowerBound2;
            IRequiredComponentDescription iRequiredComponentDescription = iRequiredComponentDescriptionArray[n2];
            if (description.getId().equals(iRequiredComponentDescription.getId()) && (currentLowerBound2 = new Version((versionRange2 = iRequiredComponentDescription.getVersionRange()).getMinimumVersion())).getMajor() == major) {
                return iRequiredComponentDescription;
            }
            ++n2;
        }
        return null;
    }

    private CompilationUnit createAST(ITypeRoot root, int offset) {
        if (this.fJavaProject == null) {
            return null;
        }
        ASTParser parser = ASTParser.newParser((int)15);
        parser.setFocalPosition(offset);
        parser.setResolveBindings(false);
        parser.setSource(root);
        Map options = this.fJavaProject.getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        return (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    private BuildState getBuildState() {
        IProject project = null;
        if (this.fJavaProject != null) {
            project = this.fJavaProject.getProject();
        }
        if (project == null) {
            return new BuildState();
        }
        try {
            BuildState state = BuildState.getLastBuiltState(project);
            if (state != null) {
                return state;
            }
        }
        catch (CoreException e) {
            ApiPlugin.log("Failed to read last build state for " + project, e);
        }
        return new BuildState();
    }

    private IApiTypeContainer getSearchScope(IApiComponent component, String[] typenames) {
        if (typenames == null) {
            return component;
        }
        if (typenames.length == 0) {
            return component;
        }
        return Factory.newTypeScope(component, this.getScopedElements(typenames));
    }

    private IReferenceTypeDescriptor[] getScopedElements(String[] typenames) {
        ArrayList<IReferenceTypeDescriptor> types = new ArrayList<IReferenceTypeDescriptor>(typenames.length);
        String[] stringArray = typenames;
        int n = typenames.length;
        int n2 = 0;
        while (n2 < n) {
            String typename = stringArray[n2];
            if (typename != null) {
                types.add(Util.getType(typename));
            }
            ++n2;
        }
        return types.toArray(new IReferenceTypeDescriptor[types.size()]);
    }

    @Override
    public IApiProblem[] getProblems() {
        if (this.fProblems == null) {
            return new IApiProblem[0];
        }
        return this.fProblems.toArray(new IApiProblem[this.fProblems.size()]);
    }

    @Override
    public void dispose() {
        if (this.fProblems != null) {
            this.fProblems.clear();
            this.fProblems = null;
        }
        if (this.fPendingDeltaInfos != null) {
            this.fPendingDeltaInfos.clear();
            this.fPendingDeltaInfos = null;
        }
        if (this.fBuildState != null) {
            this.fBuildState = null;
        }
    }

    private boolean ignoreApiUsageScan() {
        if (this.fJavaProject == null) {
            return false;
        }
        IProject project = this.fJavaProject.getProject();
        boolean ignore = true;
        ApiPlugin plugin = ApiPlugin.getDefault();
        ignore &= plugin.getSeverityLevel("ILLEGAL_EXTEND", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_IMPLEMENT", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_INSTANTIATE", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_REFERENCE", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_OVERRIDE", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_EXTEND", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_FIELD_DECL", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_IMPLEMENT", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_METHOD_PARAM", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_METHOD_RETURN_TYPE", project) == 0;
        return ignore &= plugin.getSeverityLevel("INVALID_REFERENCE_IN_SYSTEM_LIBRARIES", project) == 0;
    }

    private boolean reportApiBreakageWhenMajorVersionIncremented() {
        if (this.fJavaProject == null) {
            return false;
        }
        return ApiPlugin.getDefault().getEnableState("report_api_breakage_when_major_version_incremented", this.fJavaProject.getProject().getProject());
    }

    private boolean ignoreDefaultBaselineCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("missing_default_api_profile", this.fJavaProject.getProject().getProject()) == 0;
    }

    private boolean ignoreSinceTagCheck(String pref) {
        if (this.fJavaProject == null) {
            return true;
        }
        IProject project = this.fJavaProject.getProject();
        ApiPlugin plugin = ApiPlugin.getDefault();
        if (pref == null) {
            boolean ignore = plugin.getSeverityLevel("malformed_since_tag", project) == 0;
            ignore &= plugin.getSeverityLevel("invalid_since_tag_version", project) == 0;
            return ignore &= plugin.getSeverityLevel("missing_since_tag", project) == 0;
        }
        return plugin.getSeverityLevel(pref, project) == 0;
    }

    private boolean ignoreComponentVersionCheck() {
        if (this.fJavaProject == null) {
            return false;
        }
        return ApiPlugin.getDefault().getSeverityLevel("incompatible_api_component_version", this.fJavaProject.getProject().getProject()) == 0;
    }

    private boolean reportUnnecessaryMinorMicroVersionCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("incompatible_api_component_version_report_minor_without_api_change", this.fJavaProject.getProject().getProject()) != 0;
    }

    private boolean reportMajorVersionCheckWithoutBreakingChange() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("incompatible_api_component_version_report_major_without_breaking_change", this.fJavaProject.getProject().getProject()) != 0;
    }

    private boolean ignoreInvalidTagCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("INVALID_JAVADOC_TAG", this.fJavaProject.getProject()) == 0;
    }

    private boolean ignoreInvalidAnnotationCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("INVALID_ANNOTATION", this.fJavaProject.getProject()) == 0;
    }

    private boolean ignoreUnusedProblemFilterCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("UNUSED_PROBLEM_FILTERS", this.fJavaProject.getProject()) == 0;
    }

    private void checkTagValidation(IBuildContext context, IApiComponent component, IProgressMonitor monitor) {
        boolean tags = this.ignoreInvalidTagCheck();
        boolean annotations = this.ignoreInvalidAnnotationCheck();
        if (tags && annotations) {
            return;
        }
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_validating_javadoc_tags, (int)1);
        if (context.hasTypes()) {
            String[] typenames = context.getStructurallyChangedTypes();
            localMonitor.setWorkRemaining(typenames.length);
            String[] stringArray = typenames;
            int n = typenames.length;
            int n2 = 0;
            while (n2 < n) {
                String typename = stringArray[n2];
                if (typename != null) {
                    localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_scanning_0, (Object)typename));
                    this.processType(typename, !tags, !annotations);
                    localMonitor.split(1);
                }
                ++n2;
            }
        } else {
            try {
                IPackageFragmentRoot[] roots = this.fJavaProject.getPackageFragmentRoots();
                localMonitor.setWorkRemaining(roots.length);
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                int n = roots.length;
                int n3 = 0;
                while (n3 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n3];
                    if (root.getKind() == 1) {
                        localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_scanning_0, (Object)root.getPath().toOSString()));
                        this.scanSource((IJavaElement)root, !tags, !annotations, (IProgressMonitor)localMonitor.split(1));
                    }
                    ++n3;
                }
            }
            catch (JavaModelException jme) {
                ApiPlugin.log(jme);
            }
        }
    }

    private void scanSource(IJavaElement element, boolean tags, boolean annotations, IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        switch (element.getElementType()) {
            case 3: 
            case 4: {
                IParent parent = (IParent)element;
                IJavaElement[] children = parent.getChildren();
                subMonitor.setWorkRemaining(children.length);
                IJavaElement[] iJavaElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement javaElement = iJavaElementArray[n2];
                    this.scanSource(javaElement, tags, annotations, (IProgressMonitor)subMonitor.split(1));
                    ++n2;
                }
                break;
            }
            case 5: {
                ICompilationUnit unit = (ICompilationUnit)element;
                this.processType(unit, tags, annotations);
                break;
            }
        }
    }

    private void processType(String typename, boolean tags, boolean annotations) {
        try {
            ICompilationUnit cunit;
            IType type = this.fJavaProject.findType(typename);
            IType typeInProject = Util.getTypeInSameJavaProject(type, typename, this.fJavaProject);
            if (typeInProject != null) {
                type = typeInProject;
            }
            if (type != null && !type.isMember() && (cunit = type.getCompilationUnit()) != null) {
                this.processType(cunit, tags, annotations);
            }
        }
        catch (JavaModelException e) {
            ApiPlugin.log(e);
        }
    }

    private void processType(ICompilationUnit cunit, boolean tags, boolean annotations) {
        IApiProblem[] tagProblems;
        CompilationUnit comp = this.createAST((ITypeRoot)cunit, 0);
        if (comp == null) {
            return;
        }
        TagValidator tv = new TagValidator(cunit, tags, annotations);
        comp.accept((ASTVisitor)tv);
        IApiProblem[] iApiProblemArray = tagProblems = tv.getProblems();
        int n = tagProblems.length;
        int n2 = 0;
        while (n2 < n) {
            IApiProblem tagProblem = iApiProblemArray[n2];
            this.addProblem(tagProblem);
            ++n2;
        }
    }

    private void checkApiUsage(IBuildContext context, IApiComponent component, IProgressMonitor monitor) {
        block9: {
            if (this.ignoreApiUsageScan()) {
                if (ApiPlugin.DEBUG_API_ANALYZER) {
                    System.out.println("Ignoring API usage scan");
                }
                return;
            }
            IApiTypeContainer scope = null;
            if (context.hasTypes()) {
                String[] typenames = this.getApiUseTypes(context);
                if (typenames.length < 1) {
                    return;
                }
                scope = this.getSearchScope(component, typenames);
            } else {
                scope = this.getSearchScope(component, null);
            }
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(BuilderMessages.checking_api_usage, component.getSymbolicName()), (int)2);
            ReferenceAnalyzer analyzer = new ReferenceAnalyzer();
            try {
                long start = System.currentTimeMillis();
                IApiProblem[] illegal = analyzer.analyze(component, scope, (IProgressMonitor)localMonitor.split(2));
                long end = System.currentTimeMillis();
                if (ApiPlugin.DEBUG_API_ANALYZER) {
                    System.out.println("API usage scan: " + (end - start) + " ms\t" + illegal.length + " problems");
                }
                IApiProblem[] iApiProblemArray = illegal;
                int n = illegal.length;
                int n2 = 0;
                while (n2 < n) {
                    IApiProblem element = iApiProblemArray[n2];
                    this.addProblem(element);
                    ++n2;
                }
            }
            catch (CoreException ce) {
                if (!ApiPlugin.DEBUG_API_ANALYZER) break block9;
                ApiPlugin.log(ce);
            }
        }
    }

    String[] getApiUseTypes(IBuildContext context) {
        if (context.hasTypes()) {
            int n;
            int n2;
            String[] stringArray;
            String[] deptypes = null;
            int size = 0;
            if (context.hasDescriptionDependents()) {
                deptypes = context.getDescriptionDependentTypes();
                size += deptypes.length;
            }
            String[] structtypes = context.getStructurallyChangedTypes();
            HashSet<String> typenames = new HashSet<String>(size + structtypes.length);
            if (deptypes != null) {
                stringArray = deptypes;
                n2 = deptypes.length;
                n = 0;
                while (n < n2) {
                    String deptype = stringArray[n];
                    if (deptype != null) {
                        typenames.add(deptype);
                    }
                    ++n;
                }
            }
            stringArray = structtypes;
            n2 = structtypes.length;
            n = 0;
            while (n < n2) {
                String structtype = stringArray[n];
                if (structtype != null) {
                    typenames.add(structtype);
                }
                ++n;
            }
            return typenames.toArray(new String[typenames.size()]);
        }
        return NO_TYPES;
    }

    private void checkCompatibility(String typeName, IApiComponent reference, IApiComponent component, IProgressMonitor monitor) throws CoreException {
        IDelta delta;
        SubMonitor subMonitor;
        block38: {
            String id = component.getSymbolicName();
            if (ApiPlugin.DEBUG_API_ANALYZER) {
                System.out.println("comparing components [" + reference.getSymbolicName() + "] and [" + id + "] for type [" + typeName + "]");
            }
            IApiTypeRoot classFile = null;
            try {
                classFile = "org.eclipse.swt".equals(id) ? component.findTypeRoot(typeName) : component.findTypeRoot(typeName, id);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_checking_compat, (int)4);
            delta = null;
            IApiComponent provider = null;
            boolean reexported = false;
            if (classFile == null) {
                String packageName = Signatures.getPackageName(typeName);
                IApiComponent[] providers = component.getBaseline().resolvePackage(component, packageName);
                int index = 0;
                while (classFile == null && index < providers.length) {
                    String id2;
                    IApiComponent p = providers[index];
                    if (!p.equals(component) && (classFile = "org.eclipse.swt".equals(id2 = p.getSymbolicName()) ? p.findTypeRoot(typeName) : p.findTypeRoot(typeName, id2)) != null) {
                        IRequiredComponentDescription[] components;
                        IRequiredComponentDescription[] iRequiredComponentDescriptionArray = components = component.getRequiredComponents();
                        int n = components.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IRequiredComponentDescription description = iRequiredComponentDescriptionArray[n2];
                            if (description.getId().equals(p.getSymbolicName()) && description.isExported()) {
                                reexported = true;
                                break;
                            }
                            ++n2;
                        }
                        provider = p;
                    }
                    ++index;
                }
            } else {
                provider = component;
            }
            subMonitor.split(1);
            if (classFile == null) {
                IApiTypeRoot referenceClassFile = null;
                try {
                    referenceClassFile = reference.findTypeRoot(typeName);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
                if (referenceClassFile != null) {
                    try {
                        IApiType type = referenceClassFile.getStructure();
                        if (type == null) {
                            return;
                        }
                        IApiDescription referenceApiDescription = reference.getApiDescription();
                        IApiAnnotations elementDescription = referenceApiDescription.resolveAnnotations(type.getHandle());
                        int restrictions = 0;
                        if (!(type.isMemberType() || type.isAnonymous() || type.isLocal())) {
                            int visibility = 65535;
                            if (elementDescription != null) {
                                restrictions = elementDescription.getRestrictions();
                                visibility = elementDescription.getVisibility();
                            }
                            if (Util.isDefault(type.getModifiers()) || Flags.isPrivate((int)type.getModifiers())) {
                                return;
                            }
                            if (VisibilityModifiers.isAPI(visibility)) {
                                String deltaComponentID = Util.getDeltaComponentVersionsId(reference);
                                delta = new Delta(deltaComponentID, 2, 3, 46, restrictions, 0, type.getModifiers(), 0, typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(reference)});
                            }
                        }
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e);
                    }
                }
                subMonitor.split(1);
            } else {
                this.fBuildState.cleanup(typeName);
                long time = System.currentTimeMillis();
                try {
                    IApiComponent exporter = null;
                    if (reexported) {
                        exporter = component;
                    }
                    delta = ApiComparator.compare(classFile, reference, provider, exporter, reference.getBaseline(), provider.getBaseline(), 1, (IProgressMonitor)subMonitor.split(1));
                }
                catch (OperationCanceledException operationCanceledException) {
                    if (ApiPlugin.DEBUG_API_ANALYZER) {
                        System.out.println("Trapped OperationCanceledException");
                    }
                    if (ApiPlugin.DEBUG_API_ANALYZER) {
                        System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
                    }
                    this.fPendingDeltaInfos.clear();
                    break block38;
                }
                catch (Exception e) {
                    try {
                        ApiPlugin.log(e);
                        break block38;
                    }
                    catch (Throwable elementDescription) {
                        throw elementDescription;
                    }
                    finally {
                        if (ApiPlugin.DEBUG_API_ANALYZER) {
                            System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
                        }
                        this.fPendingDeltaInfos.clear();
                    }
                }
                if (ApiPlugin.DEBUG_API_ANALYZER) {
                    System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
                }
                this.fPendingDeltaInfos.clear();
            }
        }
        if (delta == null) {
            return;
        }
        if (delta != ApiComparator.NO_DELTA) {
            List<IDelta> allDeltas = Util.collectAllDeltas(delta);
            subMonitor.subTask(BuilderMessages.BaseApiAnalyzer_processing_deltas);
            SubMonitor deltaLoopMonitor = subMonitor.split(1).setWorkRemaining(allDeltas.size());
            for (IDelta d : allDeltas) {
                deltaLoopMonitor.split(1);
                this.processDelta(d, reference, component);
            }
            if (!this.fPendingDeltaInfos.isEmpty()) {
                SubMonitor checkLoopMonitor = subMonitor.split(1).setWorkRemaining(this.fPendingDeltaInfos.size());
                subMonitor.subTask(BuilderMessages.BaseApiAnalyzer_checking_since_tags);
                for (IDelta d : this.fPendingDeltaInfos) {
                    checkLoopMonitor.split(1);
                    this.checkSinceTags((Delta)d, component);
                }
            }
        }
    }

    private void checkCompatibility(IApiComponent reference, IApiComponent component, IProgressMonitor monitor) {
        List<IDelta> allDeltas;
        long time = System.currentTimeMillis();
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_checking_compat, (int)3);
        IDelta delta = null;
        if (reference == null) {
            delta = new Delta(null, 3, 1, 3, null, component.getSymbolicName(), component.getSymbolicName());
            localmonitor.split(1);
        } else {
            try {
                delta = ApiComparator.compare(reference, component, 1, (IProgressMonitor)localmonitor.split(1));
            }
            finally {
                if (ApiPlugin.DEBUG_API_ANALYZER) {
                    System.out.println("Time spent for " + component.getSymbolicName() + " : " + (System.currentTimeMillis() - time) + "ms");
                }
                this.fPendingDeltaInfos.clear();
            }
        }
        if (delta == null) {
            return;
        }
        if (delta != ApiComparator.NO_DELTA && (allDeltas = Util.collectAllDeltas(delta)).size() != 0) {
            localmonitor.subTask(BuilderMessages.BaseApiAnalyzer_processing_deltas);
            SubMonitor processLoopMonitor = localmonitor.split(1).setWorkRemaining(allDeltas.size());
            for (IDelta d : allDeltas) {
                processLoopMonitor.split(1);
                this.processDelta(d, reference, component);
            }
            localmonitor.subTask(BuilderMessages.BaseApiAnalyzer_checking_since_tags);
            SubMonitor checkLoopMonitor = localmonitor.split(1).setWorkRemaining(this.fPendingDeltaInfos.size());
            if (!this.fPendingDeltaInfos.isEmpty()) {
                for (IDelta d : this.fPendingDeltaInfos) {
                    checkLoopMonitor.split(1);
                    this.checkSinceTags((Delta)d, component);
                }
            }
        }
    }

    private boolean ignoreExecutionEnvChanges() {
        if (this.fJavaProject == null) {
            return true;
        }
        IProject project = this.fJavaProject.getProject();
        ApiPlugin plugin = ApiPlugin.getDefault();
        boolean ignore = plugin.getSeverityLevel("changed_execution_env", project) == 0;
        return ignore;
    }

    private boolean shouldVersionChangeForExecutionEnvChanges(IApiComponent reference, IApiComponent component) {
        if (this.ignoreExecutionEnvChanges()) {
            return false;
        }
        String refversionval = reference.getVersion();
        String compversionval = component.getVersion();
        Version refversion = new Version(refversionval);
        Version compversion = new Version(compversionval);
        if (compversion.getMajor() > refversion.getMajor()) {
            return false;
        }
        if (compversion.getMajor() == refversion.getMajor() && compversion.getMinor() > refversion.getMinor()) {
            return false;
        }
        return this.hasExecutionEnvironmentChanged(reference, component);
    }

    private boolean hasExecutionEnvironmentChanged(IApiComponent reference, IApiComponent component) {
        ArrayList<String> compExecutionEnvList;
        ArrayList<String> refExecutionEnvList;
        String[] refExecutionEnv = null;
        String[] compExecutionEnv = null;
        try {
            refExecutionEnv = reference.getExecutionEnvironments();
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        try {
            compExecutionEnv = component.getExecutionEnvironments();
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        if (refExecutionEnv == null && compExecutionEnv != null) {
            return true;
        }
        if (refExecutionEnv != null && compExecutionEnv == null) {
            return true;
        }
        return refExecutionEnv != null && compExecutionEnv != null && (!(refExecutionEnvList = new ArrayList<String>(Arrays.asList(refExecutionEnv))).containsAll(compExecutionEnvList = new ArrayList<String>(Arrays.asList(compExecutionEnv))) || !compExecutionEnvList.containsAll(refExecutionEnvList));
    }

    private void checkSinceTags(Delta delta, IApiComponent component) {
        if (this.ignoreSinceTagCheck(null)) {
            return;
        }
        IMember member = Util.getIMember(delta, this.fJavaProject);
        if (member == null || member.isBinary()) {
            return;
        }
        ICompilationUnit cunit = member.getCompilationUnit();
        if (cunit == null) {
            return;
        }
        try {
            if (!cunit.isConsistent()) {
                cunit.makeConsistent(null);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        IApiProblem problem = null;
        ISourceRange nameRange = null;
        try {
            nameRange = member.getNameRange();
        }
        catch (JavaModelException e) {
            ApiPlugin.log(e);
            return;
        }
        if (nameRange == null) {
            return;
        }
        try {
            int offset = nameRange.getOffset();
            CompilationUnit comp = this.createAST((ITypeRoot)cunit, offset);
            if (comp == null) {
                return;
            }
            SinceTagChecker visitor = new SinceTagChecker(offset);
            comp.accept((ASTVisitor)visitor);
            String componentVersionId = delta.getComponentVersionId();
            String componentVersionString = null;
            componentVersionString = componentVersionId == null ? component.getVersion() : this.extractVersion(componentVersionId);
            try {
                String sinceVersion;
                if (visitor.hasNoComment() || visitor.isMissing()) {
                    if (this.ignoreSinceTagCheck("missing_since_tag")) {
                        if (ApiPlugin.DEBUG_API_ANALYZER) {
                            System.out.println("Ignoring missing since tag problem");
                        }
                        return;
                    }
                    StringBuilder buffer = new StringBuilder();
                    Version componentVersion = new Version(componentVersionString);
                    buffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                    problem = this.createSinceTagProblem(3, new String[]{Util.getDeltaArgumentString(delta)}, delta, member, String.valueOf(buffer));
                } else if (visitor.hasJavadocComment() && (sinceVersion = visitor.getSinceVersion()) != null) {
                    SinceTagVersion tagVersion = new SinceTagVersion(sinceVersion);
                    String postfixString = tagVersion.postfixString();
                    if (tagVersion.getVersion() == null || Util.getFragmentNumber(tagVersion.getVersionString()) > 2) {
                        if (this.ignoreSinceTagCheck("malformed_since_tag")) {
                            if (ApiPlugin.DEBUG_API_ANALYZER) {
                                System.out.println("Ignoring malformed since tag problem");
                            }
                            return;
                        }
                        StringBuilder buffer = new StringBuilder();
                        if (tagVersion.prefixString() != null) {
                            buffer.append(tagVersion.prefixString());
                        }
                        Version componentVersion = new Version(componentVersionString);
                        buffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                        if (postfixString != null) {
                            buffer.append(postfixString);
                        }
                        problem = this.createSinceTagProblem(2, new String[]{sinceVersion, Util.getDeltaArgumentString(delta)}, delta, member, String.valueOf(buffer));
                    } else {
                        if (this.ignoreSinceTagCheck("invalid_since_tag_version")) {
                            if (ApiPlugin.DEBUG_API_ANALYZER) {
                                System.out.println("Ignoring invalid tag version problem");
                            }
                            return;
                        }
                        StringBuilder accurateVersionBuffer = new StringBuilder();
                        Version componentVersion = new Version(componentVersionString);
                        accurateVersionBuffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                        String accurateVersion = String.valueOf(accurateVersionBuffer);
                        if (Util.isDifferentVersion(sinceVersion, accurateVersion)) {
                            StringBuilder buffer = new StringBuilder();
                            if (tagVersion.prefixString() != null) {
                                buffer.append(tagVersion.prefixString());
                            }
                            Version version = new Version(accurateVersion);
                            buffer.append(version.getMajor()).append('.').append(version.getMinor());
                            if (postfixString != null) {
                                buffer.append(postfixString);
                            }
                            String accurateSinceTagValue = String.valueOf(buffer);
                            problem = this.createSinceTagProblem(1, new String[]{sinceVersion, accurateSinceTagValue, Util.getDeltaArgumentString(delta)}, delta, member, accurateSinceTagValue);
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                ApiPlugin.log(e);
            }
        }
        catch (RuntimeException e) {
            ApiPlugin.log(e);
        }
        if (problem != null) {
            this.addProblem(problem);
        }
    }

    private String extractVersion(String componentVersionId) {
        int indexOfOpen = componentVersionId.lastIndexOf(40);
        return componentVersionId.substring(indexOfOpen + 1, componentVersionId.length() - 1);
    }

    private IApiProblem createSinceTagProblem(int kind, String[] messageargs, Delta info, IMember member, String version) {
        IResource resource;
        IType declaringType;
        block9: {
            try {
                declaringType = null;
                declaringType = member.getElementType() == 7 ? (IType)member : member.getDeclaringType();
                resource = Util.getResource(this.fJavaProject.getProject(), declaringType);
                if (resource != null) break block9;
                return null;
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
                return null;
            }
        }
        int lineNumber = 1;
        int charStart = 0;
        int charEnd = 1;
        String qtn = null;
        qtn = member instanceof IType ? ((IType)member).getFullyQualifiedName() : declaringType.getFullyQualifiedName();
        String[] messageArguments = null;
        if (!Util.isManifest(resource.getProjectRelativePath())) {
            messageArguments = messageargs;
            ICompilationUnit unit = member.getCompilationUnit();
            ISourceRange range = member.getNameRange();
            charStart = range.getOffset();
            charEnd = charStart + range.getLength();
            try {
                IDocument document = Util.getDocument(unit);
                lineNumber = document.getLineOfOffset(charStart);
            }
            catch (BadLocationException e) {
                ApiPlugin.log(e);
            }
        } else if (!(member instanceof IType)) {
            int length = messageargs.length;
            messageArguments = new String[length];
            System.arraycopy(messageargs, 0, messageArguments, 0, length);
            StringBuilder buffer = new StringBuilder();
            buffer.append(qtn).append('.').append(messageargs[length - 1]);
            messageArguments[length - 1] = String.valueOf(buffer);
        } else {
            messageArguments = messageargs;
        }
        return ApiProblemFactory.newApiSinceTagProblem(resource.getProjectRelativePath().toPortableString(), qtn, messageArguments, new String[]{"version", "apiMarkerID", "org.eclipse.jdt.internal.core.JavaModelManager.handleId"}, new Object[]{version, 5, member.getHandleIdentifier()}, lineNumber, charStart, charEnd, info.getElementType(), kind);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IApiProblem createCompatibilityProblem(IDelta delta, IApiComponent reference, IApiComponent component) {
        try {
            Version referenceVersion = new Version(reference.getVersion());
            Version componentVersion = new Version(component.getVersion());
            if (referenceVersion.getMajor() < componentVersion.getMajor() && !this.reportApiBreakageWhenMajorVersionIncremented()) {
                this.fBuildState.addBreakingChange(delta);
                return null;
            }
            IResource resource = null;
            IType type = null;
            int lineNumber = 0;
            int charStart = -1;
            int charEnd = 1;
            IMember member = null;
            if (this.fJavaProject != null) {
                int flag;
                IProject project;
                IProject project2;
                IType sourceType;
                try {
                    type = this.fJavaProject.findType(delta.getTypeName().replace('$', '.'));
                    IType typeInProject = Util.getTypeInSameJavaProject(type, delta.getTypeName(), this.fJavaProject);
                    if (typeInProject != null) {
                        type = typeInProject;
                    }
                }
                catch (JavaModelException e) {
                    ApiPlugin.log(e);
                }
                if (type instanceof BinaryType && (sourceType = Util.findSourceTypeinJavaProject(this.fJavaProject, delta.getTypeName().replace('$', '.'))) != null) {
                    type = sourceType;
                }
                if (!(project2 = (resource = Util.getResource(project = this.fJavaProject.getProject(), type)).getProject()).equals((Object)project) && (flag = delta.getFlags()) == 71) {
                    resource = project.findMember((IPath)new Path("META-INF/MANIFEST.MF"));
                    charStart = 0;
                    charEnd = 0;
                    lineNumber = 1;
                }
                if (resource == null) {
                    return null;
                }
                if (!Util.isManifest(resource.getProjectRelativePath())) {
                    member = Util.getIMember(delta, this.fJavaProject);
                }
                if (member != null && !member.isBinary() && member.exists()) {
                    ISourceRange range = member.getNameRange();
                    charStart = range.getOffset();
                    charEnd = charStart + range.getLength();
                    try {
                        IDocument document = Util.getDocument(member.getCompilationUnit());
                        lineNumber = document.getLineOfOffset(charStart);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            String path = null;
            if (resource != null) {
                path = resource.getProjectRelativePath().toPortableString();
            }
            return ApiProblemFactory.newApiProblem(path, delta.getTypeName(), delta.getArguments(), new String[]{"org.eclipse.jdt.internal.core.JavaModelManager.handleId", "apiMarkerID"}, new Object[]{member == null ? null : member.getHandleIdentifier(), 2}, lineNumber, charStart, charEnd, 0x10000000, delta.getElementType(), delta.getKind(), delta.getFlags());
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return null;
        }
    }

    private void createApiComponentResolutionProblem(IApiComponent component, String message) {
        IApiProblem problem = ApiProblemFactory.newApiComponentResolutionProblem(Path.EMPTY.toString(), new String[]{component.getSymbolicName(), message}, new String[]{"apiMarkerID"}, new Object[]{8}, 7, 1);
        this.addProblem(problem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processDelta(IDelta delta, IApiComponent reference, IApiComponent component) {
        int flags = delta.getFlags();
        int kind = delta.getKind();
        int modifiers = delta.getNewModifiers();
        if (DeltaProcessor.isCompatible(delta)) {
            String typeName;
            if (RestrictionModifiers.isReferenceRestriction(delta.getCurrentRestrictions()) || !Util.isVisible(modifiers)) return;
            if (Flags.isProtected((int)modifiers) && (typeName = delta.getTypeName()) != null) {
                IApiTypeRoot typeRoot = null;
                IApiMember type = null;
                try {
                    String id = component.getSymbolicName();
                    typeRoot = "org.eclipse.swt".equals(id) ? component.findTypeRoot(typeName) : component.findTypeRoot(typeName, id);
                    if (typeRoot == null) {
                        String packageName = Signatures.getPackageName(typeName);
                        IApiComponent[] providers = component.getBaseline().resolvePackage(component, packageName);
                        int index = 0;
                        while (typeRoot == null && index < providers.length) {
                            IApiComponent p = providers[index];
                            if (!p.equals(component)) {
                                String id2 = p.getSymbolicName();
                                typeRoot = "org.eclipse.swt".equals(id2) ? p.findTypeRoot(typeName) : p.findTypeRoot(typeName, id2);
                            }
                            ++index;
                        }
                    }
                    if (typeRoot == null) {
                        return;
                    }
                    type = typeRoot.getStructure();
                }
                catch (CoreException coreException) {}
                if (type == null || Flags.isFinal((int)type.getModifiers())) {
                    return;
                }
            }
            switch (kind) {
                case 1: {
                    String deltaDetails;
                    switch (flags) {
                        case 8: 
                        case 12: 
                        case 16: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 46: 
                        case 48: 
                        case 73: {
                            if (ApiPlugin.DEBUG_API_ANALYZER) {
                                deltaDetails = "Delta : " + Util.getDetail(delta);
                                System.out.println(String.valueOf(deltaDetails) + " is compatible");
                            }
                            this.fBuildState.addCompatibleChange(delta);
                            this.fPendingDeltaInfos.add(delta);
                            return;
                        }
                        case 39: {
                            this.fBuildState.addCompatibleChange(delta);
                            return;
                        }
                    }
                    return;
                }
                case 2: {
                    String deltaDetails;
                    if (flags == 15) {
                        this.fBuildState.addCompatibleChange(delta);
                    }
                    if (flags != 22) return;
                    if (ApiPlugin.DEBUG_API_ANALYZER) {
                        deltaDetails = "Delta : " + Util.getDetail(delta);
                        System.out.println(String.valueOf(deltaDetails) + " is compatible");
                    }
                    this.fBuildState.addCompatibleChange(delta);
                    this.fPendingDeltaInfos.add(delta);
                    return;
                }
                case 3: {
                    this.fBuildState.addCompatibleChange(delta);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        block10 : switch (kind) {
            case 1: {
                switch (flags) {
                    case 8: 
                    case 12: 
                    case 16: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 48: 
                    case 73: {
                        if (!Util.isVisible(modifiers)) break block10;
                        if (ApiPlugin.DEBUG_API_ANALYZER) {
                            String deltaDetails = "Delta : " + Util.getDetail(delta);
                            System.err.println(String.valueOf(deltaDetails) + " is not compatible");
                        }
                        this.fPendingDeltaInfos.add(delta);
                        break block10;
                    }
                    case 42: 
                    case 43: {
                        this.fBuildState.addBreakingChange(delta);
                        break block10;
                    }
                }
                break;
            }
            case 2: {
                switch (flags) {
                    case 42: {
                        this.fBuildState.addBreakingChange(delta);
                        break block10;
                    }
                }
                break;
            }
        }
        IApiProblem problem = this.createCompatibilityProblem(delta, reference, component);
        if (!this.addProblem(problem)) return;
        this.fBuildState.addBreakingChange(delta);
    }

    private void checkApiComponentVersion(IApiComponent reference, IApiComponent component) throws CoreException {
        IDelta[] compatibleChanges;
        IDelta[] breakingChanges;
        Version newversion;
        Version compversion;
        Version refversion;
        String compversionval;
        String refversionval;
        IApiProblem problem;
        block50: {
            ReexportedBundleVersionInfo info;
            block51: {
                block49: {
                    if (reference == null || component == null) {
                        if (ApiPlugin.DEBUG_API_ANALYZER) {
                            System.out.println("Ignoring component version check");
                        }
                        return;
                    }
                    problem = null;
                    refversionval = reference.getVersion();
                    compversionval = component.getVersion();
                    refversion = new Version(refversionval);
                    compversion = new Version(compversionval);
                    newversion = null;
                    if (this.ignoreComponentVersionCheck()) {
                        if (!this.ignoreExecutionEnvChanges() && this.shouldVersionChangeForExecutionEnvChanges(reference, component)) {
                            newversion = new Version(compversion.getMajor(), compversion.getMinor() + 1, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                            problem = this.createVersionProblem(7, new String[]{compversionval, refversionval}, String.valueOf(newversion), "");
                        }
                        if (problem != null) {
                            this.addProblem(problem);
                        }
                        if (ApiPlugin.DEBUG_API_ANALYZER) {
                            System.out.println("Ignoring component version check");
                        }
                        return;
                    }
                    if (ApiPlugin.DEBUG_API_ANALYZER) {
                        System.out.println("reference version of " + reference.getSymbolicName() + " : " + refversion);
                        System.out.println("component version of " + component.getSymbolicName() + " : " + compversion);
                    }
                    breakingChanges = this.fBuildState.getBreakingChanges();
                    compatibleChanges = this.fBuildState.getCompatibleChanges();
                    if (breakingChanges.length == 0) break block49;
                    if (compversion.getMajor() <= refversion.getMajor()) {
                        newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(1, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(breakingChanges));
                    }
                    break block50;
                }
                if (compatibleChanges.length != 0) {
                    if (compversion.getMajor() != refversion.getMajor()) {
                        if (this.reportMajorVersionCheckWithoutBreakingChange()) {
                            newversion = new Version(refversion.getMajor(), refversion.getMinor() + 1, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                            problem = this.createVersionProblem(3, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(compatibleChanges));
                        }
                    } else if (compversion.getMinor() <= refversion.getMinor()) {
                        newversion = new Version(compversion.getMajor(), compversion.getMinor() + 1, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(2, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(compatibleChanges));
                    }
                } else if (compversion.getMajor() != refversion.getMajor()) {
                    if (this.reportMajorVersionCheckWithoutBreakingChange()) {
                        newversion = new Version(refversion.getMajor(), refversion.getMinor(), refversion.getMicro(), refversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(3, new String[]{compversionval, refversionval}, String.valueOf(newversion), "");
                    }
                } else if (compversion.getMinor() != refversion.getMinor()) {
                    if (this.reportUnnecessaryMinorMicroVersionCheck() && !this.hasExecutionEnvironmentChanged(reference, component)) {
                        newversion = new Version(refversion.getMajor(), refversion.getMinor(), refversion.getMicro(), refversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(4, new String[]{compversionval, refversionval}, String.valueOf(newversion), "");
                    }
                } else if (this.shouldVersionChangeForExecutionEnvChanges(reference, component)) {
                    newversion = new Version(compversion.getMajor(), compversion.getMinor() + 1, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                    problem = this.createVersionProblem(7, new String[]{compversionval, refversionval}, String.valueOf(newversion), "");
                }
                info = null;
                if (problem == null) break block51;
                block0 : switch (problem.getKind()) {
                    case 3: {
                        info = this.checkBundleVersionsOfReexportedBundles(reference, component);
                        if (info != null) {
                            switch (info.kind) {
                                case 5: {
                                    problem = null;
                                    break block0;
                                }
                                case 6: {
                                    break block0;
                                }
                            }
                            break;
                        }
                        break block50;
                    }
                    case 2: {
                        info = this.checkBundleVersionsOfReexportedBundles(reference, component);
                        if (info != null) {
                            switch (info.kind) {
                                case 5: {
                                    newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                                    problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                                    break block0;
                                }
                            }
                            break;
                        }
                        break block50;
                    }
                    case 4: {
                        info = this.checkBundleVersionsOfReexportedBundles(reference, component);
                        if (info != null) {
                            switch (info.kind) {
                                case 5: {
                                    newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                                    problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                                    break block0;
                                }
                                case 6: {
                                    problem = null;
                                    break block0;
                                }
                            }
                            break;
                        }
                        break block50;
                    }
                }
                break block50;
            }
            info = this.checkBundleVersionsOfReexportedBundles(reference, component);
            if (info != null) {
                switch (info.kind) {
                    case 5: {
                        if (compversion.getMajor() > refversion.getMajor()) break;
                        newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                        break;
                    }
                    case 6: {
                        if (compversion.getMinor() > refversion.getMinor() || compversion.getMajor() > refversion.getMajor()) break;
                        newversion = new Version(compversion.getMajor(), compversion.getMinor() + 1, 0, compversion.getQualifier());
                        problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                        break;
                    }
                }
            }
        }
        if (problem != null) {
            this.addProblem(problem);
        }
        if (problem == null) {
            if ((breakingChanges.length > 0 || compatibleChanges.length > 0) && this.reportUnnecessaryMinorMicroVersionCheck() && this.checkIfMajorOrMinorVersionIncreased(compversion, refversion) && this.hasMicroVersionIncreased(compversion) && (problem = this.createVersionProblem(8, new String[]{compversionval, refversionval}, String.valueOf(newversion = new Version(compversion.getMajor(), compversion.getMinor(), 0, compversion.getQualifier() != null ? QUALIFIER : null)), "")) != null) {
                this.addProblem(problem);
            }
            if (breakingChanges.length > 0 && this.reportUnnecessaryMinorMicroVersionCheck() && this.checkIfMajorVersionIncreased(compversion, refversion) && this.hasMinorVersionIncreased(compversion) && (problem = this.createVersionProblem(9, new String[]{compversionval, refversionval}, String.valueOf(newversion = new Version(compversion.getMajor(), 0, 0, compversion.getQualifier() != null ? QUALIFIER : null)), "")) != null) {
                this.addProblem(problem);
            }
        }
    }

    private boolean hasMinorVersionIncreased(Version compversion) {
        return compversion.getMinor() > 0;
    }

    private boolean checkIfMajorVersionIncreased(Version compversion, Version refversion) {
        return compversion.getMajor() > refversion.getMajor();
    }

    private boolean hasMicroVersionIncreased(Version compversion) {
        return compversion.getMicro() > 0;
    }

    private boolean checkIfMajorOrMinorVersionIncreased(Version compversion, Version refversion) {
        if (compversion.getMajor() > refversion.getMajor()) {
            return true;
        }
        return compversion.getMinor() > refversion.getMinor();
    }

    private String collectDetails(IDelta[] deltas) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        int max = Math.min(20, deltas.length);
        int i = 0;
        while (i < max) {
            printWriter.print("- ");
            printWriter.println(deltas[i].getMessage());
            if (i == max - 1 && max < deltas.length) {
                printWriter.println(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_more_version_problems, (Object)(deltas.length - max)));
            }
            ++i;
        }
        printWriter.flush();
        printWriter.close();
        return String.valueOf(writer.getBuffer());
    }

    private IApiProblem createVersionProblem(int kind, String[] messageargs, String version, String description) {
        int charEnd;
        int charStart;
        int lineNumber;
        String path;
        block29: {
            char[] contents;
            block28: {
                IResource manifestFile = null;
                path = "META-INF/MANIFEST.MF";
                if (this.fJavaProject != null) {
                    manifestFile = Util.getManifestFile(this.fJavaProject.getProject());
                }
                lineNumber = -1;
                charStart = 0;
                charEnd = 1;
                contents = null;
                if (manifestFile != null && manifestFile.getType() == 1) {
                    path = manifestFile.getProjectRelativePath().toPortableString();
                    IFile file = (IFile)manifestFile;
                    InputStream inputStream = null;
                    BufferedReader reader = null;
                    try {
                        try {
                            inputStream = file.getContents(true);
                            contents = Util.getInputStreamAsCharArray(inputStream, -1, StandardCharsets.UTF_8);
                            reader = new LineNumberReader(new BufferedReader(new StringReader(new String(contents))));
                            int lineCounter = 0;
                            String line = null;
                            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                                ++lineCounter;
                                if (!line.startsWith("Bundle-Version")) continue;
                                lineNumber = lineCounter;
                                break;
                            }
                        }
                        catch (IOException | CoreException throwable) {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                if (reader != null) {
                                    reader.close();
                                }
                                break block28;
                            }
                            catch (IOException iOException) {}
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (lineNumber != -1 && contents != null) {
                int index = CharOperation.indexOf((char[])"Bundle-Version".toCharArray(), contents, (boolean)true);
                int i = index + "Bundle-Version".length() + 1;
                int max = contents.length;
                while (i < max) {
                    char currentCharacter = contents[i];
                    if (!CharOperation.isWhitespace((char)currentCharacter)) {
                        charStart = i;
                        break;
                    }
                    ++i;
                }
                i = charStart + 1;
                max = contents.length;
                while (i < max) {
                    switch (contents[i]) {
                        case '\n': 
                        case '\r': {
                            charEnd = i;
                            break block29;
                        }
                        default: {
                            ++i;
                        }
                    }
                }
            } else {
                lineNumber = 1;
            }
        }
        return ApiProblemFactory.newApiVersionNumberProblem(path, null, messageargs, new String[]{"version", "apiMarkerID", "description"}, new Object[]{version, 4, description}, lineNumber, charStart, charEnd, 7, kind);
    }

    private void checkDefaultBaselineSet() {
        if (this.ignoreDefaultBaselineCheck()) {
            if (ApiPlugin.DEBUG_API_ANALYZER) {
                System.out.println("Ignoring check for default API baseline");
            }
            return;
        }
        if (ApiPlugin.DEBUG_API_ANALYZER) {
            System.out.println("Checking if the default API baseline is set");
        }
        IApiProblem problem = ApiProblemFactory.newApiBaselineProblem(Path.EMPTY.toString(), new String[]{"apiMarkerID"}, new Object[]{1}, 7, 1);
        this.addProblem(problem);
    }

    public void checkBaselineMismatch(IApiBaseline baseline, IApiBaseline workspaceBaseline) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IMarker[] findMarkers;
            IMarker[] iMarkerArray = findMarkers = root.findMarkers("org.eclipse.pde.api.tools.api_profile", false, 0);
            int n = findMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker iMarker = iMarkerArray[n2];
                iMarker.delete();
                ++n2;
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        if (baseline == null || workspaceBaseline == null) {
            return;
        }
        int severityLevel = ApiPlugin.getDefault().getSeverityLevel("missing_default_api_profile", null);
        if (severityLevel == 0) {
            return;
        }
        IApiComponent[] workspacesComponents = workspaceBaseline.getApiComponents();
        boolean found = false;
        IApiComponent[] iApiComponentArray = workspacesComponents;
        int n = workspacesComponents.length;
        int n3 = 0;
        while (n3 < n) {
            IApiComponent apiComponent;
            IApiComponent iApiComponent = iApiComponentArray[n3];
            if (iApiComponent instanceof ProjectComponent && (apiComponent = baseline.getApiComponent(iApiComponent.getSymbolicName())) != null) {
                found = true;
                break;
            }
            ++n3;
        }
        if (found) {
            return;
        }
        IApiProblem problem = ApiProblemFactory.newApiBaselineProblem(Path.EMPTY.toString(), new String[]{"apiMarkerID"}, new Object[]{1}, 7, 2);
        this.addProblem(problem);
    }

    private IJavaProject getJavaProject(IApiComponent component) {
        if (component instanceof ProjectComponent) {
            ProjectComponent pp = (ProjectComponent)component;
            return pp.getJavaProject();
        }
        return null;
    }

    private boolean addProblem(IApiProblem problem) {
        if (problem == null || this.isProblemFiltered(problem)) {
            return false;
        }
        return this.fProblems.add(problem);
    }

    private boolean isProblemFiltered(IApiProblem problem) {
        if (this.fJavaProject == null) {
            String key;
            boolean filtered;
            if (this.fFilterStore != null && (filtered = this.fFilterStore.isFiltered(problem))) {
                return true;
            }
            if (this.fPreferences != null && (key = ApiProblemFactory.getProblemSeverityId(problem)) != null) {
                String value = this.fPreferences.getProperty(key, null);
                return "Ignore".equals(value);
            }
            return false;
        }
        IProject project = this.fJavaProject.getProject();
        if (ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId(problem), project) == 0) {
            return true;
        }
        ApiBaselineManager manager = ApiBaselineManager.getManager();
        IApiBaseline baseline = manager.getWorkspaceBaseline();
        if (baseline == null) {
            return false;
        }
        IApiComponent component = baseline.getApiComponent(project);
        if (component != null) {
            try {
                IApiFilterStore filterStore = component.getFilterStore();
                if (filterStore != null) {
                    return filterStore.isFiltered(problem);
                }
            }
            catch (CoreException e) {
                ApiPlugin.log("Failed to get filter store for " + component.getName(), e);
            }
        }
        return false;
    }

    private static class ReexportedBundleVersionInfo {
        String componentID;
        int kind;

        ReexportedBundleVersionInfo(String componentID, int kind) {
            this.componentID = componentID;
            this.kind = kind;
        }
    }
}

