/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui.providers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class ResourceLinksContentProvider
implements ITreeContentProvider {
    protected TreeViewer viewer;
    protected ResourceSet input;
    protected Map<Resource, Set<URI>> allLinks;

    public void dispose() {
        this.allLinks = null;
        this.input = null;
        this.viewer = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.input = newInput instanceof ResourceSet ? (ResourceSet)newInput : null;
        this.allLinks = null;
    }

    public Object[] getElements(Object inputElement) {
        return this.allLinks().keySet().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Resource) {
            Set<URI> uris = this.allLinks.get(parentElement);
            if (uris == null) {
                return new Object[0];
            }
            return uris.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        TransactionalEditingDomain domain;
        Resource resource;
        if (element instanceof Resource && EMFHelper.isReadOnly((Resource)(resource = (Resource)element), (EditingDomain)(domain = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(resource.getResourceSet())))) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    protected Map<Resource, Set<URI>> allLinks() {
        this.allLinks = new HashMap<Resource, Set<URI>>();
        if (this.input == null) {
            return this.allLinks;
        }
        for (Resource resource : this.input.getResources()) {
            HashSet<URI> allReferencedURIs = new HashSet<URI>();
            this.allLinks.put(resource, allReferencedURIs);
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                EObject nextElement = (EObject)allContents.next();
                EList allReferencedEObjects = nextElement.eCrossReferences();
                EContentsEList.FeatureIterator iterator = (EContentsEList.FeatureIterator)allReferencedEObjects.iterator();
                while (iterator.hasNext()) {
                    EObject referencedEObject = (EObject)iterator.next();
                    if (referencedEObject.eIsProxy()) {
                        allReferencedURIs.add(EcoreUtil.getURI((EObject)referencedEObject).trimFragment());
                        continue;
                    }
                    if (referencedEObject.eResource() == null || referencedEObject.eResource() == resource || iterator.feature().isTransient()) continue;
                    allReferencedURIs.add(referencedEObject.eResource().getURI());
                }
            }
        }
        Iterator<Resource> removeEmptyLinks = this.allLinks.keySet().iterator();
        while (removeEmptyLinks.hasNext()) {
            Resource current = removeEmptyLinks.next();
            if (!this.allLinks.get(current).isEmpty()) continue;
            removeEmptyLinks.remove();
        }
        return this.allLinks;
    }
}

