/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractParametricAction;

public class SelectAction
extends AbstractParametricAction {
    public static final String SELECT_ALL = "selectAll";
    public static final String SELECT_ALL_SHAPES = "selectAllShapes";
    public static final String SELECT_ALL_CONNECTORS = "selectAllConnectors";
    protected boolean selectShapes = false;
    protected boolean selectConnections = false;

    public SelectAction(String parameter, List<IGraphicalEditPart> selectedElements) {
        super(parameter, selectedElements);
        this.initAction();
    }

    protected void initAction() {
        if (SELECT_ALL.equals(this.getParameter())) {
            this.selectShapes = true;
            this.selectConnections = true;
        } else if (SELECT_ALL_SHAPES.equals(this.getParameter())) {
            this.selectShapes = true;
        } else if (SELECT_ALL_CONNECTORS.equals(this.getParameter())) {
            this.selectConnections = true;
        }
    }

    @Override
    public boolean isEnabled() {
        return !this.getSelection().isEmpty();
    }

    @Override
    public void doRun(IProgressMonitor progressMonitor) {
        this.getDiagramGraphicalViewer().setSelection((ISelection)new StructuredSelection(this.createOperationSet()));
    }

    @Override
    protected List<IGraphicalEditPart> getSelection() {
        return super.getSelection();
    }

    protected List createOperationSet() {
        List<IGraphicalEditPart> selection = this.getSelection();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList selectables = new ArrayList();
        EditPart primaryEP = (EditPart)selection.get(selection.size() - 1);
        ArrayList nodeEditParts = new ArrayList();
        nodeEditParts.addAll(this.getSelectableNodes(primaryEP));
        if (this.selectShapes) {
            selectables.addAll(nodeEditParts);
        }
        if (this.selectConnections) {
            selectables.addAll(this.addSelectableConnections(nodeEditParts));
        }
        return this.filterEditPartsMatching(selectables, this.getSelectionConditional());
    }

    protected List getSelectableNodes(EditPart editpart) {
        if (editpart == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList retval = new ArrayList();
        this.getSelectableNodesInside(editpart, true, retval);
        return retval;
    }

    private void getSelectableNodesInside(EditPart editpart, boolean topLevel, List retval) {
        if (editpart instanceof ISurfaceEditPart) {
            this.getSelectableChildrenNodes(editpart, retval);
        } else if (editpart instanceof IPrimaryEditPart) {
            if (topLevel) {
                if (editpart instanceof ConnectionEditPart) {
                    ConnectionEditPart connection = (ConnectionEditPart)editpart;
                    EditPart source = connection.getSource();
                    EditPart target = connection.getTarget();
                    if (source != null && target != null) {
                        this.getSelectableNodesInside(source, true, retval);
                        if (target.getParent() != source.getParent()) {
                            this.getSelectableNodesInside(target, true, retval);
                        }
                    }
                } else {
                    this.getSelectableNodesInside(editpart.getParent(), true, retval);
                }
            } else {
                if (editpart.isSelectable()) {
                    retval.add(editpart);
                }
                if (!(editpart instanceof GroupEditPart)) {
                    this.getSelectableChildrenNodes(editpart, retval);
                }
            }
        }
    }

    private void getSelectableChildrenNodes(EditPart editpart, List retval) {
        for (EditPart child : editpart.getChildren()) {
            this.getSelectableNodesInside(child, false, retval);
        }
    }

    private void getBorderItemEditParts(EditPart parent, Set retval) {
        for (EditPart child : parent.getChildren()) {
            if (child instanceof IBorderItemEditPart) {
                retval.add(child);
                retval.addAll(child.getChildren());
            }
            this.getBorderItemEditParts(child, retval);
        }
    }

    protected List addSelectableConnections(List editparts) {
        ArrayList<ConnectionEditPart> selectableConnections = new ArrayList<ConnectionEditPart>();
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        HashSet connnectableEditParts = new HashSet(editparts);
        ListIterator li = editparts.listIterator();
        while (li.hasNext()) {
            EditPart ep = (EditPart)li.next();
            this.getBorderItemEditParts(ep, connnectableEditParts);
            if (!(ep instanceof GroupEditPart)) continue;
            connnectableEditParts.addAll(((GroupEditPart)ep).getShapeChildren());
        }
        if (diagramEditPart != null) {
            for (ConnectionEditPart connection : diagramEditPart.getConnections()) {
                if (!this.canSelectConnection(connection, connnectableEditParts)) continue;
                selectableConnections.add(connection);
            }
        }
        return selectableConnections;
    }

    private boolean canSelectConnection(ConnectionEditPart connection, Set connectableEditParts) {
        EditPart connectionSource = connection.getSource();
        EditPart connectionTarget = connection.getTarget();
        boolean sourceHasSelectable = false;
        boolean targetHasSelectable = false;
        if (connectableEditParts.contains(connectionSource) || connectableEditParts.contains(connectionTarget)) {
            return true;
        }
        if (connectionSource instanceof ConnectionEditPart) {
            sourceHasSelectable = this.canSelectConnection((ConnectionEditPart)connectionSource, connectableEditParts);
        }
        if (!sourceHasSelectable && connectionTarget instanceof ConnectionEditPart) {
            targetHasSelectable = this.canSelectConnection((ConnectionEditPart)connectionTarget, connectableEditParts);
        }
        return sourceHasSelectable || targetHasSelectable;
    }

    protected EditPartViewer.Conditional getSelectionConditional() {
        return new EditPartViewer.Conditional(){

            public boolean evaluate(EditPart editpart) {
                return editpart.isSelectable();
            }
        };
    }

    protected List filterEditPartsMatching(List list, EditPartViewer.Conditional condition) {
        ArrayList<EditPart> matchList = new ArrayList<EditPart>();
        for (EditPart ep : list) {
            if (!condition.evaluate(ep)) continue;
            matchList.add(ep);
        }
        return matchList;
    }
}

