/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.linklf.common;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusLabelEditPart;

public class LinkLabelPositionEditPolicy
extends AbstractEditPolicy {
    public static final String KEY = "LinkLabelPositionEditPolicy";

    public PapyrusLabelEditPart getHost() {
        return (PapyrusLabelEditPart)super.getHost();
    }

    private View getView() {
        return this.getHost().getNotationView();
    }

    public Command getCommand(Request request) {
        if (!this.understandsRequest(request)) {
            return null;
        }
        NamedStyle style = this.getView().getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), "IS_UPDATED_POSITION");
        Boolean updated = style == null ? false : (Boolean)style.eGet((EStructuralFeature)NotationPackage.eINSTANCE.getBooleanValueStyle_BooleanValue());
        if (updated.booleanValue()) {
            return null;
        }
        Point refOldPoint = this.getHost().getBaseReferencePoint();
        Point refNewPoint = this.getHost().getUpdatedRefencePoint();
        Point moveDelta = new Point(refOldPoint.x - refNewPoint.x, refOldPoint.y - refNewPoint.y);
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move");
        req.setMoveDelta(moveDelta);
        req.setEditParts((EditPart)this.getHost());
        req.setSizeDelta(new Dimension());
        View view = this.getHost().getNotationView();
        SetBooleanStyleTransactionalCommand cmd = new SetBooleanStyleTransactionalCommand(this.getHost().getEditingDomain(), view, true);
        CompoundCommand compound = new CompoundCommand();
        compound.add(this.getHost().getCommand((Request)req));
        compound.add(GMFtoGEFCommandWrapper.wrap((ICommand)cmd));
        return compound;
    }

    public boolean understandsRequest(Request request) {
        return request instanceof BendpointRequest;
    }

    private static class SetBooleanStyleTransactionalCommand
    extends AbstractTransactionalCommand {
        private final boolean myValue;
        private final View myView;

        public SetBooleanStyleTransactionalCommand(TransactionalEditingDomain domain, View view, boolean value) {
            super(domain, "Set boolean style", null);
            this.myValue = value;
            this.myView = view;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            boolean createStyle;
            NamedStyle valueStyle = this.myView.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), "IS_UPDATED_POSITION");
            boolean bl = createStyle = valueStyle == null;
            if (createStyle) {
                valueStyle = this.createStyle();
            }
            valueStyle.eSet((EStructuralFeature)NotationPackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)this.myValue);
            return new CommandResult((IStatus)new Status(0, "org.eclipse.papyrus.infra.gmfdiag.common", "New style created"));
        }

        protected NamedStyle createStyle() {
            NamedStyle result = (NamedStyle)this.myView.createStyle(NotationPackage.eINSTANCE.getBooleanValueStyle());
            result.setName("IS_UPDATED_POSITION");
            return result;
        }
    }
}

