/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.extension.diagrameditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.extension.ExtensionException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.ui.editorsfactory.PageModelFactoryRegistry;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.EditorDescriptor;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.EditorDescriptorExtensionFactory;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.EditorFactoryProxy;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.EditorIconFactory;

public class PluggableEditorFactoryReader {
    protected List<EditorDescriptor> editorDescriptors;
    public static final String EDITOR_EXTENSION_ID = "papyrusDiagram";
    protected String extensionPointNamespace;
    private boolean isExtensionLoaded = false;

    public PluggableEditorFactoryReader(String extensionPointNamespace) {
        this.extensionPointNamespace = extensionPointNamespace;
        this.editorDescriptors = new ArrayList<EditorDescriptor>();
    }

    public void populate(PageModelFactoryRegistry pageModelFactoryRegistry, ServicesRegistry serviceRegistry) {
        for (EditorDescriptor desc : this.getEditorDescriptors()) {
            pageModelFactoryRegistry.add(new EditorFactoryProxy(serviceRegistry, desc));
        }
    }

    public void populate(PageIconsRegistry registry) {
        for (EditorDescriptor desc : this.getEditorDescriptors()) {
            registry.add(new EditorIconFactory(desc));
        }
    }

    public List<EditorDescriptor> getEditorDescriptors() {
        if (!this.isExtensionLoaded) {
            this.isExtensionLoaded = true;
            this.initializeEditorDescriptors();
        }
        return this.editorDescriptors;
    }

    private void initializeEditorDescriptors() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointNamespace, EDITOR_EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                if ("editorDiagram".equals(ele.getName())) {
                    EditorDescriptor desc = EditorDescriptorExtensionFactory.eINSTANCE.createNestedEditorDescriptor(ele);
                    this.editorDescriptors.add(desc);
                }
            }
            catch (ExtensionException e) {
                Activator.log.error("Initialization editor problem ", (Throwable)e);
            }
            ++n2;
        }
        Collections.sort(this.editorDescriptors, (ed1, ed2) -> Integer.compare(ed1.getOrder(), ed2.getOrder()));
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("Read " + this.editorDescriptors.size() + " editor descriptors from Eclipse extensions");
        }
    }

    public String toString() {
        return "EditorFactoryRegistry: " + this.editorDescriptors.toString();
    }
}

