/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.delegate;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.delegate.ValidationBehavior;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.AbstractConstraintEvaluator;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.internal.delegate.InvocationBehavior;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.ValidationDelegate;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class OCLValidationDelegate
implements ValidationDelegate {
    protected final @NonNull OCLDelegateDomain delegateDomain;
    protected final @NonNull EClassifier eClassifier;

    public OCLValidationDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EClassifier classifier) {
        this.delegateDomain = delegateDomain;
        this.eClassifier = classifier;
    }

    public @NonNull ExpressionInOCL getExpressionInOCL(@NonNull MetamodelManager metamodelManager, @NonNull Constraint constraint) {
        ExpressionInOCL query = null;
        Type contextType = (Type)constraint.getContext();
        if (contextType != null) {
            query = ValidationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, constraint);
        }
        if (query == null) {
            String message = StringUtil.bind((String)PivotMessagesInternal.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{constraint.getContext()});
            throw new OCLDelegateException((Exception)new SemanticException(message));
        }
        return query;
    }

    public String toString() {
        return "<" + this.delegateDomain.getURI() + ":validate> " + this.eClassifier.getEPackage().getName() + "::" + this.eClassifier.getName();
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, EOperation invariant, String expression) {
        if (eClass == null) {
            throw new NullPointerException("Null EClass");
        }
        if (eObject == null) {
            throw new NullPointerException("Null EObject");
        }
        MetamodelManager metamodelManager = this.delegateDomain.getMetamodelManager();
        NamedElement namedElement = (NamedElement)this.delegateDomain.getPivot(NamedElement.class, (EObject)ClassUtil.nonNullEMF((Object)invariant));
        if (namedElement instanceof Operation) {
            Operation operation = (Operation)namedElement;
            ExpressionInOCL query = InvocationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, operation);
            InvocationBehavior.INSTANCE.validate((EObject)operation);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement instanceof Constraint) {
            Constraint constraint = (Constraint)namedElement;
            ExpressionInOCL query = this.getExpressionInOCL(metamodelManager, constraint);
            ValidationBehavior.INSTANCE.validate((EObject)constraint);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement != null) {
            throw new ClassCastException(String.valueOf(namedElement.getClass().getName()) + " does not provide a Constraint");
        }
        throw new ClassCastException(String.valueOf(invariant.eClass().getName()) + " does not provide a Constraint");
    }

    public boolean validate(@NonNull EClass eClass, @NonNull EObject eObject, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull EOperation invariant, String expression, int severity, String source, int code) {
        MetamodelManager metamodelManager = this.delegateDomain.getMetamodelManager();
        NamedElement namedElement = (NamedElement)this.delegateDomain.getPivot(NamedElement.class, (EObject)ClassUtil.nonNullEMF((Object)invariant));
        if (namedElement instanceof Operation) {
            Operation operation = (Operation)namedElement;
            ExpressionInOCL query = InvocationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, operation);
            InvocationBehavior.INSTANCE.validate((EObject)operation);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, null, context, invariant.getName(), null, 0, query);
        }
        if (namedElement instanceof Constraint) {
            Constraint constraint = (Constraint)namedElement;
            ExpressionInOCL query = this.getExpressionInOCL(metamodelManager, constraint);
            ValidationBehavior.INSTANCE.validate((EObject)constraint);
            return this.validateExpressionInOCL((EClassifier)eClass, eObject, diagnostics, context, invariant.getName(), source, code, query);
        }
        if (namedElement != null) {
            throw new ClassCastException(String.valueOf(namedElement.getClass().getName()) + " does not provide a Constraint");
        }
        throw new ClassCastException(String.valueOf(invariant.eClass().getName()) + " does not provide a Constraint");
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, String constraintName, String expression) {
        if (eClass == null) {
            throw new NullPointerException("Null EClass");
        }
        if (eObject == null) {
            throw new NullPointerException("Null EObject");
        }
        if (constraintName == null) {
            throw new NullPointerException("Null constraint name");
        }
        return this.validatePivot((EClassifier)eClass, eObject, null, context, constraintName, null, 0);
    }

    public boolean validate(@NonNull EClass eClass, @NonNull EObject eObject, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String constraintName, String expression, int severity, String source, int code) {
        return this.validatePivot((EClassifier)eClass, eObject, diagnostics, context, constraintName, source, code);
    }

    public boolean validate(EDataType eDataType, Object value, Map<Object, Object> context, String constraintName, String expression) {
        if (eDataType == null) {
            throw new NullPointerException("Null EClass");
        }
        if (value == null) {
            throw new NullPointerException("Null EObject");
        }
        if (constraintName == null) {
            throw new NullPointerException("Null constraint name");
        }
        return this.validatePivot((EClassifier)eDataType, value, null, context, constraintName, null, 0);
    }

    public boolean validate(@NonNull EDataType eDataType, @NonNull Object value, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String constraintName, String expression, int severity, String source, int code) {
        return this.validatePivot((EClassifier)eDataType, value, diagnostics, context, constraintName, source, code);
    }

    protected boolean validateExpressionInOCL(@NonNull EClassifier eClassifier, final @NonNull Object value, final @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, String constraintName, final String source, final int code, @NonNull ExpressionInOCL query) {
        CheckingConstraintEvaluator constraintEvaluator = new CheckingConstraintEvaluator(eClassifier, query){

            @Override
            protected String getObjectLabel() {
                return NameUtil.qualifiedNameFor((Object)value);
            }

            @Override
            protected Boolean handleFailureResult(@Nullable Object result) {
                if (result == null) {
                    String message = this.getConstraintResultMessage(result);
                    throw new OCLDelegateException((Exception)((Object)new EvaluationException(message)));
                }
                if (diagnostics != null) {
                    String message = this.getConstraintResultMessage(result);
                    int severity = this.getConstraintResultSeverity(result);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(severity, source, code, message, new Object[]{value}));
                }
                return Boolean.FALSE;
            }
        };
        OCL ocl = this.delegateDomain.getOCL();
        EvaluationVisitor evaluationVisitor = ocl.createEvaluationVisitor(value, query);
        return (Boolean)constraintEvaluator.evaluate(evaluationVisitor);
    }

    protected boolean validatePivot(@NonNull EClassifier eClassifier, @NonNull Object value, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String constraintName, String source, int code) {
        MetamodelManager metamodelManager = this.delegateDomain.getMetamodelManager();
        Type type = (Type)this.delegateDomain.getPivot(Type.class, (EObject)eClassifier);
        Constraint constraint = ValidationBehavior.INSTANCE.getConstraint(metamodelManager, eClassifier, constraintName);
        if (constraint == null) {
            String message = StringUtil.bind((String)PivotMessagesInternal.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{type});
            throw new OCLDelegateException((Exception)new SemanticException(message));
        }
        ExpressionInOCL query = null;
        if (type != null) {
            query = ValidationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, constraint);
        }
        if (query == null) {
            String message = StringUtil.bind((String)PivotMessagesInternal.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{type});
            throw new OCLDelegateException((Exception)new SemanticException(message));
        }
        return this.validateExpressionInOCL(eClassifier, value, diagnostics, context, constraintName, source, code, query);
    }

    protected static class CheckingConstraintEvaluator
    extends AbstractConstraintEvaluator<Boolean> {
        protected final @NonNull EClassifier eClassifier;

        protected CheckingConstraintEvaluator(@NonNull EClassifier eClassifier, @NonNull ExpressionInOCL query) {
            super(query);
            this.eClassifier = eClassifier;
        }

        public Boolean evaluate(@NonNull EvaluationVisitor evaluationVisitor) {
            if (!this.isBooleanConstraint()) {
                String objectLabel = LabelUtil.getLabel((Object)this.query.getType());
                String checkMessage = StringUtil.bind((String)PivotMessagesInternal.ValidationConstraintIsNotBooleanType_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), objectLabel});
                throw new OCLDelegateException((Exception)((Object)new EvaluationException(checkMessage)));
            }
            return (Boolean)super.evaluate(evaluationVisitor);
        }

        protected String getObjectLabel() {
            return LabelUtil.getLabel((EClassifier)this.eClassifier, null, null);
        }

        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            throw new OCLDelegateException((Exception)((Object)new EvaluationException(e, PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.toString()})));
        }

        protected Boolean handleFailureResult(@Nullable Object result) {
            if (result == null) {
                String message = this.getConstraintResultMessage(result);
                throw new OCLDelegateException((Exception)((Object)new EvaluationException(message)));
            }
            return Boolean.FALSE;
        }

        protected Boolean handleInvalidExpression(@NonNull String message) {
            throw new OCLDelegateException((Exception)((Object)new EvaluationException(message)));
        }

        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            throw new OCLDelegateException((Exception)((Object)new EvaluationException((Throwable)e, PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage()})));
        }

        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }
}

