/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsImages;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.TaskReview;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.graphics.Image;

public class ReviewColumnLabelProvider
extends ColumnLabelProvider {
    private final int VERIFIED = 1;
    private final int NOT_VERIFIED = -1;
    private static final int DESCRIPTION_COLUMN = 0;
    private static final int BRANCH_COLUMN = 1;
    private static final int CODE_REVIEW_COLUMN = 2;
    private static final int VERIFIED_COLUMN = 3;
    private static final int STATUS_COLUMN = 4;
    private static final int MINUS_TWO = -2;
    private static final int MINUS_ONE = -1;
    private static final int PLUS_ONE = 1;
    private static final int PLUS_TWO = 2;

    public Image getColumnImage(Object element, int columnIndex) {
        TaskReview reviewContainer = (TaskReview)element;
        switch (columnIndex) {
            case 0: {
                return this.getIncomingChangesImage(reviewContainer);
            }
            case 2: {
                return this.getReviewStateImage(reviewContainer);
            }
            case 3: {
                return this.getVerifiedStateImage(reviewContainer);
            }
        }
        return null;
    }

    private Image getIncomingChangesImage(TaskReview reviewContainer) {
        if (reviewContainer.getSyncState() == ITask.SynchronizationState.INCOMING) {
            return CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_INCOMMING);
        }
        if (reviewContainer.getSyncState() == ITask.SynchronizationState.INCOMING_NEW) {
            return CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_INCOMMING_NEW);
        }
        return CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR);
    }

    private Image getReviewStateImage(TaskReview reviewContainer) {
        int reviewScore = reviewContainer.getCodeReviewScore();
        switch (reviewScore) {
            case -2: {
                return CommonImages.getImage((ImageDescriptor)ReviewsImages.RED_NOT);
            }
            case -1: {
                return CommonImages.getImage((ImageDescriptor)ReviewsImages.MINUS_ONE);
            }
            case 1: {
                return CommonImages.getImage((ImageDescriptor)ReviewsImages.PLUS_ONE);
            }
            case 2: {
                return CommonImages.getImage((ImageDescriptor)ReviewsImages.GREEN_CHECK);
            }
        }
        return CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR);
    }

    private Image getVerifiedStateImage(TaskReview reviewContainer) {
        int verifiedState = reviewContainer.getVerifiedScore();
        if (verifiedState >= 1) {
            return CommonImages.getImage((ImageDescriptor)ReviewsImages.GREEN_CHECK);
        }
        if (verifiedState <= -1) {
            return CommonImages.getImage((ImageDescriptor)ReviewsImages.RED_NOT);
        }
        return CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR);
    }

    public String getColumnText(Object element, int columnIndex) {
        TaskReview reviewContainer = (TaskReview)element;
        switch (columnIndex) {
            case 0: {
                return reviewContainer.getSummary();
            }
            case 1: {
                return reviewContainer.getBranch();
            }
            case 4: {
                return reviewContainer.getStatus();
            }
        }
        return "";
    }

    public String getSortString(Object element, int columnIndex) {
        TaskReview reviewContainer = (TaskReview)element;
        switch (columnIndex) {
            case 2: {
                return Integer.toString(reviewContainer.getCodeReviewScore());
            }
            case 3: {
                return Integer.toString(reviewContainer.getVerifiedScore());
            }
        }
        return this.getColumnText(element, columnIndex);
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int columnNumber = cell.getColumnIndex();
        cell.setImage(this.getColumnImage(element, columnNumber));
        cell.setText(this.getColumnText(element, columnNumber));
    }
}

