/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import org.mandas.docker.client.messages.ImageSearchResult;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ImageSearchResultV2 {
    @JsonProperty(value="repositories")
    private List<String> repositories;

    public List<ImageSearchResult> getRepositories() {
        ArrayList<ImageSearchResult> result = new ArrayList<ImageSearchResult>();
        for (String repo : this.repositories) {
            result.add(new ImageResultV2(repo));
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("results", this.getRepositories()).toString();
    }

    private class ImageResultV2
    implements ImageSearchResult {
        private String name;

        public ImageResultV2(String name) {
            this.name = name;
        }

        public String description() {
            return "";
        }

        public boolean official() {
            return false;
        }

        public boolean automated() {
            return false;
        }

        public String name() {
            return this.name;
        }

        public int starCount() {
            return 0;
        }
    }
}

