/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.utils;

import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;

public class NodeTargetCalculator {
    private NodeTargetCalculator() {
    }

    public static NodeTarget calcNodeTarget(INodePO source, INodePO target, int pos, boolean expanded) {
        INodePO top = target.getSpecAncestor();
        if (top instanceof ISpecTestCasePO || top instanceof ITestSuitePO) {
            return NodeTargetCalculator.calcNodeTargetTCEditor(source, target, pos, expanded);
        }
        if (top instanceof ITestJobPO) {
            int posi = top.indexOf(target);
            return new NodeTarget(posi + 1, top);
        }
        return null;
    }

    private static NodeTarget calcNodeTargetTCEditor(INodePO source, INodePO target, int pos, boolean expanded) {
        NodeTarget res = null;
        if (target instanceof ISpecTestCasePO || target instanceof ITestSuitePO || target instanceof IAbstractContainerPO && pos != 1) {
            res = expanded ? new NodeTarget(0, target) : new NodeTarget(target.getNodeListSize(), target);
        } else if (target instanceof IAbstractContainerPO) {
            int posi = target.getParentNode().indexOf(target);
            if (posi != 0) {
                INodePO newTarg = (INodePO)target.getParentNode().getUnmodifiableNodeList().get(posi - 1);
                res = new NodeTarget(newTarg.getNodeListSize(), newTarg);
            }
        } else {
            int newPos = target.getParentNode().indexOf(target);
            if (pos != 1) {
                ++newPos;
            }
            res = new NodeTarget(newPos, target.getParentNode());
        }
        if (res != null && source != null && source.hasCircularDependencies(res.getNode().getSpecAncestor())) {
            return null;
        }
        return res;
    }

    public static class NodeTarget {
        private INodePO m_node;
        private int m_position;

        public NodeTarget(int pos, INodePO node) {
            this.m_node = node;
            this.m_position = pos;
        }

        public INodePO getNode() {
            return this.m_node;
        }

        public int getPos() {
            return this.m_position;
        }
    }
}

