/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.TestresultSummaryBP;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.ui.dialogs.EnterCommentAndDetailsDialog;
import org.eclipse.jubula.client.ui.handlers.AbstractTestResultViewHandler;
import org.eclipse.jubula.client.ui.rcp.validator.MaxStringLengthValidator;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddTestResultSummaryCommentHandler
extends AbstractTestResultViewHandler {
    public Object executeImpl(ExecutionEvent event) {
        ITestResultSummaryPO selectedSummary = this.getSelectedSummary(event);
        if (selectedSummary != null) {
            String origTitle = selectedSummary.getCommentTitle();
            String origDetail = selectedSummary.getCommentDetail();
            EnterCommentAndDetailsDialog dialog = new EnterCommentAndDetailsDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IValidator)new MaxStringLengthValidator(), origTitle, origDetail);
            dialog.setHelpAvailable(true);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.testResultSummaryAddCommentContextId");
            int result = dialog.open();
            if (result != 0) {
                return null;
            }
            String newTitle = dialog.getCommentTitle();
            String newDetails = dialog.getCommentDetail();
            if (!StringUtils.equals((String)origTitle, (String)newTitle) || !StringUtils.equals((String)origDetail, (String)newDetails)) {
                TestresultSummaryBP.getInstance().setCommentTitleAndDetails(selectedSummary, newTitle, newDetails);
            }
        }
        return null;
    }
}

