/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.ObjectMappingTransferHelper;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

public class OMDropTargetListener
extends ViewerDropAdapter {
    private ObjectMappingMultiPageEditor m_editor;

    public OMDropTargetListener(ObjectMappingMultiPageEditor editor, Viewer viewer) {
        super(viewer);
        this.m_editor = editor;
        boolean scrollExpand = Plugin.getDefault().getPreferenceStore().getBoolean("TREEAUTOSCROLL_PREF_KEY");
        this.setScrollExpandEnabled(scrollExpand);
    }

    public void dropAccept(DropTargetEvent event) {
        List toMove;
        Object target;
        if (!(LocalSelectionTransfer.getTransfer().getSelection() instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        ObjectMappingMultiPageEditor editor = this.getEditor();
        if (editor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return;
        }
        Object object = target = this.getCurrentTarget() != null ? this.getCurrentTarget() : this.getViewer().getInput();
        if (this.containsOnlyType(selection, IObjectMappingAssoziationPO.class)) {
            List toMove2 = selection.toList();
            this.dropAssociations(editor, toMove2, target);
        } else if (this.containsOnlyType(selection, IObjectMappingCategoryPO.class)) {
            List toMove3 = selection.toList();
            this.dropCategories(toMove3, target);
            editor.getTreeViewer().refresh();
        } else if (this.containsOnlyType(selection, IComponentNamePO.class) && this.dropComponentNames(editor, toMove = selection.toList(), target)) {
            return;
        }
        LocalSelectionTransfer.getTransfer().setSelection(null);
        editor.getEditorHelper().setDirty(true);
        event.item = null;
        this.getViewer().setSelection((ISelection)new StructuredSelection(target));
    }

    protected void dropAssociations(ObjectMappingMultiPageEditor editor, List<IObjectMappingAssoziationPO> toMove, Object target) {
        if (target instanceof IObjectMappingCategoryPO) {
            OMEditorDndSupport.checkAndMoveAssociations(toMove, (IObjectMappingCategoryPO)target, editor);
        }
    }

    protected boolean dropComponentNames(ObjectMappingMultiPageEditor editor, List<IComponentNamePO> toMove, Object target) {
        if (target instanceof IObjectMappingAssoziationPO) {
            return OMEditorDndSupport.checkTypeCompatibilityAndMove(toMove, (IObjectMappingAssoziationPO)target, editor);
        }
        if (target instanceof IObjectMappingCategoryPO) {
            OMEditorDndSupport.checkTypeCompatibilityAndMove(toMove, (IObjectMappingCategoryPO)target, editor);
        }
        return false;
    }

    protected boolean dropCategories(List<IObjectMappingCategoryPO> toMove, Object target) {
        if (target instanceof IObjectMappingCategoryPO) {
            IObjectMappingCategoryPO targetCategory = (IObjectMappingCategoryPO)target;
            return OMEditorDndSupport.moveCategories(toMove, targetCategory);
        }
        return false;
    }

    public boolean performDrop(Object data) {
        return true;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        Object dropTarget;
        if (!(LocalSelectionTransfer.getTransfer().getSelection() instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        Object object = dropTarget = target != null ? target : this.getViewer().getInput();
        if (dropTarget == null) {
            return false;
        }
        if (ObjectMappingTransferHelper.getDndToken() != null && !ObjectMappingTransferHelper.getDndToken().equals(this.m_editor.getAut())) {
            return false;
        }
        if (!this.hasSingleClassType(selection)) {
            return false;
        }
        if (this.containsOnlyType(selection, IObjectMappingAssoziationPO.class)) {
            List toMove = selection.toList();
            if (dropTarget instanceof IObjectMappingCategoryPO) {
                return OMEditorDndSupport.canMoveAssociations(toMove, (IObjectMappingCategoryPO)dropTarget, this.m_editor);
            }
        } else {
            if (this.containsOnlyType(selection, IObjectMappingCategoryPO.class)) {
                if (dropTarget instanceof IObjectMappingCategoryPO) {
                    return OMDropTargetListener.canDropCats(selection.toList(), (IObjectMappingCategoryPO)dropTarget);
                }
                return false;
            }
            if (this.containsOnlyType(selection, IComponentNamePO.class)) {
                if (dropTarget instanceof IObjectMappingAssoziationPO) {
                    return true;
                }
                if (dropTarget instanceof IObjectMappingCategoryPO) {
                    return OMEditorDndSupport.canMoveCompNames((IObjectMappingCategoryPO)dropTarget, this.m_editor);
                }
            }
        }
        return false;
    }

    private static boolean canDropCats(List<IObjectMappingCategoryPO> cats, IObjectMappingCategoryPO target) {
        if (cats.isEmpty()) {
            return false;
        }
        IObjectMappingCategoryPO currCat = target;
        while (currCat.getParent() != null) {
            if (cats.contains(currCat)) {
                return false;
            }
            currCat = currCat.getParent();
        }
        IObjectMappingCategoryPO srcTop = cats.get(0);
        while (srcTop.getParent() != null) {
            srcTop = srcTop.getParent();
        }
        return currCat == srcTop;
    }

    public ObjectMappingMultiPageEditor getEditor() {
        return this.m_editor;
    }

    public boolean containsOnlyType(IStructuredSelection selection, Class supportedClass) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (supportedClass.isInstance(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean hasSingleClassType(IStructuredSelection selection) {
        Class<?> classType = null;
        for (Object obj : selection) {
            if (classType == null) {
                classType = obj.getClass();
            }
            if (obj.getClass() == classType) continue;
            return false;
        }
        return true;
    }
}

