/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.archive.ImportExportUtil;
import org.eclipse.jubula.client.archive.converter.json.AddTimeoutToCAPConverter;
import org.eclipse.jubula.client.archive.converter.json.RemoveDoubledUniqueIds;
import org.eclipse.jubula.client.archive.converter.utils.AbstractConverter;
import org.eclipse.jubula.client.archive.converter.utils.IConverter;
import org.eclipse.jubula.client.archive.dto.AutConfigDTO;
import org.eclipse.jubula.client.archive.dto.AutDTO;
import org.eclipse.jubula.client.archive.dto.CapDTO;
import org.eclipse.jubula.client.archive.dto.CategoryDTO;
import org.eclipse.jubula.client.archive.dto.CheckActivatedContextDTO;
import org.eclipse.jubula.client.archive.dto.CheckAttributeDTO;
import org.eclipse.jubula.client.archive.dto.CheckConfigurationDTO;
import org.eclipse.jubula.client.archive.dto.CommentDTO;
import org.eclipse.jubula.client.archive.dto.ComponentNameDTO;
import org.eclipse.jubula.client.archive.dto.ComponentNamesPairDTO;
import org.eclipse.jubula.client.archive.dto.ConditionalStatementDTO;
import org.eclipse.jubula.client.archive.dto.DataRowDTO;
import org.eclipse.jubula.client.archive.dto.DefaultEventHandlerDTO;
import org.eclipse.jubula.client.archive.dto.EventTestCaseDTO;
import org.eclipse.jubula.client.archive.dto.ExecCategoryDTO;
import org.eclipse.jubula.client.archive.dto.ExportInfoDTO;
import org.eclipse.jubula.client.archive.dto.IterateDTO;
import org.eclipse.jubula.client.archive.dto.MapEntryDTO;
import org.eclipse.jubula.client.archive.dto.MonitoringValuesDTO;
import org.eclipse.jubula.client.archive.dto.NamedTestDataDTO;
import org.eclipse.jubula.client.archive.dto.NodeDTO;
import org.eclipse.jubula.client.archive.dto.ObjectMappingDTO;
import org.eclipse.jubula.client.archive.dto.ObjectMappingProfileDTO;
import org.eclipse.jubula.client.archive.dto.OmCategoryDTO;
import org.eclipse.jubula.client.archive.dto.OmEntryDTO;
import org.eclipse.jubula.client.archive.dto.ParamDescriptionDTO;
import org.eclipse.jubula.client.archive.dto.ProjectDTO;
import org.eclipse.jubula.client.archive.dto.RefTestCaseDTO;
import org.eclipse.jubula.client.archive.dto.RefTestSuiteDTO;
import org.eclipse.jubula.client.archive.dto.ReusedProjectDTO;
import org.eclipse.jubula.client.archive.dto.TDManagerDTO;
import org.eclipse.jubula.client.archive.dto.TechnicalNameDTO;
import org.eclipse.jubula.client.archive.dto.TestCaseDTO;
import org.eclipse.jubula.client.archive.dto.TestDataCategoryDTO;
import org.eclipse.jubula.client.archive.dto.TestJobDTO;
import org.eclipse.jubula.client.archive.dto.TestSuiteDTO;
import org.eclipse.jubula.client.archive.dto.TestresultSummaryDTO;
import org.eclipse.jubula.client.archive.dto.UsedToolkitDTO;
import org.eclipse.jubula.client.archive.dto.ValueSetDTO;
import org.eclipse.jubula.client.archive.dto.WhileDTO;
import org.eclipse.jubula.client.archive.i18n.Messages;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICheckConfContPO;
import org.eclipse.jubula.client.core.model.ICheckConfPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.ICondStructPO;
import org.eclipse.jubula.client.core.model.IConditionalStatementPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IIteratePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamValueSetPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITcParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.IUsedToolkitPO;
import org.eclipse.jubula.client.core.model.IValueCommentPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.TrackingUnit;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.MonitoringValue;
import org.eclipse.jubula.tools.internal.version.IVersion;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Profile;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.eclipse.osgi.util.NLS;

public class JsonImporter {
    private Map<String, IAUTMainPO> m_autRef = new HashMap<String, IAUTMainPO>();
    private Map<String, ISpecTestCasePO> m_tcRef = new HashMap<String, ISpecTestCasePO>();
    private Map<String, String> m_oldToNewGuids = new HashMap<String, String>();
    private Map<Long, IObjectMappingCategoryPO> m_omCategories = new HashMap<Long, IObjectMappingCategoryPO>();
    private IProgressMonitor m_monitor;
    private boolean m_skipTrackingInformation = false;
    private IProgressConsole m_io;
    private ExportInfoDTO m_exportInfo;

    public JsonImporter(IProgressMonitor monitor, IProgressConsole io, boolean skipTrackingInformation, ExportInfoDTO exportInfo) {
        this.m_monitor = monitor;
        this.m_io = io;
        this.m_skipTrackingInformation = skipTrackingInformation;
        this.m_exportInfo = exportInfo;
    }

    public IProjectPO createProject(ProjectDTO projectDTO, boolean assignNewGuid, boolean assignNewVersion, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache) throws InvalidDataException, InterruptedException, JBVersionException, ToolkitPluginException {
        this.m_monitor.subTask(Messages.ImportJsonImportReqCheck);
        this.documentRequiredProjects(projectDTO);
        this.checkSupportedToolkits(projectDTO.getUsedToolkits());
        this.checkUsedToolkits(projectDTO);
        this.applyConverters(projectDTO);
        IProjectPO proj = this.initProject(projectDTO, assignNewGuid, assignNewVersion);
        EntityManager attrDescSession = Persistor.instance().openSession();
        try {
            this.fillProject(proj, projectDTO, attrDescSession, assignNewGuid, paramNameMapper, compNameCache);
        }
        finally {
            Persistor.instance().dropSession(attrDescSession);
        }
        return proj;
    }

    private void applyConverters(ProjectDTO projectDTO) {
        ArrayList<AbstractConverter> converters = new ArrayList<AbstractConverter>(1);
        converters.add(new RemoveDoubledUniqueIds(this.m_exportInfo));
        converters.add(new AddTimeoutToCAPConverter(this.m_exportInfo));
        for (IConverter iConverter : converters) {
            iConverter.convert(projectDTO);
        }
    }

    private void checkSupportedToolkits(List<UsedToolkitDTO> usedToolkits) throws ToolkitPluginException {
        List toolkitIds = ComponentBuilder.getInstance().getLevelToolkitIds();
        StringBuilder errorMsg = new StringBuilder();
        for (UsedToolkitDTO usedToolkit : usedToolkits) {
            if (ComponentBuilder.getInstance().getLevelToolkitIds().contains(usedToolkit.getName())) continue;
            try {
                "toolkit".equals(ToolkitSupportBP.getToolkitLevel((String)usedToolkit.getName()));
            }
            catch (ToolkitPluginException e) {
                errorMsg.append("\n");
                errorMsg.append("\t");
                errorMsg.append(usedToolkit.getName());
            }
        }
        if (StringUtils.isNotBlank((String)errorMsg.toString())) {
            throw new ToolkitPluginException(NLS.bind((String)Messages.UnsupportedToolkits, (Object)errorMsg.toString()));
        }
    }

    private IProjectPO initProject(ProjectDTO dto, boolean assignNewGuid, boolean assignNewVersion) {
        this.m_monitor.subTask(Messages.ImportJsonImportProjectInit);
        IProjectPO proj = null;
        if (dto.getUuid() != null) {
            Integer majorProjVersion = 1;
            Integer minorProjVersion = 0;
            Integer microProjVersion = null;
            String postFixProjVersion = null;
            if (!assignNewVersion) {
                majorProjVersion = dto.getMajorProjectVersion();
                minorProjVersion = dto.getMinorProjectVersion();
                microProjVersion = dto.getMicroProjectVersion();
                postFixProjVersion = dto.getProjectVersionQualifier();
            }
            proj = assignNewGuid ? NodeMaker.createProjectPO((Integer)IVersion.JB_CLIENT_METADATA_VERSION, (Integer)majorProjVersion, (Integer)minorProjVersion, microProjVersion, postFixProjVersion) : NodeMaker.createProjectPO((Integer)IVersion.JB_CLIENT_METADATA_VERSION, (Integer)majorProjVersion, (Integer)minorProjVersion, (Integer)microProjVersion, postFixProjVersion, (String)dto.getUuid());
            ProjectNameBP.getInstance().setName(proj.getGuid(), dto.getName(), false);
        } else {
            proj = NodeMaker.createProjectPO((String)dto.getName(), (Integer)IVersion.JB_CLIENT_METADATA_VERSION);
        }
        if (assignNewGuid) {
            this.m_oldToNewGuids.put(dto.getUuid(), proj.getGuid());
        }
        return proj;
    }

    private void fillProject(IProjectPO proj, ProjectDTO dto, EntityManager attrDescSession, boolean assignNewGuid, IParamNameMapper mapper, IWritableComponentNameCache cNC) throws InterruptedException, InvalidDataException {
        this.m_monitor.beginTask(Messages.ImportFileBPImporting, this.getWorkToImport(dto.getCategories().size()));
        this.m_monitor.subTask(Messages.ImportJsonImportProjectLoad);
        IProjectPropertiesPO projectProperties = this.fillProjectProperties(proj, dto);
        if (dto.getTestResultDetailsCleanupInterval() != null) {
            proj.setTestResultCleanupInterval(dto.getTestResultDetailsCleanupInterval().intValue());
        } else {
            proj.setTestResultCleanupInterval(5);
        }
        this.m_monitor.worked(1);
        for (ReusedProjectDTO reusedProj : dto.getReusedProjects()) {
            proj.addUsedProject(this.createReusedProject(reusedProj));
        }
        this.m_monitor.worked(1);
        for (AutDTO aut : dto.getAuts()) {
            proj.addAUTMain(this.createAUTMain(aut, assignNewGuid));
        }
        this.m_monitor.worked(1);
        for (TestDataCategoryDTO testDataCategory : dto.getTestDataCategories()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            proj.getTestDataCubeCont().addCategory(this.createTestDataCategory(testDataCategory, assignNewGuid, mapper));
        }
        this.m_monitor.worked(1);
        for (NamedTestDataDTO testDataCube : dto.getNamedTestDatas()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            proj.getTestDataCubeCont().addTestData(this.createTestDataCube(testDataCube, assignNewGuid, mapper));
        }
        for (NodeDTO node : dto.getCategories()) {
            this.m_monitor.worked(1);
            ImportExportUtil.checkCancel(this.m_monitor);
            if (node instanceof CategoryDTO) {
                proj.getSpecObjCont().addNode(this.createCategory(proj, (CategoryDTO)node, assignNewGuid, mapper));
                continue;
            }
            if (!(node instanceof TestCaseDTO)) continue;
            proj.getSpecObjCont().addNode((INodePO)this.createTestCaseBase(proj, (TestCaseDTO)node, assignNewGuid, mapper));
        }
        if (assignNewGuid) {
            this.generateRefTestCase(dto.getCategories(), proj, assignNewGuid);
        }
        this.handleTestSuitesAndTestJobsAndCategories(proj, dto, assignNewGuid);
        this.m_monitor.worked(1);
        for (CheckConfigurationDTO dtoConf : dto.getCheckConfigurations()) {
            this.initCheckConf(dtoConf, projectProperties.getCheckConfCont());
        }
        this.m_monitor.worked(1);
        this.createComponentNames(dto, proj, cNC, assignNewGuid);
        this.m_monitor.worked(1);
    }

    private void generateRefTestCase(List<NodeDTO> nodes, IProjectPO proj, boolean assignNewGuid) throws InvalidDataException {
        for (NodeDTO node : nodes) {
            if (node instanceof CategoryDTO) {
                this.generateRefTestCase(((CategoryDTO)node).getNodes(), proj, assignNewGuid);
                continue;
            }
            if (!(node instanceof TestCaseDTO)) continue;
            this.generateRefTestCase((TestCaseDTO)node, proj, null, assignNewGuid);
        }
    }

    private void generateRefTestCase(TestCaseDTO dto, IProjectPO proj, ISpecTestCasePO stcPo, boolean newGuid) throws InvalidDataException {
        try {
            ISpecTestCasePO tc = !newGuid && stcPo != null ? stcPo : this.m_tcRef.get(this.m_oldToNewGuids.get(dto.getUuid()));
            List<Long> omCategoryAssoc = dto.getAssocOMCategories();
            tc.setOmCategoryAssoc(omCategoryAssoc.stream().map(this.m_omCategories::get).collect(Collectors.toList()));
            for (NodeDTO stepDto : dto.getTestSteps()) {
                if (stepDto instanceof CapDTO) {
                    tc.addNode((INodePO)this.createCap(proj, (CapDTO)stepDto, newGuid));
                    continue;
                }
                if (stepDto instanceof RefTestCaseDTO) {
                    tc.addNode((INodePO)this.createExecTestCase(proj, (RefTestCaseDTO)stepDto, newGuid));
                    continue;
                }
                if (stepDto instanceof CommentDTO) {
                    tc.addNode((INodePO)this.createComment((CommentDTO)stepDto, newGuid));
                    continue;
                }
                if (stepDto instanceof ConditionalStatementDTO) {
                    tc.addNode((INodePO)this.createConditionalStatement((ConditionalStatementDTO)stepDto, proj, newGuid));
                    continue;
                }
                if (stepDto instanceof WhileDTO) {
                    tc.addNode((INodePO)this.createWhile(proj, (WhileDTO)stepDto, newGuid));
                    continue;
                }
                if (!(stepDto instanceof IterateDTO)) continue;
                tc.addNode((INodePO)this.createIterate(proj, (IterateDTO)stepDto, newGuid));
            }
            for (EventTestCaseDTO evTcDto : dto.getEventTestcases()) {
                tc.addEventTestCase(this.createEventExecTestCase(proj, tc, evTcDto, newGuid));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private IConditionalStatementPO createConditionalStatement(ConditionalStatementDTO dto, IProjectPO proj, boolean newGuid) throws InvalidDataException {
        IConditionalStatementPO con = this.getConditionalStatement(dto, newGuid);
        con.setNegate(dto.isNegated());
        con.setGenerated(dto.getGenerated());
        con.setComment(dto.getComment());
        con.setTaskId(dto.getTaskId());
        con.setDescription(dto.getDescription());
        con.setActive(dto.isActive());
        List<NodeDTO> nodes = dto.getNodes();
        if (nodes != null && nodes.size() == 3) {
            this.fillContainer(nodes.get(0), con.getCondition(), proj, newGuid);
            this.fillContainer(nodes.get(1), con.getThenBranch(), proj, newGuid);
            this.fillContainer(nodes.get(2), con.getElseBranch(), proj, newGuid);
        }
        return con;
    }

    private void fillContainer(NodeDTO dto, IAbstractContainerPO po, IProjectPO proj, boolean assignNewGuid) {
        po.setGenerated(dto.getGenerated());
        po.setComment(dto.getComment());
        po.setTaskId(dto.getTaskId());
        po.setDescription(dto.getDescription());
        for (NodeDTO node : dto.getNodes()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            if (node instanceof CapDTO) {
                po.addNode((INodePO)this.createCap(proj, (CapDTO)node, assignNewGuid));
                continue;
            }
            if (node instanceof RefTestCaseDTO) {
                po.addNode((INodePO)this.createExecTestCase(proj, (RefTestCaseDTO)node, assignNewGuid));
                continue;
            }
            if (!(node instanceof CommentDTO)) continue;
            po.addNode((INodePO)this.createComment((CommentDTO)node, assignNewGuid));
        }
    }

    private IConditionalStatementPO getConditionalStatement(ConditionalStatementDTO dto, boolean assignNewGuid) {
        if (dto.getUuid() != null && !assignNewGuid) {
            return NodeMaker.createConditionalStatementPO((String)dto.getName(), (String)dto.getUuid());
        }
        return NodeMaker.createConditionalStatementPO((String)dto.getName());
    }

    private void createComponentNames(ProjectDTO dtoProj, IProjectPO proj, IWritableComponentNameCache compNameCache, boolean assignNewGuid) {
        List<ComponentNameDTO> componentNamesList = dtoProj.getComponentNames();
        HashMap<String, String> oldToNewGUID = new HashMap<String, String>(componentNamesList.size());
        HashSet<IComponentNamePO> createdCompNames = new HashSet<IComponentNamePO>();
        for (ComponentNameDTO compName : componentNamesList) {
            String guid = compName.getUuid();
            if (assignNewGuid) {
                String newGuid = PersistenceUtil.generateUUID();
                oldToNewGUID.put(guid, newGuid);
                guid = newGuid;
            }
            String name = compName.getCompName();
            String type = compName.getCompType();
            String creationContext = compName.getCreationContext();
            ComponentNamesBP.CompNameCreationContext ctx = ComponentNamesBP.CompNameCreationContext.forName((String)creationContext);
            IComponentNamePO componentNamePO = PoMaker.createComponentNamePO((String)guid, (String)name, (String)type, (ComponentNamesBP.CompNameCreationContext)ctx, (Long)proj.getId());
            componentNamePO.setReferencedGuid(compName.getRefUuid());
            createdCompNames.add(componentNamePO);
            compNameCache.addCompNamePO(componentNamePO);
        }
        if (assignNewGuid) {
            for (IComponentNamePO createdName : createdCompNames) {
                String newGuid = (String)oldToNewGUID.get(createdName.getReferencedGuid());
                if (newGuid == null) continue;
                createdName.setReferencedGuid(newGuid);
            }
            ImportExportUtil.switchCompNamesGuids(proj, oldToNewGUID);
        }
    }

    private ICommentPO createComment(CommentDTO dto, boolean assignNewUuid) {
        ICommentPO comment = dto.getUuid() != null && !assignNewUuid ? NodeMaker.createCommentPO((String)dto.getName(), (String)dto.getUuid()) : NodeMaker.createCommentPO((String)dto.getName());
        comment.setActive(dto.isActive());
        return comment;
    }

    private boolean componentHasDefaultMapping(String componentType) {
        Component component = ComponentBuilder.getInstance().getCompSystem().findComponent(componentType);
        if (component.isConcrete()) {
            return ((ConcreteComponent)component).hasDefaultMapping();
        }
        return false;
    }

    public void initTestResultSummaries(IProgressMonitor monitor, List<TestresultSummaryDTO> trsListDtos, IProjectPO proj) throws InterruptedException {
        monitor.beginTask(Messages.ImportFileBPImporting, trsListDtos.size());
        ArrayList<ITestResultSummaryPO> summaries = new ArrayList<ITestResultSummaryPO>(1000);
        int countOfTestResult = 0;
        for (TestresultSummaryDTO dto : trsListDtos) {
            ImportExportUtil.checkCancel(this.m_monitor);
            monitor.worked(1);
            monitor.subTask(String.valueOf(Messages.ImportJsonImportResult) + ++countOfTestResult + "/" + trsListDtos.size());
            ITestResultSummaryPO summary = PoMaker.createTestResultSummaryPO();
            summary.setInternalProjectGuid(proj.getGuid());
            this.fillTestresultSummary(summary, dto);
            List<MonitoringValuesDTO> tmpList = dto.getMonitoringValues();
            HashMap<String, MonitoringValue> tmpMap = new HashMap<String, MonitoringValue>();
            int countOfValue = 0;
            while (countOfValue < tmpList.size()) {
                MonitoringValuesDTO tmpMon = tmpList.get(countOfValue);
                MonitoringValue tmp = new MonitoringValue();
                tmp.setCategory(tmpMon.getCategory());
                tmp.setSignificant(Boolean.valueOf(tmpMon.isSignificant()));
                tmp.setType(tmpMon.getType());
                tmp.setValue(tmpMon.getValue());
                tmpMap.put(tmpMon.getKey(), tmp);
                ++countOfValue;
            }
            summary.setMonitoringValues(tmpMap);
            if (!TestResultSummaryPM.doesTestResultSummaryExist((ITestResultSummaryPO)summary)) {
                summaries.add(summary);
            }
            if (summaries.size() != 1000) continue;
            TestResultSummaryPM.storeTestResultSummariesInDB(summaries);
            summaries.clear();
        }
        if (!summaries.isEmpty()) {
            TestResultSummaryPM.storeTestResultSummariesInDB(summaries);
        }
    }

    public void fillTestresultSummary(ITestResultSummaryPO po, TestresultSummaryDTO dto) {
        po.setAutAgentName(dto.getAutAgentName());
        po.setAutCmdParameter(dto.getAutCmdParameter());
        po.setAutConfigName(dto.getAutConfigName());
        po.setAutHostname(dto.getAutHostname());
        po.setAutId(dto.getAutId());
        po.setAutName(dto.getAutName());
        po.setAutOS(dto.getAutOS());
        po.setAutToolkit(dto.getAutToolkit());
        po.setCommentDetail(dto.getCommentDetail());
        po.setCommentTitle(dto.getCommentTitle());
        po.setInternalAutConfigGuid(dto.getAutConfigUuid());
        po.setInternalAutGuid(dto.getAutUuid());
        po.setInternalMonitoringId(dto.getMonitoringId());
        po.setInternalProjectGuid(dto.getProjectUuid());
        po.setInternalProjectID(dto.getProjectID());
        po.setInternalTestJobGuid(dto.getTestJobUuid());
        po.setInternalTestsuiteGuid(dto.getTestsuiteUuid());
        po.setMonitoringValue(dto.getMonitoringValue());
        po.setMonitoringValueType(dto.getMonitoringValueType());
        po.setProjectMajorVersion(dto.getProjectMajorVersion());
        po.setProjectMinorVersion(dto.getProjectMinorVersion());
        po.setProjectMicroVersion(dto.getProjectMicroVersion());
        po.setProjectName(dto.getProjectName());
        po.setProjectVersionQualifier(dto.getProjectVersionQualifier());
        po.setReportWritten(dto.isBlobWritten());
        po.setTestJobName(dto.getTestJobName());
        po.setTestJobStartTime(dto.getTestJobStartTime());
        po.setTestsuiteDate(dto.getTestsuiteDate());
        po.setTestsuiteDuration(dto.getTestsuiteDuration());
        po.setTestsuiteEndTime(dto.getTestsuiteEndTime());
        po.setTestsuiteEventHandlerTeststeps(dto.getTestsuiteEventHandlerTeststeps());
        po.setTestsuiteExecutedTeststeps(dto.getTestsuiteExecutedTeststeps());
        po.setTestsuiteExpectedTeststeps(dto.getTestsuiteExpectedTeststeps());
        po.setTestsuiteFailedTeststeps(dto.getTestsuiteFailedTeststeps());
        po.setTestsuiteName(dto.getTestsuiteName());
        po.setTestsuiteStartTime(dto.getTestsuiteStartTime());
        po.setTestsuiteStatus(dto.getTestsuiteStatus());
    }

    private void initCheckConf(CheckConfigurationDTO dtoConf, ICheckConfContPO checkConfCont) {
        if (dtoConf.getSeverity().matches("(0|1|2|3)")) {
            return;
        }
        ICheckConfPO chkConf = checkConfCont.createCheckConf();
        chkConf.setSeverity(dtoConf.getSeverity());
        chkConf.setActive(Boolean.valueOf(dtoConf.isActivated()));
        for (CheckAttributeDTO dtoAttr : dtoConf.getCheckAttributes()) {
            chkConf.getAttr().put(dtoAttr.getName(), dtoAttr.getValue());
        }
        for (CheckActivatedContextDTO dtoCxt : dtoConf.getCheckActivatedContextes()) {
            boolean active = dtoCxt.isActive();
            chkConf.getContexts().put(dtoCxt.getClazz(), active);
        }
        checkConfCont.addCheckConf(dtoConf.getCheckId(), chkConf);
    }

    private INodePO createCategory(IProjectPO proj, CategoryDTO dto, boolean assignNewGuid, IParamNameMapper mapper) throws InvalidDataException {
        ICategoryPO cat = dto.getUuid() != null && !assignNewGuid ? NodeMaker.createCategoryPO((String)dto.getName(), (String)dto.getUuid()) : NodeMaker.createCategoryPO((String)dto.getName());
        cat.setGenerated(dto.getGenerated());
        cat.setComment(dto.getComment());
        cat.setTaskId(dto.getTaskId());
        for (NodeDTO node : dto.getNodes()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            if (node instanceof CategoryDTO) {
                cat.addNode(this.createCategory(proj, (CategoryDTO)node, assignNewGuid, mapper));
                continue;
            }
            if (!(node instanceof TestCaseDTO)) continue;
            cat.addNode((INodePO)this.createTestCaseBase(proj, (TestCaseDTO)node, assignNewGuid, mapper));
        }
        return cat;
    }

    private ISpecTestCasePO createTestCaseBase(IProjectPO proj, TestCaseDTO dto, boolean assignNewGuid, IParamNameMapper mapper) throws InvalidDataException {
        ISpecTestCasePO tc;
        if (assignNewGuid) {
            tc = NodeMaker.createSpecTestCasePO((String)dto.getName());
            this.m_tcRef.put(tc.getGuid(), tc);
            this.m_oldToNewGuids.put(dto.getUuid(), tc.getGuid());
        } else {
            tc = NodeMaker.createSpecTestCasePO((String)dto.getName(), (String)dto.getUuid());
            this.m_tcRef.put(dto.getUuid(), tc);
        }
        tc.setComment(dto.getComment());
        tc.setDescription(dto.getDescription());
        tc.setGenerated(dto.getGenerated());
        tc.setTaskId(dto.getTaskId());
        tc.setInterfaceLocked(Boolean.valueOf(dto.isInterfaceLocked()));
        tc.setDataFile(dto.getDatafile());
        this.fillTrackedChangesInformation((INodePO)tc, dto);
        if (dto.getReferencedTestData() != null) {
            String referencedDataName = dto.getReferencedTestData();
            ITestDataCubePO[] iTestDataCubePOArray = TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)proj);
            int n = iTestDataCubePOArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestDataCubePO testDataCube = iTestDataCubePOArray[n2];
                if (referencedDataName.equals(testDataCube.getName())) {
                    tc.setReferencedDataCube((IParameterInterfacePO)testDataCube);
                    break;
                }
                ++n2;
            }
        }
        for (ParamDescriptionDTO pdDto : dto.getParameterDescription()) {
            String uniqueId = pdDto.getUuid();
            IParamDescriptionPO paramDesc = null;
            if (assignNewGuid) {
                paramDesc = tc.addParameter(pdDto.getType(), pdDto.getName(), mapper);
                this.m_oldToNewGuids.put(uniqueId, paramDesc.getUniqueId());
            } else {
                paramDesc = uniqueId != null && Pattern.matches("[0-9a-fA-F]{32}", uniqueId) ? tc.addParameter(pdDto.getType(), pdDto.getName(), uniqueId, mapper) : tc.addParameter(pdDto.getType(), pdDto.getName(), mapper);
            }
            ValueSetDTO valueSetDto = pdDto.getValueSet();
            if (paramDesc == null || valueSetDto == null || !(paramDesc instanceof ITcParamDescriptionPO)) continue;
            this.fillValueSetToParamDesc((ITcParamDescriptionPO)paramDesc, valueSetDto);
        }
        tc.setDataManager(this.createTDManager((IParameterInterfacePO)tc, dto.getTDManager(), assignNewGuid));
        if (!assignNewGuid) {
            this.generateRefTestCase(dto, proj, tc, assignNewGuid);
        }
        return tc;
    }

    private void fillValueSetToParamDesc(ITcParamDescriptionPO paramDesc, ValueSetDTO valueSetDto) {
        String defaultValue = valueSetDto.getDefaultValue();
        List<MapEntryDTO> valueComment = valueSetDto.getValueComment();
        ArrayList<IValueCommentPO> valuePos = new ArrayList<IValueCommentPO>();
        for (MapEntryDTO mapEntryDTO : valueComment) {
            valuePos.add(PoMaker.createValueComment((String)mapEntryDTO.getKey(), (String)mapEntryDTO.getValue()));
        }
        IParamValueSetPO valueSetPO = PoMaker.createParamValueSet();
        valueSetPO.setDefaultValue(defaultValue);
        valueSetPO.getValues().addAll(valuePos);
        paramDesc.setValueSet(valueSetPO);
    }

    private IEventExecTestCasePO createEventExecTestCase(IProjectPO proj, ISpecTestCasePO tc, EventTestCaseDTO dto, boolean assignNewGuid) throws InvalidDataException {
        ISpecTestCasePO refTc = ImportExportUtil.findReferencedTCByGuid(dto.getTestcaseUuid(), dto.getProjectUuid(), proj, assignNewGuid, this.m_oldToNewGuids, this.m_tcRef);
        IEventExecTestCasePO evTc = refTc == null ? (assignNewGuid ? NodeMaker.createEventExecTestCasePO((String)dto.getTestcaseUuid(), (String)dto.getProjectUuid(), (INodePO)tc) : NodeMaker.createEventExecTestCasePO((String)dto.getTestcaseUuid(), (String)dto.getProjectUuid(), (INodePO)tc, (String)dto.getUuid())) : (dto.getUuid() != null && !assignNewGuid ? NodeMaker.createEventExecTestCasePO((ISpecTestCasePO)refTc, (INodePO)tc, (String)dto.getUuid()) : NodeMaker.createEventExecTestCasePO((ISpecTestCasePO)refTc, (INodePO)tc));
        this.fillExecTestCase(proj, dto, (IExecTestCasePO)evTc, assignNewGuid);
        evTc.setEventType(dto.getEventType());
        ReentryProperty reentryProperty = ReentryProperty.getPropertyFromName((String)dto.getReentryProperty());
        evTc.setReentryProp(reentryProperty);
        if (reentryProperty == ReentryProperty.RETRY) {
            evTc.setMaxRetries(Integer.valueOf(dto.getMaxRetries() != null ? dto.getMaxRetries() : 1));
        }
        evTc.clearCachedSpecTestCase();
        return evTc;
    }

    private ICapPO createCap(IProjectPO proj, CapDTO dto, boolean assignNewGuid) {
        String componentname = dto.getComponentName();
        if (this.componentHasDefaultMapping(dto.getComponentType())) {
            componentname = null;
        }
        ICapPO cap = dto.getUuid() != null && !assignNewGuid ? NodeMaker.createCapPO((String)dto.getName(), (String)componentname, (String)dto.getComponentType(), (String)dto.getActionName(), (IProjectPO)proj, (String)dto.getUuid()) : NodeMaker.createCapPO((String)dto.getName(), (String)componentname, (String)dto.getComponentType(), (String)dto.getActionName(), (IProjectPO)proj);
        cap.setDataFile(dto.getDatafile());
        cap.setActive(dto.isActive());
        cap.setComment(dto.getComment());
        if (dto.getTDManager() != null) {
            ITDManager tdman = this.createTDManager((IParameterInterfacePO)cap, dto.getTDManager(), assignNewGuid);
            cap.setDataManager(tdman);
        }
        return cap;
    }

    private ICondStructPO createWhile(IProjectPO proj, WhileDTO dto, boolean assignNewGuid) {
        boolean needsNewGUID;
        Object whilePO = null;
        boolean bl = needsNewGUID = assignNewGuid || dto.getUuid() == null;
        whilePO = dto.isDoWhile() ? (assignNewGuid ? NodeMaker.createDoWhilePO((String)dto.getName()) : NodeMaker.createDoWhilePO((String)dto.getName(), (String)dto.getUuid())) : (assignNewGuid ? NodeMaker.createWhileDoPO((String)dto.getName()) : NodeMaker.createWhileDoPO((String)dto.getName(), (String)dto.getUuid()));
        whilePO.setNegate(dto.isNegated());
        whilePO.setGenerated(dto.getGenerated());
        whilePO.setComment(dto.getComment());
        whilePO.setTaskId(dto.getTaskId());
        whilePO.setDescription(dto.getDescription());
        whilePO.setActive(dto.isActive());
        List<NodeDTO> nodes = dto.getNodes();
        if (nodes != null && nodes.size() == 2) {
            if (dto.isDoWhile()) {
                this.fillContainer(nodes.get(0), whilePO.getDoBranch(), proj, assignNewGuid);
                this.fillContainer(nodes.get(1), whilePO.getCondition(), proj, assignNewGuid);
            } else {
                this.fillContainer(nodes.get(0), whilePO.getDoBranch(), proj, assignNewGuid);
                this.fillContainer(nodes.get(1), whilePO.getCondition(), proj, assignNewGuid);
            }
        }
        return whilePO;
    }

    private IIteratePO createIterate(IProjectPO proj, IterateDTO dto, boolean assignNewGuid) {
        IIteratePO iteratePO = null;
        iteratePO = dto.getUuid() != null && !assignNewGuid ? NodeMaker.createIteratePO((String)dto.getName()) : NodeMaker.createIteratePO((String)dto.getName(), (String)dto.getUuid());
        iteratePO.setGenerated(dto.getGenerated());
        iteratePO.setComment(dto.getComment());
        iteratePO.setTaskId(dto.getTaskId());
        iteratePO.setDescription(dto.getDescription());
        iteratePO.setActive(dto.isActive());
        iteratePO.setDataManager(this.createTDManager((IParameterInterfacePO)iteratePO, dto.getTDManager(), assignNewGuid));
        List<NodeDTO> nodes = dto.getNodes();
        if (nodes != null && nodes.size() == 1) {
            this.fillContainer(nodes.get(0), iteratePO.getDoBranch(), proj, assignNewGuid);
        }
        return iteratePO;
    }

    private void fillTrackedChangesInformation(INodePO poNode, NodeDTO dto) {
        SortedMap<Long, String> trackedModificationList = dto.getTrackedModifications();
        if (!trackedModificationList.isEmpty() && !this.m_skipTrackingInformation) {
            poNode.setTrackedChangesMap(trackedModificationList);
        }
    }

    private ITestDataCubePO createTestDataCube(NamedTestDataDTO dto, boolean assignNewGuids, IParamNameMapper mapper) {
        ITestDataCubePO testDataCube = PoMaker.createTestDataCubePO((String)dto.getName());
        for (ParamDescriptionDTO dtoParamDesc : dto.getParameterDescriptions()) {
            IParamDescriptionPO paramDesc = null;
            if (assignNewGuids) {
                paramDesc = testDataCube.addParameter(dtoParamDesc.getType(), dtoParamDesc.getName(), mapper);
                this.m_oldToNewGuids.put(dtoParamDesc.getUuid(), paramDesc.getUniqueId());
            } else {
                paramDesc = testDataCube.addParameter(dtoParamDesc.getType(), dtoParamDesc.getName(), dtoParamDesc.getUuid(), mapper);
            }
            ValueSetDTO valueSetDto = dtoParamDesc.getValueSet();
            if (!(paramDesc instanceof ITcParamDescriptionPO) || valueSetDto == null) continue;
            this.fillValueSetToParamDesc((ITcParamDescriptionPO)paramDesc, valueSetDto);
        }
        testDataCube.setDataManager(this.createTDManager((IParameterInterfacePO)testDataCube, dto.getTDManager(), assignNewGuids));
        return testDataCube;
    }

    private ITestDataCategoryPO createTestDataCategory(TestDataCategoryDTO dto, boolean assignNewGuids, IParamNameMapper mapper) {
        ITestDataCategoryPO testDataCategory = PoMaker.createTestDataCategoryPO((String)dto.getName());
        for (TestDataCategoryDTO subCategory : dto.getTestDataCategories()) {
            testDataCategory.addCategory(this.createTestDataCategory(subCategory, assignNewGuids, mapper));
        }
        for (NamedTestDataDTO testData : dto.getNamedTestDatas()) {
            testDataCategory.addTestData(this.createTestDataCube(testData, assignNewGuids, mapper));
        }
        return testDataCategory;
    }

    private IReusedProjectPO createReusedProject(ReusedProjectDTO dto) {
        Integer majorProjVersion = dto.getMajorProjectVersion();
        Integer minorProjVersion = dto.getMinorProjectVersion();
        Integer microProjVersion = dto.getMicroProjectVersion();
        String versionQualifier = dto.getProjectVersionQualifier();
        IReusedProjectPO reusedProject = PoMaker.createReusedProjectPO((String)dto.getProjectUuid(), (Integer)majorProjVersion, (Integer)minorProjVersion, (Integer)microProjVersion, (String)versionQualifier);
        return reusedProject;
    }

    private IAUTMainPO createAUTMain(AutDTO dto, boolean assignNewGuid) {
        IAUTMainPO aut = null;
        aut = dto.getUuid() != null && !assignNewGuid ? PoMaker.createAUTMainPO((String)dto.getName(), (String)dto.getUuid()) : PoMaker.createAUTMainPO((String)dto.getName());
        aut.setToolkit(dto.getToolkit());
        aut.setGenerateNames(dto.isGenerateNames());
        this.m_autRef.put(dto.getId(), aut);
        aut.setObjMap(this.createOM(dto, aut));
        for (AutConfigDTO confdto : dto.getConfigs()) {
            aut.addAutConfigToSet(this.createAUTConfig(confdto, assignNewGuid));
        }
        for (String autId : dto.getAutIds()) {
            aut.getAutIds().add(autId);
        }
        Map<String, String> propertyMap = dto.getPropertyMap();
        for (String key : propertyMap.keySet()) {
            aut.getPropertyMap().put(key, propertyMap.get(key));
        }
        return aut;
    }

    private IAUTConfigPO createAUTConfig(AutConfigDTO dto, boolean assignNewGuid) {
        IAUTConfigPO conf = null;
        conf = dto.getUuid() != null && !assignNewGuid ? PoMaker.createAUTConfigPO((String)dto.getUuid()) : PoMaker.createAUTConfigPO();
        List<MapEntryDTO> confAttrMapList = dto.getConfAttrMapEntry();
        for (MapEntryDTO entry : confAttrMapList) {
            String key = entry.getKey();
            String value = entry.getValue();
            conf.setValue(key, value);
        }
        return conf;
    }

    private IObjectMappingPO createOM(AutDTO dto, IAUTMainPO aut) {
        OmCategoryDTO unmappedTechnicalCategory;
        OmCategoryDTO unmappedComponentCategory;
        OmCategoryDTO mappedCategoryDto;
        IObjectMappingPO om = PoMaker.createObjectMappingPO((IAUTMainPO)this.m_autRef.get(dto.getId()));
        ObjectMappingDTO omDto = dto.getObjectMapping();
        ObjectMappingProfileDTO profileSto = omDto.getProfile();
        if (profileSto != null) {
            IObjectMappingProfilePO profilePo = PoMaker.createObjectMappingProfile();
            profilePo.setContextFactor(profileSto.getContextFactor());
            profilePo.setNameFactor(profileSto.getNameFactor());
            profilePo.setPathFactor(profileSto.getPathFactor());
            profilePo.setThreshold(profileSto.getThreshold());
            om.setProfile(profilePo);
        }
        if ((mappedCategoryDto = omDto.getMapped()) != null) {
            this.fillObjectMappingCategory(mappedCategoryDto, om.getMappedCategory(), aut);
        }
        if ((unmappedComponentCategory = omDto.getUnmappedComponent()) != null) {
            this.fillObjectMappingCategory(unmappedComponentCategory, om.getUnmappedLogicalCategory(), aut);
        }
        if ((unmappedTechnicalCategory = omDto.getUnmappedTechnical()) != null) {
            this.fillObjectMappingCategory(unmappedTechnicalCategory, om.getUnmappedTechnicalCategory(), aut);
        }
        return om;
    }

    private void fillObjectMappingCategory(OmCategoryDTO categoryDto, IObjectMappingCategoryPO category, IAUTMainPO aut) {
        category.setName(categoryDto.getName());
        category.setAutMainParent(aut);
        this.m_omCategories.put(categoryDto.getId(), category);
        for (OmCategoryDTO subcategoryDto : categoryDto.getCategories()) {
            IObjectMappingCategoryPO subcategory = PoMaker.createObjectMappingCategoryPO((String)subcategoryDto.getName(), (IAUTMainPO)this.m_autRef.get(categoryDto.getAut()));
            category.addCategory(subcategory);
            this.fillObjectMappingCategory(subcategoryDto, subcategory, aut);
        }
        for (OmEntryDTO assocDTO : categoryDto.getAssociations()) {
            TechnicalNameDTO tecNameDto = assocDTO.getTechnicalName();
            List<String> logNames = assocDTO.getLogicalNames();
            ComponentIdentifier tecName = null;
            if (tecNameDto != null) {
                tecName = new ComponentIdentifier();
                tecName.setComponentClassName(tecNameDto.getComponentClassName());
                tecName.setSupportedClassName(tecNameDto.getSupportedClassName());
                tecName.setAlternativeDisplayName(tecNameDto.getAlternativeDisplayName());
                tecName.setNeighbours(new ArrayList<String>(tecNameDto.getNeighbours()));
                tecName.setHierarchyNames(new ArrayList<String>(tecNameDto.getHierarchyNames()));
                ObjectMappingProfileDTO omp = tecNameDto.getObjectMappingProfile();
                if (omp != null) {
                    Profile p = new Profile(omp.getName(), omp.getNameFactor(), omp.getPathFactor(), omp.getContextFactor(), omp.getThreshold());
                    tecName.setProfile((org.eclipse.jubula.tools.Profile)p);
                }
            }
            IObjectMappingAssoziationPO assoc = PoMaker.createObjectMappingAssoziationPO((IComponentIdentifier)tecName, new HashSet<String>(logNames));
            assoc.setType(assocDTO.getType());
            category.addAssociation(assoc);
        }
    }

    public IProjectPropertiesPO fillProjectProperties(IProjectPO proj, ProjectDTO dto) {
        proj.setComment(dto.getComment());
        proj.setMarkupLanguage(dto.getMarkupLanguage());
        proj.setToolkit(dto.getAutToolKit());
        proj.setIsReusable(dto.isReusable());
        proj.setIsProtected(dto.isProtected());
        IProjectPropertiesPO projProperties = proj.getProjectProperties();
        projProperties.getCheckConfCont().setEnabled(dto.isTeststyleEnabled());
        projProperties.setIsTrackingActivated(dto.isTrackingEnabled());
        projProperties.setTrackChangesSignature(dto.getTrackingAttribute());
        if (dto.getTrackingUnit() != null) {
            projProperties.setTrackChangesUnit(TrackingUnit.valueOf((String)dto.getTrackingUnit()));
        }
        projProperties.setTrackChangesSpan(dto.getTrackingSpan());
        return projProperties;
    }

    private void handleTestSuitesAndTestJobsAndCategories(IProjectPO proj, ProjectDTO dto, boolean assignNewGuid) throws InterruptedException, InvalidDataException {
        for (NodeDTO node : dto.getExecCategories()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            proj.getExecObjCont().addNode(this.createTestSuitesOrTestJobsOrCategories(proj, node, assignNewGuid));
        }
    }

    private INodePO createTestSuitesOrTestJobsOrCategories(IProjectPO proj, NodeDTO dto, boolean assignNewGuid) throws InvalidDataException {
        if (dto instanceof ExecCategoryDTO) {
            return this.createExecCategory(proj, (ExecCategoryDTO)dto, assignNewGuid);
        }
        if (dto instanceof TestSuiteDTO) {
            return this.createTestSuite(proj, (TestSuiteDTO)dto, assignNewGuid);
        }
        if (dto instanceof TestJobDTO) {
            return this.createTestJob((TestJobDTO)dto, assignNewGuid);
        }
        return null;
    }

    private INodePO createTestJob(TestJobDTO dto, boolean assignNewGuid) throws InvalidDataException {
        ITestJobPO tj = dto.getUuid() != null && !assignNewGuid ? NodeMaker.createTestJobPO((String)dto.getName(), (String)dto.getUuid()) : NodeMaker.createTestJobPO((String)dto.getName());
        tj.setComment(dto.getComment());
        tj.setDescription(dto.getDescription());
        tj.setTaskId(dto.getTaskId());
        this.fillTrackedChangesInformation((INodePO)tj, dto);
        for (NodeDTO dtoRefs : dto.getRefTestSuites()) {
            if (dtoRefs instanceof RefTestSuiteDTO) {
                IRefTestSuitePO rts;
                RefTestSuiteDTO dtoRts = (RefTestSuiteDTO)dtoRefs;
                if (assignNewGuid) {
                    String testSuiteGuid = this.m_oldToNewGuids.get(dtoRts.getTsUuid());
                    if (testSuiteGuid == null) {
                        throw new InvalidDataException("Test Suite Reference: No new GUID found for Test Suite with old GUID: " + dtoRts.getTsUuid(), MessageIDs.E_IMPORT_PROJECT_XML_FAILED);
                    }
                    rts = NodeMaker.createRefTestSuitePO((String)dtoRts.getName(), (String)testSuiteGuid, (String)dtoRts.getAutId());
                } else {
                    rts = NodeMaker.createRefTestSuitePO((String)dtoRts.getName(), (String)dtoRts.getUuid(), (String)dtoRts.getTsUuid(), (String)dtoRts.getAutId());
                }
                rts.setComment(dtoRts.getComment());
                rts.setDescription(dtoRts.getDescription());
                tj.addNode((INodePO)rts);
                continue;
            }
            if (!(dtoRefs instanceof CommentDTO)) continue;
            tj.addNode((INodePO)this.createComment((CommentDTO)dtoRefs, assignNewGuid));
        }
        return tj;
    }

    private INodePO createExecCategory(IProjectPO proj, ExecCategoryDTO dto, boolean assignNewGuid) throws InvalidDataException {
        ICategoryPO cat = dto.getUuid() != null && !assignNewGuid ? NodeMaker.createCategoryPO((String)dto.getName(), (String)dto.getUuid()) : NodeMaker.createCategoryPO((String)dto.getName());
        cat.setGenerated(dto.getGenerated());
        cat.setComment(dto.getComment());
        cat.setDescription(dto.getDescription());
        cat.setTaskId(dto.getTaskId());
        for (NodeDTO node : dto.getNodes()) {
            cat.addNode(this.createTestSuitesOrTestJobsOrCategories(proj, node, assignNewGuid));
        }
        return cat;
    }

    private INodePO createTestSuite(IProjectPO proj, TestSuiteDTO dto, boolean assignNewGuid) throws InvalidDataException {
        ITestSuitePO ts = dto.getUuid() != null && !assignNewGuid ? NodeMaker.createTestSuitePO((String)dto.getName(), (String)dto.getUuid()) : NodeMaker.createTestSuitePO((String)dto.getName());
        if (assignNewGuid) {
            this.m_oldToNewGuids.put(dto.getUuid(), ts.getGuid());
        }
        ts.setComment(dto.getComment());
        ts.setDescription(dto.getDescription());
        ts.setTaskId(dto.getTaskId());
        ts.setTrackedChangesMap(dto.getTrackedModifications());
        if (dto.getSelectedAut() != null) {
            ts.setAut(this.m_autRef.get(dto.getSelectedAut()));
        }
        for (NodeDTO ref : dto.getUsedTestCases()) {
            if (ref instanceof RefTestCaseDTO) {
                ts.addNode((INodePO)this.createExecTestCase(proj, (RefTestCaseDTO)ref, assignNewGuid));
                continue;
            }
            if (ref instanceof CommentDTO) {
                ts.addNode((INodePO)this.createComment((CommentDTO)ref, assignNewGuid));
                continue;
            }
            if (ref instanceof ConditionalStatementDTO) {
                ts.addNode((INodePO)this.createConditionalStatement((ConditionalStatementDTO)ref, proj, assignNewGuid));
                continue;
            }
            if (ref instanceof WhileDTO) {
                ts.addNode((INodePO)this.createWhile(proj, (WhileDTO)ref, assignNewGuid));
                continue;
            }
            if (!(ref instanceof IterateDTO)) continue;
            ts.addNode((INodePO)this.createIterate(proj, (IterateDTO)ref, assignNewGuid));
        }
        HashMap<String, Integer> defaultEventHandler = new HashMap<String, Integer>();
        for (DefaultEventHandlerDTO evh : dto.getEventHandlers()) {
            defaultEventHandler.put(evh.getEvent(), ReentryProperty.getPropertyFromName((String)evh.getReentryProperty()).getValue());
        }
        ts.setDefaultEventHandler(defaultEventHandler);
        ts.setStepDelay(dto.getStepDelay());
        ts.setRelevant(dto.isRelevant());
        return ts;
    }

    private IExecTestCasePO createExecTestCase(IProjectPO proj, RefTestCaseDTO dto, boolean assignNewGuid) {
        ISpecTestCasePO refTc = ImportExportUtil.findReferencedTCByGuid(dto.getTestcaseUuid(), dto.getProjectUuid(), proj, assignNewGuid, this.m_oldToNewGuids, this.m_tcRef);
        IExecTestCasePO exec = refTc == null ? (!assignNewGuid ? NodeMaker.createExecTestCasePO((String)dto.getTestcaseUuid(), (String)dto.getProjectUuid(), (String)dto.getUuid()) : NodeMaker.createExecTestCasePO((String)dto.getTestcaseUuid(), (String)dto.getProjectUuid())) : (dto.getUuid() != null && !assignNewGuid ? NodeMaker.createExecTestCasePO((ISpecTestCasePO)refTc, (String)dto.getUuid()) : NodeMaker.createExecTestCasePO((ISpecTestCasePO)refTc));
        this.fillExecTestCase(proj, dto, exec, assignNewGuid);
        exec.clearCachedSpecTestCase();
        return exec;
    }

    private void fillExecTestCase(IProjectPO proj, RefTestCaseDTO dto, IExecTestCasePO exec, boolean assignNewGuid) {
        exec.setName(dto.getName());
        exec.setComment(dto.getComment());
        exec.setDescription(dto.getDescription());
        exec.setGenerated(dto.getGenerated());
        exec.setTaskId(dto.getTaskId());
        exec.setActive(dto.isActive());
        exec.setDataFile(dto.getDatafile());
        exec.setJUnitTestSuite(dto.isJunitSuite());
        if (dto.getReferencedTestData() != null) {
            String referencedDataName = dto.getReferencedTestData();
            ITestDataCubePO[] iTestDataCubePOArray = TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)proj);
            int n = iTestDataCubePOArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestDataCubePO testDataCube = iTestDataCubePOArray[n2];
                if (referencedDataName.equals(testDataCube.getName())) {
                    exec.setReferencedDataCube((IParameterInterfacePO)testDataCube);
                    break;
                }
                ++n2;
            }
        }
        if (dto.isHasOwnTestdata()) {
            exec.setDataManager(this.createTDManager((IParameterInterfacePO)exec, dto.getTDManager(), assignNewGuid));
        }
        for (ComponentNamesPairDTO overridden : dto.getOverriddenNames()) {
            ICompNamesPairPO compName = PoMaker.createCompNamesPairPO((String)overridden.getOriginalName(), (String)overridden.getNewName(), null);
            compName.setPropagated(overridden.isPropagated());
            exec.addCompNamesPair(compName);
        }
    }

    private ITDManager createTDManager(IParameterInterfacePO owner, TDManagerDTO dto, boolean assignNewGuids) {
        if (dto == null) {
            return PoMaker.createTDManagerPO((IParameterInterfacePO)owner);
        }
        ArrayList<String> uniqueIds = new ArrayList<String>(dto.getUniqueIds());
        if (assignNewGuids) {
            ArrayList<String> newUniqueIds = new ArrayList<String>();
            for (String id : uniqueIds) {
                if (Pattern.matches("[0-9a-fA-F]{32}", id) && this.m_oldToNewGuids.containsKey(id)) {
                    newUniqueIds.add(this.m_oldToNewGuids.get(id));
                    continue;
                }
                newUniqueIds.add(id);
            }
            uniqueIds = newUniqueIds;
        }
        ITDManager tdman = uniqueIds.isEmpty() ? PoMaker.createTDManagerPO((IParameterInterfacePO)owner) : PoMaker.createTDManagerPO((IParameterInterfacePO)owner, uniqueIds);
        for (DataRowDTO row : dto.getDataSets()) {
            ArrayList<String> td = new ArrayList<String>(row.getColumns().size());
            for (String column : row.getColumns()) {
                td.add(this.readData(column, owner));
            }
            tdman.insertDataSet(PoMaker.createListWrapperPO(td), tdman.getDataSetCount());
        }
        return tdman;
    }

    private String readData(String column, IParameterInterfacePO owner) {
        if (column != null) {
            try {
                ModelParamValueConverter converter = new ModelParamValueConverter(column, owner, null);
                if (!converter.containsErrors()) {
                    converter.replaceUuidsInReferences(this.m_oldToNewGuids);
                }
                return converter.getModelString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return column;
    }

    private void documentRequiredProjects(ProjectDTO dto) {
        if (dto.getReusedProjects().size() > 0) {
            String msg = NLS.bind((String)Messages.XmlImporterProjectDependency, (Object[])new Object[]{dto.getName(), new ProjectVersion(dto.getMajorProjectVersion(), dto.getMinorProjectVersion(), dto.getMicroProjectVersion(), dto.getProjectVersionQualifier())});
            for (ReusedProjectDTO rp : dto.getReusedProjects()) {
                msg = String.valueOf(msg) + "\n\t";
                ProjectVersion version = new ProjectVersion(rp.getMajorProjectVersion(), rp.getMinorProjectVersion(), rp.getMicroProjectVersion(), rp.getProjectVersionQualifier());
                msg = String.valueOf(msg) + (rp.getProjectName() != null ? NLS.bind((String)Messages.XmlImporterRequiredProject, (Object[])new Object[]{rp.getProjectName(), version}) : NLS.bind((String)Messages.XmlImporterRequiredProjectWithoutName, (Object[])new Object[]{rp.getProjectUuid(), version}));
            }
            Status s = new Status(1, "org.eclipse.jubula.client.core", msg);
            this.m_io.writeStatus((IStatus)s);
        }
    }

    private void checkUsedToolkits(ProjectDTO dto) throws JBVersionException {
        HashSet<IUsedToolkitPO> usedTK = new HashSet<IUsedToolkitPO>();
        for (UsedToolkitDTO usedToolkit : dto.getUsedToolkits()) {
            usedTK.add(PoMaker.createUsedToolkitsPO((String)usedToolkit.getName(), (int)usedToolkit.getMajorVersion(), (int)usedToolkit.getMinorVersion(), null));
        }
        ArrayList<String> errorMsgs = new ArrayList<String>();
        if (!this.validateToolkitVersion(usedTK, dto.getName(), errorMsgs)) {
            throw new JBVersionException(Messages.IncompatibleToolkitVersion, MessageIDs.E_LOAD_PROJECT_TOOLKIT_MAJOR_VERSION_ERROR, errorMsgs);
        }
    }

    private boolean validateToolkitVersion(Set<IUsedToolkitPO> usedTK, String projName, List<String> errorMsgs) {
        List errors = UsedToolkitBP.getInstance().checkUsedToolkitPluginVersions(usedTK);
        if (errors.isEmpty()) {
            return true;
        }
        boolean loadProject = true;
        for (UsedToolkitBP.ToolkitPluginError error : errors) {
            StringBuilder strBuilder = new StringBuilder();
            String toolkitId = error.getToolkitId();
            ToolkitDescriptor desc = ComponentBuilder.getInstance().getCompSystem().getToolkitDescriptor(toolkitId);
            String toolkitName = desc != null ? desc.getName() : toolkitId;
            strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict2).append(toolkitName).append(Messages.XmlImporterToolkitVersionConflict3a).append(projName).append(Messages.XmlImporterToolkitVersionConflict3b);
            UsedToolkitBP.ToolkitPluginError.ERROR errorType = error.getError();
            String descr = Messages.OpenProjectActionToolkitVersionConflict5;
            switch (errorType) {
                case MAJOR_VERSION_ERROR: {
                    strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict4a);
                    strBuilder.append(descr);
                    errorMsgs.add(strBuilder.toString());
                    loadProject = false;
                    break;
                }
                case MINOR_VERSION_HIGHER: {
                    strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict4b);
                    strBuilder.append(descr);
                    errorMsgs.add(strBuilder.toString());
                    loadProject = false;
                    break;
                }
                case MINOR_VERSION_LOWER: {
                    break;
                }
                default: {
                    Assert.notReached((String)(String.valueOf(Messages.UnknownErrorType) + String.valueOf(errorType)));
                }
            }
        }
        return loadProject;
    }

    private int getWorkToImport(int numberOfCategoryOfProject) {
        int work = 1;
        ++work;
        ++work;
        ++work;
        work += numberOfCategoryOfProject;
        ++work;
        ++work;
        return ++work;
    }
}

