/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSBlockFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigure;

public class CSSPageFlowLayout
extends CSSBlockFlowLayout {
    private Dimension _pageSize = new Dimension();
    private int _recommendedWidth;
    private int[] _pageSizeCacheKeys = new int[4];
    private Dimension[] _pageSizeCacheValues = new Dimension[4];

    public CSSPageFlowLayout(CSSFigure cssfigure) {
        super(cssfigure);
    }

    public void invalidate() {
        super.invalidate();
        this._pageSizeCacheKeys = new int[4];
        this._pageSizeCacheValues = new Dimension[4];
        this._pageSize = new Dimension();
        this._recommendedWidth = 0;
    }

    protected void endBlock() {
        this.layoutLines();
    }

    public void postValidate() {
        Rectangle r = new Rectangle(this._blockBox._x, this._blockBox._y, this._blockBox.getWidth(), this._blockBox.getHeight());
        r = r.expand(this.getCSSFigure().getInsets());
        this._pageSize.width = r.width;
        this._pageSize.height = r.height;
        List list = this.getCSSFigure().getChildren();
        int i = 0;
        while (i < list.size()) {
            ((FlowFigure)((Object)list.get(i))).postValidate();
            ++i;
        }
    }

    protected void setupBlock() {
        this._blockBox.clear();
        int recommendedWidth = this.getRecommendedWidth();
        this._blockBox.setRecommendedWidth(recommendedWidth);
        if (recommendedWidth > 0 && recommendedWidth != Integer.MAX_VALUE) {
            this._blockBox.setWidth(recommendedWidth);
        }
        this._blockBox._x = 0;
    }

    private int getRecommendedWidth() {
        return this._recommendedWidth;
    }

    private void setRecommendedWidth(int width) {
        if (this._recommendedWidth == width) {
            return;
        }
        this._recommendedWidth = width;
        this.getCSSFigure().invalidate2();
    }

    public void setBoundsCalled(Rectangle r, boolean invalidate) {
        super.setBoundsCalled(r, invalidate);
        CSSFigure figure = this.getCSSFigure();
        int newWidth = r.width - figure.getInsets().getWidth();
        if (invalidate || this.getRecommendedWidth() != newWidth) {
            this.setRecommendedWidth(newWidth);
            figure.getUpdateManager().addInvalidFigure((IFigure)figure);
        }
    }

    public Dimension getPreferredSize(IFigure container, int width, int h) {
        if (width >= 0) {
            width = Math.max(0, width - container.getInsets().getWidth());
        }
        int i = 0;
        while (i < 4) {
            if (this._pageSizeCacheKeys[i] == width && this._pageSizeCacheValues[i] != null) {
                return this._pageSizeCacheValues[i];
            }
            ++i;
        }
        this._pageSizeCacheKeys[3] = this._pageSizeCacheKeys[2];
        this._pageSizeCacheKeys[2] = this._pageSizeCacheKeys[1];
        this._pageSizeCacheKeys[1] = this._pageSizeCacheKeys[0];
        this._pageSizeCacheKeys[0] = width;
        this._pageSizeCacheValues[3] = this._pageSizeCacheValues[2];
        this._pageSizeCacheValues[2] = this._pageSizeCacheValues[1];
        this._pageSizeCacheValues[1] = this._pageSizeCacheValues[0];
        int oldWidth = this.getRecommendedWidth();
        this.setRecommendedWidth(width);
        container.validate();
        this._pageSizeCacheValues[0] = this._pageSize.getExpanded(container.getInsets().getWidth(), container.getInsets().getHeight());
        if (width != oldWidth) {
            this.setRecommendedWidth(oldWidth);
            container.getUpdateManager().addInvalidFigure(container);
        }
        return this._pageSizeCacheValues[0];
    }
}

