/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import java.util.List;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IBendableContentPart;

public class BendContentOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final IBendableContentPart<? extends Node> bendableContentPart;
    private List<IBendableContentPart.BendPoint> initialBendPoints;
    private List<IBendableContentPart.BendPoint> finalBendPoints;

    public BendContentOperation(IBendableContentPart<? extends Node> bendableContentPart, List<IBendableContentPart.BendPoint> initialBendPoints, List<IBendableContentPart.BendPoint> finalBendPoints) {
        super("Bend Content");
        this.bendableContentPart = bendableContentPart;
        this.initialBendPoints = initialBendPoints;
        this.finalBendPoints = finalBendPoints;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.bendableContentPart.setContentBendPoints(this.finalBendPoints);
        return Status.OK_STATUS;
    }

    @Override
    public boolean isContentRelevant() {
        return true;
    }

    @Override
    public boolean isNoOp() {
        return this.initialBendPoints == null ? this.finalBendPoints == null : this.initialBendPoints.equals(this.finalBendPoints);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.bendableContentPart.setContentBendPoints(this.initialBendPoints);
        return Status.OK_STATUS;
    }
}

