/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.geometry.planar;

import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.IMultiShape;
import org.eclipse.gef.geometry.planar.IShape;

abstract class AbstractGeometry
implements IGeometry {
    private static final long serialVersionUID = 1L;

    AbstractGeometry() {
    }

    public Object clone() {
        return this.getCopy();
    }

    @Override
    public IGeometry getTransformed(AffineTransform t) {
        return this.toPath().getTransformed(t);
    }

    public final int hashCode() {
        return 0;
    }

    @Override
    public boolean touches(IGeometry g) {
        if (this instanceof ICurve) {
            if (g instanceof ICurve) {
                return ((ICurve)((Object)this)).intersects((ICurve)g) || ((ICurve)((Object)this)).overlaps((ICurve)g);
            }
            if (g instanceof IShape) {
                return ((IShape)g).contains(this) || this.touches(((IShape)g).getOutline());
            }
            if (g instanceof IMultiShape) {
                if (((IMultiShape)g).contains(this)) {
                    return true;
                }
                ICurve[] iCurveArray = ((IMultiShape)g).getOutlineSegments();
                int n = iCurveArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICurve c = iCurveArray[n2];
                    if (this.touches(c)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            throw new UnsupportedOperationException("Not yet implemented: touches(" + this + ", " + g + ")");
        }
        if (this instanceof IShape) {
            if (g instanceof ICurve) {
                return ((IShape)((Object)this)).contains(g) || ((IShape)((Object)this)).getOutline().touches(g);
            }
            if (g instanceof IShape) {
                return ((IShape)((Object)this)).contains(g) || ((IShape)g).contains(this) || ((IShape)((Object)this)).getOutline().touches(((IShape)g).getOutline());
            }
            if (g instanceof IMultiShape) {
                if (((IShape)((Object)this)).contains(g)) {
                    return true;
                }
                if (((IMultiShape)g).contains(this)) {
                    return true;
                }
                ICurve thisOutline = ((IShape)((Object)this)).getOutline();
                ICurve[] iCurveArray = ((IMultiShape)g).getOutlineSegments();
                int n = iCurveArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ICurve c = iCurveArray[n3];
                    if (thisOutline.touches(c)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            throw new UnsupportedOperationException("Not yet implemented: touches(" + this + ", " + g + ")");
        }
        if (this instanceof IMultiShape) {
            IMultiShape thisPolyShape = (IMultiShape)((Object)this);
            if (g instanceof ICurve) {
                ICurve gCurve = (ICurve)g;
                if (thisPolyShape.contains(gCurve)) {
                    return true;
                }
                ICurve[] iCurveArray = thisPolyShape.getOutlineSegments();
                int n = iCurveArray.length;
                int n4 = 0;
                while (n4 < n) {
                    ICurve c = iCurveArray[n4];
                    if (gCurve.touches(c)) {
                        return true;
                    }
                    ++n4;
                }
                return false;
            }
            if (g instanceof IShape) {
                IShape gShape = (IShape)g;
                if (thisPolyShape.contains(gShape) || gShape.contains(thisPolyShape)) {
                    return true;
                }
                ICurve gOutline = gShape.getOutline();
                ICurve[] iCurveArray = thisPolyShape.getOutlineSegments();
                int n = iCurveArray.length;
                int n5 = 0;
                while (n5 < n) {
                    ICurve c = iCurveArray[n5];
                    if (gOutline.touches(c)) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            if (g instanceof IMultiShape) {
                IMultiShape gMultiShape = (IMultiShape)g;
                if (thisPolyShape.contains(gMultiShape) || gMultiShape.contains(thisPolyShape)) {
                    return true;
                }
                ICurve[] iCurveArray = thisPolyShape.getOutlineSegments();
                int n = iCurveArray.length;
                int n6 = 0;
                while (n6 < n) {
                    ICurve thisOutlineSeg = iCurveArray[n6];
                    ICurve[] iCurveArray2 = gMultiShape.getOutlineSegments();
                    int n7 = iCurveArray2.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        ICurve gOutlineSeg = iCurveArray2[n8];
                        if (thisOutlineSeg.touches(gOutlineSeg)) {
                            return true;
                        }
                        ++n8;
                    }
                    ++n6;
                }
                return false;
            }
            throw new UnsupportedOperationException("Not yet implemented: touches(" + this + ", " + g + ")");
        }
        throw new UnsupportedOperationException("Not yet implemented: touches(" + this + ", " + g + ")");
    }
}

