/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome.db;

import org.eclipse.emf.cdo.server.internal.lissome.db.Index;
import org.eclipse.emf.cdo.server.internal.lissome.db.Table;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;

public class ObjectsTable
extends Table {
    protected IDBField branch;
    protected IDBField time;
    protected IDBField revised;
    protected IDBField version;
    protected IDBField cid;
    protected IDBField oid = this.addCDOIDField("cdo_oid");
    protected IDBField container;
    protected IDBField name;
    protected IDBField pointer;

    public ObjectsTable(Index index) {
        super(index, "cdo_objects");
        if (this.isSupportingBranches()) {
            this.branch = this.table.addField("cdo_branch", DBType.INTEGER);
        }
        if (this.isSupportingAudits()) {
            this.time = this.table.addField("cdo_time", DBType.BIGINT);
            this.revised = this.table.addField("cdo_revised", DBType.BIGINT);
            this.version = this.table.addField("cdo_version", DBType.INTEGER);
        }
        this.cid = this.table.addField("cdo_cid", DBType.INTEGER);
        this.container = this.addCDOIDField("cdo_container");
        this.name = this.table.addField("cdo_name", DBType.VARCHAR, 255);
        this.pointer = this.table.addField("cdo_pointer", DBType.BIGINT);
        this.table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.oid, this.time, this.branch});
    }

    protected boolean addCriterion(StringBuilder builder, boolean needAnd, boolean withBranch, boolean historical) {
        if (withBranch) {
            if (needAnd) {
                builder.append(" AND ");
            }
            builder.append(this.branch);
            builder.append("=?");
            needAnd = true;
        }
        if (this.isSupportingAudits()) {
            if (needAnd) {
                builder.append(" AND ");
            }
            if (historical) {
                builder.append(this.time);
                builder.append("<=? AND (?<=");
                builder.append(this.revised);
                builder.append(" OR ");
                builder.append(this.revised);
                builder.append("=");
                builder.append(0L);
                builder.append(")");
            } else {
                builder.append(this.revised);
                builder.append("=");
                builder.append(0L);
            }
            needAnd = true;
        }
        return needAnd;
    }

    protected String sqlQueryResources(boolean historical, boolean exactMatch) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.oid);
        builder.append(" FROM ");
        builder.append(this);
        builder.append(" WHERE ");
        builder.append(this.container);
        builder.append("=? AND ");
        builder.append(this.name);
        builder.append(exactMatch ? "=?" : " LIKE ?");
        this.addCriterion(builder, true, this.isSupportingBranches(), historical);
        builder.append(" AND ");
        builder.append(this.version);
        builder.append(">=");
        builder.append(1);
        return builder.toString();
    }

    protected StringBuilder sqlReadRevision() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.pointer);
        if (this.isSupportingAudits()) {
            builder.append(", ");
            builder.append(this.revised);
        }
        builder.append(" FROM ");
        builder.append(this);
        return builder;
    }

    protected String sqlReadRevision(boolean historical) {
        StringBuilder builder = this.sqlReadRevision();
        builder.append(" WHERE ");
        builder.append(this.oid);
        builder.append("=?");
        this.addCriterion(builder, true, this.isSupportingBranches(), historical);
        return builder.toString();
    }

    protected String sqlReadRevisionByVersion() {
        StringBuilder builder = this.sqlReadRevision();
        builder.append(" WHERE ");
        builder.append(this.oid);
        builder.append("=? AND ");
        builder.append(this.branch);
        builder.append("=? AND ");
        builder.append(this.version);
        builder.append("=?");
        return builder.toString();
    }

    protected String sqlHandleRevisions(boolean withClass, boolean withBranch, boolean withTime, boolean exactTime, boolean historical) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.oid);
        builder.append(", ");
        builder.append(this.pointer);
        if (this.isSupportingAudits()) {
            builder.append(", ");
            builder.append(this.revised);
        }
        builder.append(" FROM ");
        builder.append(this);
        int appended = 0;
        if (withClass) {
            builder.append(appended++ == 0 ? " WHERE " : " AND ");
            builder.append(this.cid);
            builder.append("=?");
        }
        if (withBranch) {
            builder.append(appended++ == 0 ? " WHERE " : " AND ");
            builder.append(this.branch);
            builder.append("=?");
        }
        if (withTime) {
            if (exactTime) {
                if (historical) {
                    builder.append(appended++ == 0 ? " WHERE " : " AND ");
                    builder.append(this.time);
                    builder.append("=?");
                }
            } else {
                builder.append(appended++ == 0 ? " WHERE " : " AND ");
                this.addCriterion(builder, false, false, historical);
            }
        }
        return builder.toString();
    }

    protected String sqlAddRevision() {
        StringBuilder builder = new StringBuilder();
        StringBuilder params = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this);
        builder.append(" (");
        builder.append(this.oid);
        params.append("?");
        if (this.isSupportingBranches()) {
            builder.append(", ");
            builder.append(this.branch);
            params.append(", ?");
        }
        if (this.isSupportingAudits()) {
            builder.append(", ");
            builder.append(this.time);
            params.append(", ?");
            builder.append(", ");
            builder.append(this.revised);
            params.append(", ?");
            builder.append(", ");
            builder.append(this.version);
            params.append(", ?");
        }
        builder.append(", ");
        builder.append(this.cid);
        params.append(", ?");
        builder.append(", ");
        builder.append(this.container);
        params.append(", ?");
        builder.append(", ");
        builder.append(this.name);
        params.append(", ?");
        builder.append(", ");
        builder.append(this.pointer);
        params.append(", ?");
        builder.append(") VALUES (");
        builder.append((CharSequence)params);
        builder.append(")");
        return builder.toString();
    }

    protected String sqlReviseOldRevisions() {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this);
        builder.append(" SET ");
        builder.append(this.revised);
        builder.append("=?");
        builder.append(" WHERE ");
        builder.append(this.oid);
        builder.append("=?");
        if (this.isSupportingBranches()) {
            builder.append(" AND ");
            builder.append(this.branch);
            builder.append("=?");
        }
        builder.append(" AND ");
        builder.append(this.version);
        builder.append("=?");
        return builder.toString();
    }
}

