/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.ui;

import java.io.File;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.ISendFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferResponseEvent;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.xmpp.ui.Messages;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.ui.roster.AbstractRosterEntryContributionItem;
import org.eclipse.ecf.provider.xmpp.XMPPContainer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class XMPPCompoundContributionItem
extends AbstractRosterEntryContributionItem {
    protected IAction[] makeActions() {
        return null;
    }

    protected IContributionItem[] getContributionItems() {
        Object selection = this.getSelection();
        if (!(selection instanceof IRosterEntry)) {
            return EMPTY_ARRAY;
        }
        final IRosterEntry entry = (IRosterEntry)selection;
        IContainer container = this.getContainerForRosterEntry(entry);
        if (container instanceof XMPPContainer) {
            IContributionItem[] contributions = new IContributionItem[1];
            final ISendFileTransferContainerAdapter ioftca = (ISendFileTransferContainerAdapter)container.getAdapter(ISendFileTransferContainerAdapter.class);
            if (ioftca == null || !this.isAvailable(entry)) {
                return EMPTY_ARRAY;
            }
            Action fileSendAction = new Action(){

                public void run() {
                    XMPPCompoundContributionItem.this.sendFileToTarget(ioftca, entry.getUser().getID());
                }
            };
            fileSendAction.setText(Messages.XMPPCompoundContributionItem_SEND_FILE);
            fileSendAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            contributions[0] = new ActionContributionItem((IAction)fileSendAction);
            return contributions;
        }
        return EMPTY_ARRAY;
    }

    private void sendFileToTarget(ISendFileTransferContainerAdapter fileTransfer, final ID targetID) {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fd = new FileDialog(shell, 4096);
        fd.setFilterPath(System.getProperty("user.home"));
        fd.setText(NLS.bind((String)Messages.XMPPCompoundContributionItem_CHOOSE_FILE, (Object)targetID.getName()));
        final String res = fd.open();
        if (res != null) {
            File aFile = new File(res);
            try {
                IFileID targetFileID = FileIDFactory.getDefault().createFileID(fileTransfer.getOutgoingNamespace(), new Object[]{targetID, res});
                fileTransfer.sendOutgoingRequest(targetFileID, aFile, new IFileTransferListener(){

                    public void handleTransferEvent(final IFileTransferEvent event) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (event instanceof IOutgoingFileTransferResponseEvent && !((IOutgoingFileTransferResponseEvent)event).requestAccepted()) {
                                    MessageDialog.openInformation((Shell)shell, (String)Messages.XMPPCompoundContributionItem_FILE_SEND_REFUSED_TITLE, (String)NLS.bind((String)Messages.XMPPCompoundContributionItem_FILE_SEND_REFUSED_MESSAGE, (Object)res, (Object)targetID.getName()));
                                }
                            }
                        });
                    }
                }, null);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)shell, (String)Messages.XMPPCompoundContributionItem_SEND_ERROR_TITLE, (String)NLS.bind((String)Messages.XMPPCompoundContributionItem_SEND_ERROR_MESSAGE, (Object)res, (Object)e.getLocalizedMessage()));
            }
        }
    }
}

