/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.server.SecuredThread;

public abstract class Handler
extends SecuredThread {
    protected int _waitIncrement = 100;
    protected boolean _keepRunning = true;

    public void setWaitTime(int value) {
        this._waitIncrement = value;
    }

    public int getWaitTime() {
        return this._waitIncrement;
    }

    public void setDataStore(DataStore dataStore) {
        super.setDataStore(dataStore);
    }

    public boolean isFinished() {
        return !this._keepRunning;
    }

    public void finish() {
        if (this._keepRunning) {
            this._waitIncrement = 0;
            this._keepRunning = false;
            this.notifyInput();
            this.handle();
        }
    }

    public abstract void handle();

    public void run() {
        super.run();
        while (this._keepRunning) {
            this.waitForInput();
            this.handle();
        }
    }

    public synchronized void waitForInput() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.finish();
            return;
        }
    }

    public synchronized void notifyInput() {
        this.notifyAll();
    }
}

