/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions.selection;

import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.selection.BlankLineSelection;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.selection.CurrentLineSelection;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.selection.DelimeterSelection;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.selection.ISQLSelection;
import org.eclipse.jface.preference.IPreferenceStore;

public class SQLSelectionFactory {
    protected SQLSelectionFactory() {
    }

    public static SQLSelectionFactory getInstance() {
        return FactoryHolder._instance;
    }

    public ISQLSelection getSQLSelection(SQLEditor editor) {
        IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
        String executedPolicy = store.getString("SQLEditor.executeSelectedSQL");
        if (executedPolicy.equalsIgnoreCase("SQLEditor.executeSelectedSQL.betweenDelimiter")) {
            String[] terminators = new String[]{store.getString("SQLEditor.executeSelectedSQL.betweenDelimiter.delimiterType")};
            return new DelimeterSelection(editor, terminators);
        }
        if (executedPolicy.equalsIgnoreCase("SQLEditor.executeSelectedSQL.currentLine")) {
            return new CurrentLineSelection(editor);
        }
        return new BlankLineSelection(editor);
    }

    private static class FactoryHolder {
        public static SQLSelectionFactory _instance = new SQLSelectionFactory();

        private FactoryHolder() {
        }
    }
}

