/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.DefaultResizeBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractResizeContainerFeature
extends DefaultResizeBPMNShapeFeature {
    protected ContainerShape rootContainer;
    protected List<PictogramElement> descendants = new ArrayList<PictogramElement>();
    protected boolean isHorizontal;
    protected Stack<Point> containerPos = new Stack();

    public AbstractResizeContainerFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected abstract void resizeHeight(IResizeShapeContext var1);

    protected abstract void resizeWidth(IResizeShapeContext var1);

    @Override
    protected void preResizeShape(IResizeShapeContext context) {
        ContainerShape containerShape = (ContainerShape)context.getShape();
        if (this.rootContainer == null) {
            super.preResizeShape(context);
            this.rootContainer = FeatureSupport.getRootContainer(containerShape);
            this.isHorizontal = FeatureSupport.isHorizontal(this.rootContainer);
            this.descendants = FeatureSupport.getPoolAndLaneDescendants(this.rootContainer);
        }
        GraphicsAlgorithm laneGa = containerShape.getGraphicsAlgorithm();
        Point p = Graphiti.getCreateService().createPoint(laneGa.getX(), laneGa.getY());
        this.containerPos.push(p);
    }

    @Override
    protected void postResizeShape(IResizeShapeContext context) {
        ContainerShape containerShape = (ContainerShape)context.getShape();
        Point pos = this.containerPos.pop();
        if (context.getDirection() == 1 || context.getDirection() == 8 || context.getDirection() == 9 || context.getDirection() == 17 || context.getDirection() == 12) {
            int deltaX = pos.getX() - context.getX();
            int deltaY = pos.getY() - context.getY();
            Point offset = Graphiti.getCreateService().createPoint(deltaX, deltaY);
            ArrayList<ContainerShape> movedShapes = new ArrayList<ContainerShape>();
            for (PictogramElement pe : this.descendants) {
                if (!containerShape.getChildren().contains((Object)pe)) continue;
                GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
                Graphiti.getLayoutService().setLocation(ga, ga.getX() + deltaX, ga.getY() + deltaY);
                FeatureSupport.updateLabel(this.getFeatureProvider(), pe, offset);
                if (!(pe instanceof ContainerShape)) continue;
                movedShapes.add((ContainerShape)pe);
            }
            FeatureSupport.updateConnections(this.getFeatureProvider(), movedShapes);
        }
        DIUtils.updateDIShape((PictogramElement)containerShape);
        if (this.rootContainer != containerShape) {
            DIUtils.updateDIShape((PictogramElement)this.rootContainer);
        }
        FeatureSupport.updateLabel(this.getFeatureProvider(), (PictogramElement)this.rootContainer, null);
        super.postResizeShape(context);
    }
}

