/*
👋 Hi! This file was autogenerated by tslint-to-eslint-config.
https://github.com/typescript-eslint/tslint-to-eslint-config

It represents the closest reasonable ESLint configuration to this
project's original TSLint configuration.

We recommend eventually switching this configuration to extend from
the recommended rulesets in typescript-eslint.
https://github.com/typescript-eslint/tslint-to-eslint-config/blob/master/docs/FAQs.md

Happy linting! 💖
*/
module.exports = {
    'env': {
        'es6': true,
        'node': true
    },
    'parser': '@typescript-eslint/parser',
    'parserOptions': {
        'sourceType': 'module'
    },
    'plugins': [
        '@typescript-eslint',
    ],
    'rules': {
        '@typescript-eslint/consistent-type-definitions': 'error',
        '@typescript-eslint/indent': 'error',
        '@typescript-eslint/no-explicit-any': 'warn',
        '@typescript-eslint/no-unused-expressions': 'error',
        '@typescript-eslint/no-unused-vars': 'warn',
        '@typescript-eslint/quotes': [
            'error',
            'single',
            {
                'avoidEscape': true
            }
        ],
        '@typescript-eslint/semi': [
            'error',
            'always'
        ],
        '@typescript-eslint/type-annotation-spacing': 'error',
        'arrow-body-style': [
            'error',
            'always'
        ],
        'arrow-parens': [
            'error',
            'as-needed'
        ],
        'camelcase': 'off',
        'comma-dangle': 'off',
        'curly': 'error',
        'eol-last': 'error',
        'eqeqeq': [
            'error',
            'smart'
        ],
        'id-blacklist': 'off',
        'id-match': 'off',
        'max-len': [
            'error',
            {
                'code': 180
            }
        ],
        'no-multiple-empty-lines': 'error',
        'no-trailing-spaces': 'error',
        'no-underscore-dangle': 'off',
        'no-var': 'error',
        'no-void': 'error',
        'prefer-const': 'error',
        'radix': 'off',
        'space-before-function-paren': [
            'error',
            {
                'anonymous': 'always'
            }
        ]
    }
};
