import ts from "typescript";
import { SourceCode, AST, Scope } from "eslint";
import { ParserOptions } from "@typescript-eslint/parser";
import { ParseAndGenerateServicesResult, TSESTreeOptions } from "@typescript-eslint/typescript-estree";
export declare type AstConverterCreateOptions = {
    getProgram: () => ts.Program;
};
export declare class AstConverter {
    private readonly getProgram;
    constructor({ getProgram }: AstConverterCreateOptions);
    /**
     *
     * see also https://github.com/typescript-eslint/typescript-eslint/blob/master/packages/typescript-estree/src/parser.ts#L346
     *
     */
    parseAndGenerateServices(src: ts.SourceFile, options: TSESTreeOptions): ParseAndGenerateServicesResult<any>;
    /**
     * See also https://github.com/typescript-eslint/typescript-eslint/blob/master/packages/parser/src/parser.ts
     */
    parseForESLint(src: ts.SourceFile, options?: ParserOptions | null): {
        ast: AST.Program;
        scopeManager: Scope.ScopeManager;
        services: import("@typescript-eslint/parser").ParserServices;
        visitorKeys: SourceCode.VisitorKeys;
    };
    convertToESLintSourceCode(src: ts.SourceFile, options?: ParserOptions | null): SourceCode;
}
