/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.parser;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.xwt.DefaultLoadingContext;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTLoaderManager;
import org.eclipse.e4.xwt.core.IElementLoaderFactory;
import org.eclipse.e4.xwt.core.IRenderingContext;
import org.eclipse.e4.xwt.core.IVisualElementLoader;
import org.eclipse.e4.xwt.forms.XWTForms;
import org.eclipse.e4.xwt.internal.core.Core;
import org.eclipse.e4.xwt.internal.xml.Element;
import org.eclipse.e4.xwt.javabean.ResourceLoader;
import org.eclipse.e4.xwt.javabean.metadata.Metaclass;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Button;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.utils.xml.DocumentModelVisitor;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.utils.GlobalStateXml;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.xwt.model.util.NamePropertySupport;
import org.eclipse.wb.internal.xwt.model.util.NameSupport;
import org.eclipse.wb.internal.xwt.model.util.XwtListenerProperties;
import org.eclipse.wb.internal.xwt.model.util.XwtStaticFieldSupport;
import org.eclipse.wb.internal.xwt.model.util.XwtStringArraySupport;
import org.eclipse.wb.internal.xwt.model.util.XwtTagResolver;
import org.eclipse.wb.internal.xwt.parser.XwtEditorContext;
import org.eclipse.wb.internal.xwt.parser.XwtParserBindToElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XwtParser {
    private final EditorContext m_context;
    private final IFile m_file;
    private final IDocument m_document;
    private final Map<String, DocumentElement> m_pathToElementMap = Maps.newHashMap();
    private final Map<String, XmlObjectInfo> m_pathToModelMap = Maps.newHashMap();
    private XmlObjectInfo m_rootModel;
    private static final String[] FORMS_CLASSES = new String[]{"org.eclipse.e4.xwt.forms.metaclass.FormMetaclass", "org.eclipse.e4.xwt.forms.metaclass.ButtonMetaclass", "org.eclipse.e4.xwt.forms.metaclass.CompositeMetaclass", "org.eclipse.e4.xwt.forms.metaclass.ExpandableCompositeMetaclass", "org.eclipse.e4.xwt.forms.metaclass.FormMetaclass", "org.eclipse.e4.xwt.forms.metaclass.FormTextMetaclass", "org.eclipse.e4.xwt.forms.metaclass.HyperlinkMetaclass", "org.eclipse.e4.xwt.forms.metaclass.ImageHyperlinkMetaclass", "org.eclipse.e4.xwt.forms.metaclass.LabelMetaclass", "org.eclipse.e4.xwt.forms.metaclass.ScrolledFormMetaclass", "org.eclipse.e4.xwt.forms.metaclass.ScrolledPageBookMetaclass", "org.eclipse.e4.xwt.forms.metaclass.SectionMetaclass", "org.eclipse.e4.xwt.forms.metaclass.TableMetaclass", "org.eclipse.e4.xwt.forms.metaclass.TextMetaclass"};

    public XwtParser(IFile file, IDocument document) throws Exception {
        this.m_file = file;
        this.m_document = document;
        this.m_context = new XwtEditorContext(file, this.m_document);
    }

    public XmlObjectInfo parse() throws Exception {
        return (XmlObjectInfo)ExecutionUtils.runDesignTime((RunnableObjectEx)new RunnableObjectEx<XmlObjectInfo>(){

            public XmlObjectInfo runObject() throws Exception {
                return XwtParser.this.parse0();
            }
        });
    }

    private XmlObjectInfo parse0() throws Exception {
        this.m_context.initialize();
        this.m_context.setParsing(true);
        this.fillMap_pathToElement();
        this.m_context.getBroadcastSupport().addListener(null, (Object)new XwtParserBindToElement(){

            public void invoke(XmlObjectInfo object, DocumentElement element) {
                String path = XwtParser.getPath(element);
                XwtParser.this.m_pathToModelMap.put(path, object);
            }
        });
        Core profile = new Core(new IElementLoaderFactory(){
            private int m_level;

            public IVisualElementLoader createElementLoader(IRenderingContext context, IXWTLoader loader) {
                return new ResourceLoader(context, loader){
                    private final Set<Element> m_processedElements;
                    {
                        this.m_processedElements = Sets.newHashSet();
                    }

                    protected void postCreation0(final Element element, final Object targetObject) {
                        if (m_level > 1) {
                            return;
                        }
                        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                            public void run() throws Exception {
                                this.postCreationEx(element, targetObject);
                            }
                        });
                    }

                    private void postCreationEx(Element element, Object targetObject) throws Exception {
                        String path = XwtParser.getPath(element);
                        DocumentElement xmlElement = (DocumentElement)XwtParser.this.m_pathToElementMap.get(path);
                        if (xmlElement == null) {
                            return;
                        }
                        XmlObjectInfo objectInfo = XwtParser.this.createObjectInfo(targetObject, xmlElement);
                        if (objectInfo == null) {
                            return;
                        }
                        XwtParser.this.m_pathToModelMap.put(path, objectInfo);
                        if ("0".equals(path)) {
                            XwtParser.this.m_rootModel = objectInfo;
                        } else {
                            XmlObjectInfo parentObjectInfo = XwtParser.this.getParentObjectInfo(element);
                            if (parentObjectInfo != null) {
                                parentObjectInfo.addChild((ObjectInfo)objectInfo);
                            }
                        }
                    }

                    private boolean isRoot(Element element) {
                        if (!this.m_processedElements.contains(element)) {
                            this.m_processedElements.add(element);
                            return "0".equals(element.getPath());
                        }
                        return false;
                    }

                    protected Object doCreate(Object parent, Element element, Class<?> constraintType, Map<String, Object> options) throws Exception {
                        boolean isRoot = this.isRoot(element);
                        try {
                            if (isRoot) {
                                3 v0 = this;
                                v0.m_level = v0.m_level + 1;
                            }
                            Object object = super.doCreate(parent, element, constraintType, options);
                            return object;
                        }
                        finally {
                            if (isRoot) {
                                3 v1 = this;
                                v1.m_level = v1.m_level - 1;
                            }
                        }
                    }
                };
            }
        }, XWTLoaderManager.getActive());
        XWT.applyProfile((Object)profile);
        ILoadingContext _loadingContext = XWT.getLoadingContext();
        XWT.setLoadingContext((ILoadingContext)new DefaultLoadingContext(this.m_context.getClassLoader()));
        try {
            URI uri = this.m_file.getLocationURI();
            IPath localPath = URIUtil.toPath((URI)uri);
            String host = uri.getHost();
            URL url = (host != null && localPath == null ? uri : URIUtil.toURI((IPath)localPath)).toURL();
            String content = this.m_document.get();
            HashMap options = Maps.newHashMap();
            options.put("XWT.DesignMode", Boolean.TRUE);
            XwtParser.configureForForms(this.m_context, options);
            XWT.loadWithOptions((InputStream)IOUtils.toInputStream((String)content), (URL)url, (Map)options);
        }
        finally {
            XWT.setLoadingContext((ILoadingContext)_loadingContext);
            XWT.restoreProfile();
        }
        this.m_context.setParsing(false);
        NameSupport.decoratePresentationWithName(this.m_rootModel);
        XmlObjectUtils.callRootProcessors((XmlObjectInfo)this.m_rootModel);
        new XwtTagResolver(this.m_rootModel);
        new XwtStringArraySupport(this.m_rootModel);
        new XwtStaticFieldSupport(this.m_rootModel);
        new XwtListenerProperties(this.m_rootModel);
        new NamePropertySupport(this.m_rootModel);
        GlobalStateXml.activate((XmlObjectInfo)this.m_rootModel);
        ((ObjectInfoTreeComplete)this.m_rootModel.getBroadcast(ObjectInfoTreeComplete.class)).invoke();
        this.m_rootModel.refresh_dispose();
        return this.m_rootModel;
    }

    private void fillMap_pathToElement() {
        this.m_context.getRootElement().accept(new DocumentModelVisitor(){

            public void endVisit(DocumentElement element) {
                XwtParser.this.m_pathToElementMap.put(XwtParser.getPath(element), element);
            }
        });
    }

    private XmlObjectInfo createObjectInfo(Object targetObject, DocumentElement element) throws Exception {
        Class<?> componentClass = targetObject.getClass();
        ElementCreationSupport creationSupport = new ElementCreationSupport(element);
        XmlObjectInfo objectInfo = XmlObjectUtils.createObject((EditorContext)this.m_context, componentClass, (CreationSupport)creationSupport);
        GlobalStateXml.activate((XmlObjectInfo)objectInfo);
        if (!XmlObjectUtils.hasTrueParameter((XmlObjectInfo)objectInfo, (String)"XWT.hasModel")) {
            return null;
        }
        objectInfo.setObject(targetObject);
        return objectInfo;
    }

    private XmlObjectInfo getParentObjectInfo(Element element) {
        XmlObjectInfo parent = null;
        String path = element.getPath();
        while ((parent = this.m_pathToModelMap.get(path = StringUtils.substringBeforeLast((String)path, (String)"/"))) == null && path.contains("/")) {
        }
        return parent;
    }

    static void configureForForms(EditorContext context, Map<String, Object> options) throws Exception {
        if (!XwtParser.hasForms(context)) {
            XWT.registerMetaclass((IMetaclass)new Metaclass(Button.class, null));
            return;
        }
        Object createdAction = ReflectionUtils.getFieldObject(XWTForms.class, (String)"CreatedAction");
        options.put(IXWTLoader.CREATED_CALLBACK, createdAction);
        String[] stringArray = FORMS_CLASSES;
        int n = FORMS_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            Class<?> clazz = XWTForms.class.getClassLoader().loadClass(className);
            IMetaclass metaclass = (IMetaclass)clazz.newInstance();
            XWT.registerMetaclass((IMetaclass)metaclass);
            ++n2;
        }
    }

    public static boolean hasForms(EditorContext context) {
        return context.getDocument().get().contains("Forms API");
    }

    static String getPath(DocumentElement element) {
        DocumentElement parent = element.getParent();
        if (parent == null) {
            return "0";
        }
        int index = parent.indexOf(element);
        return String.valueOf(XwtParser.getPath(parent)) + "/" + index;
    }

    static String getPath(Element element) {
        return element.getPath();
    }
}

