/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.wizards.Messages;

public abstract class DesignerNewElementWizard
extends Wizard
implements INewWizard {
    private IWorkbench fWorkbench;
    private IStructuredSelection fSelection;

    public DesignerNewElementWizard() {
        this.setNeedsProgressMonitor(true);
    }

    protected final void openResource(final IFile resource, final String editorId) {
        Display display;
        final IWorkbenchPage activePage = DesignerPlugin.getActivePage();
        if (activePage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.setDefaultEditor((IFile)resource, (String)editorId);
                        BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)DesignerPlugin.getActiveWorkbenchWindow());
                        activePage.openEditor((IEditorInput)new FileEditorInput(resource), editorId);
                    }
                    catch (PartInitException e) {
                        DesignerPlugin.log((Throwable)e);
                    }
                }
            });
        }
    }

    protected abstract void finishPage(IProgressMonitor var1) throws Exception;

    protected boolean canRunForked() {
        return true;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        ExceptionHandler.perform(e, shell, Messages.DesignerNewElementWizard_errorTitle, Messages.DesignerNewElementWizard_errorMessage);
    }

    public boolean performFinish() {
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    DesignerNewElementWizard.this.finishPage(monitor);
                }
                catch (Throwable e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wb.core", 0, e.getMessage(), e));
                }
            }
        };
        try {
            ISchedulingRule rule = null;
            Job job = Job.getJobManager().currentJob();
            if (job != null) {
                rule = job.getRule();
            }
            WorkbenchRunnableAdapter runnable = null;
            runnable = rule == null ? new WorkbenchRunnableAdapter(op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()) : new WorkbenchRunnableAdapter(op, rule, true);
            this.getContainer().run(this.canRunForked(), true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            this.handleFinishException(this.getShell(), e);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.fWorkbench = workbench;
        this.fSelection = currentSelection;
    }

    public final IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public final IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    protected static final class ExceptionHandler {
        protected ExceptionHandler() {
        }

        public static void perform(InvocationTargetException e, Shell shell, String title, String message) {
            Throwable target = e.getTargetException();
            if (target instanceof CoreException) {
                ExceptionHandler.perform((CoreException)target, shell, title, message);
            } else {
                DesignerPlugin.log((Throwable)e);
                if (e.getMessage() != null && e.getMessage().length() > 0) {
                    ExceptionHandler.displayMessageDialog(e, e.getMessage(), shell, title, message);
                } else {
                    ExceptionHandler.displayMessageDialog(e, target.getMessage(), shell, title, message);
                }
            }
        }

        private static void perform(CoreException e, Shell shell, String title, String message) {
            DesignerPlugin.log((Throwable)e);
            IStatus status = e.getStatus();
            if (status == null) {
                ExceptionHandler.displayMessageDialog(e, e.getMessage(), shell, title, message);
            } else {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
            }
        }

        private static void displayMessageDialog(Throwable t, String exceptionMessage, Shell shell, String title, String message) {
            StringWriter msg = new StringWriter();
            if (message != null) {
                msg.write(message);
                msg.write("\n\n");
            }
            if (exceptionMessage == null || exceptionMessage.length() == 0) {
                msg.write(Messages.DesignerNewElementWizard_errorSeeLog);
            } else {
                msg.write(exceptionMessage);
            }
            MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
        }
    }

    private static class WorkbenchRunnableAdapter
    implements IRunnableWithProgress,
    IThreadListener {
        private boolean fTransfer = false;
        private final IWorkspaceRunnable fWorkspaceRunnable;
        private final ISchedulingRule fRule;

        public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule) {
            this.fWorkspaceRunnable = runnable;
            this.fRule = rule;
        }

        public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule, boolean transfer) {
            this.fWorkspaceRunnable = runnable;
            this.fRule = rule;
            this.fTransfer = transfer;
        }

        public void threadChange(Thread thread) {
            if (this.fTransfer) {
                Job.getJobManager().transferRule(this.fRule, thread);
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                JavaCore.run((IWorkspaceRunnable)this.fWorkspaceRunnable, (ISchedulingRule)this.fRule, (IProgressMonitor)monitor);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

