/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.cdt.core.remotemake;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.ptp.internal.rdt.sync.cdt.core.messages.Messages;
import org.eclipse.remote.core.IRemoteProcess;

public class RemoteProcessClosure {
    protected static int fCounter = 0;
    protected IRemoteProcess fProcess;
    protected OutputStream fOutput;
    protected OutputStream fError;
    protected ReaderThread fOutputReader;
    protected ReaderThread fErrorReader;

    public RemoteProcessClosure(IRemoteProcess process, OutputStream outputStream, OutputStream errorStream) {
        this.fProcess = process;
        this.fOutput = outputStream;
        this.fError = errorStream;
    }

    public boolean isAlive() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() || this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
            this.fOutputReader.close();
            this.fErrorReader.close();
            this.fOutputReader = null;
            this.fErrorReader = null;
        }
        return false;
    }

    public boolean isRunning() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() || this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
        }
        return false;
    }

    public void runBlocking() {
        this.runNonBlocking();
        boolean finished = false;
        while (!finished) {
            try {
                this.fProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.fProcess.exitValue();
                finished = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        if (!this.fOutputReader.finished()) {
            this.fOutputReader.waitFor();
        }
        if (!this.fErrorReader.finished()) {
            this.fErrorReader.waitFor();
        }
        this.fOutputReader.close();
        this.fErrorReader.close();
        this.fProcess = null;
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    public void runNonBlocking() {
        ThreadGroup group = new ThreadGroup("CBuilder" + fCounter++);
        InputStream stdin = this.fProcess.getInputStream();
        InputStream stderr = this.fProcess.getErrorStream();
        this.fOutputReader = new ReaderThread(group, "OutputReader", stdin, this.fOutput, false, this.fProcess);
        this.fErrorReader = new ReaderThread(group, "ErrorReader", stderr, this.fError, true, this.fProcess);
        this.fOutputReader.start();
        this.fErrorReader.start();
    }

    public void terminate() {
        if (this.fProcess != null) {
            this.fProcess.destroy();
            this.fProcess = null;
        }
        if (!this.fOutputReader.finished()) {
            this.fOutputReader.waitFor();
        }
        if (!this.fErrorReader.finished()) {
            this.fErrorReader.waitFor();
        }
        this.fOutputReader.close();
        this.fErrorReader.close();
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    protected static class ReaderThread
    extends Thread {
        private final InputStream fInputStream;
        private final OutputStream fOutputStream;
        private boolean fFinished = false;
        private final String lineSeparator;
        private final boolean fIsErrorReader;
        private final IRemoteProcess theProcess;

        public ReaderThread(ThreadGroup group, String name, InputStream in, OutputStream out, boolean isErrorReader, IRemoteProcess fProcess) {
            super(group, name);
            this.fOutputStream = out;
            this.fInputStream = in;
            this.fIsErrorReader = isErrorReader;
            this.theProcess = fProcess;
            this.setDaemon(true);
            this.lineSeparator = System.getProperty("line.separator");
        }

        public void close() {
            try {
                this.fOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public synchronized void complete() {
            this.fFinished = true;
            this.notify();
        }

        public synchronized boolean finished() {
            return this.fFinished;
        }

        @Override
        public void run() {
            block27: {
                String lastLine = null;
                try {
                    try {
                        try {
                            String line;
                            BufferedReader reader = new BufferedReader(new InputStreamReader(this.fInputStream));
                            while ((line = reader.readLine()) != null) {
                                lastLine = line;
                                line = String.valueOf(line) + this.lineSeparator;
                                if (this.fOutputStream == null) continue;
                                this.fOutputStream.write(line.getBytes());
                            }
                        }
                        catch (IOException iOException) {
                            try {
                                if (!(this.fIsErrorReader || lastLine != null && lastLine.contains(Messages.RemoteProcessClosure_exit_code))) {
                                    int exit_code = 0;
                                    try {
                                        exit_code = this.theProcess.waitFor();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    String message = MessageFormat.format(Messages.RemoteProcessClosure_shell_completed, exit_code);
                                    this.fOutputStream.write(message.getBytes());
                                }
                                if (this.fOutputStream != null) {
                                    this.fOutputStream.flush();
                                }
                                break block27;
                            }
                            catch (IOException exit_code) {}
                            break block27;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (!(this.fIsErrorReader || lastLine != null && lastLine.contains(Messages.RemoteProcessClosure_exit_code))) {
                                int exit_code = 0;
                                try {
                                    exit_code = this.theProcess.waitFor();
                                }
                                catch (InterruptedException message) {
                                    // empty catch block
                                }
                                String message = MessageFormat.format(Messages.RemoteProcessClosure_shell_completed, exit_code);
                                this.fOutputStream.write(message.getBytes());
                            }
                            if (this.fOutputStream != null) {
                                this.fOutputStream.flush();
                            }
                        }
                        catch (IOException exit_code) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (!(this.fIsErrorReader || lastLine != null && lastLine.contains(Messages.RemoteProcessClosure_exit_code))) {
                            int exit_code = 0;
                            try {
                                exit_code = this.theProcess.waitFor();
                            }
                            catch (InterruptedException message) {
                                // empty catch block
                            }
                            String message = MessageFormat.format(Messages.RemoteProcessClosure_shell_completed, exit_code);
                            this.fOutputStream.write(message.getBytes());
                        }
                        if (this.fOutputStream != null) {
                            this.fOutputStream.flush();
                        }
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    this.complete();
                }
            }
        }

        public synchronized void waitFor() {
            while (!this.fFinished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

