/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.List;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationConstraintLinkEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationObservationLinkEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationUtil;

public class DurationLinkUtil
extends OccurrenceSpecificationUtil {
    public static boolean isCreateDurationLink(CreateConnectionRequest request) {
        CreateRelationshipRequest createElementRequest = DurationLinkUtil.getCreateRelationshipRequest(request);
        if (createElementRequest == null) {
            AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest createRequest;
            List types;
            return request instanceof AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest && (types = (createRequest = (AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest)request).getElementTypes()).stream().allMatch(type -> type == UMLElementTypes.DurationConstraint_Edge || type == UMLElementTypes.DurationObservation_Edge);
        }
        IElementType type2 = createElementRequest.getElementType();
        return type2 == UMLElementTypes.DurationConstraint_Edge || type2 == UMLElementTypes.DurationObservation_Edge;
    }

    public static boolean isDurationLink(CreateConnectionViewRequest createRequest) {
        String semanticHint;
        switch (semanticHint = createRequest.getConnectionViewDescriptor().getSemanticHint()) {
            case "DurationConstraint_Edge": 
            case "DurationObservation_Edge": {
                return true;
            }
        }
        return false;
    }

    public static boolean isDurationLink(ReconnectRequest request) {
        return request.getConnectionEditPart() instanceof DurationConstraintLinkEditPart || request.getConnectionEditPart() instanceof DurationObservationLinkEditPart;
    }

    public static boolean isConsistent(Connector connector, SetRequest setRequest) {
        String targetAnchor;
        Object newValue = setRequest.getValue();
        if (!(newValue instanceof List)) {
            return true;
        }
        List values = (List)newValue;
        if (values.isEmpty()) {
            return true;
        }
        View sourceView = connector.getSource();
        String sourceAnchor = connector.getSourceAnchor() instanceof IdentityAnchor ? ((IdentityAnchor)connector.getSourceAnchor()).getId() : "";
        View targetView = connector.getTarget();
        String string = targetAnchor = connector.getSourceAnchor() instanceof IdentityAnchor ? ((IdentityAnchor)connector.getTargetAnchor()).getId() : "";
        if (sourceView == null || targetView == null) {
            return false;
        }
        if (values.isEmpty()) {
            return false;
        }
        Object sourceEvent = values.get(0);
        if (sourceEvent != DurationLinkUtil.findSemanticOccurrence(sourceView, sourceAnchor)) {
            return false;
        }
        if (values.size() > 1) {
            Object targetEvent = values.get(1);
            return targetEvent == DurationLinkUtil.findSemanticOccurrence(targetView, targetAnchor);
        }
        return sourceEvent == DurationLinkUtil.findSemanticOccurrence(targetView, targetAnchor);
    }
}

