/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.merged;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.papyrus.infra.core.architecture.ADElement;

public class MergedADElement {
    protected MergedADElement parent;
    protected Set<ADElement> elements;

    public MergedADElement(MergedADElement parent) {
        this.parent = parent;
        this.elements = new LinkedHashSet<ADElement>();
    }

    public MergedADElement getParent() {
        return this.parent;
    }

    public String getId() {
        for (ADElement element : this.elements) {
            if (element.getId() == null) continue;
            return element.getId();
        }
        return null;
    }

    public String getName() {
        for (ADElement element : this.elements) {
            if (element.getName() == null) continue;
            return element.getName();
        }
        return null;
    }

    public String getQualifiedName() {
        for (ADElement element : this.elements) {
            if (element.getQualifiedName() == null) continue;
            return element.getQualifiedName();
        }
        return null;
    }

    public String getDescription() {
        for (ADElement element : this.elements) {
            if (element.getDescription() == null) continue;
            return element.getDescription();
        }
        return null;
    }

    public String getIcon() {
        ADElement obj = this.getImageObject();
        if (obj instanceof ADElement) {
            return obj.getIcon();
        }
        return null;
    }

    public ADElement getImageObject() {
        for (ADElement element : this.elements) {
            if (element.getIcon() == null) continue;
            return element;
        }
        return null;
    }

    public int hashCode() {
        int hash = 0;
        for (ADElement element : this.elements) {
            hash += element.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MergedADElement)) {
            return false;
        }
        MergedADElement other = (MergedADElement)obj;
        if (other.parent != this.parent) {
            return false;
        }
        HashSet<ADElement> copy = new HashSet<ADElement>(this.elements);
        copy.retainAll(other.elements);
        return copy.size() == this.elements.size();
    }

    public String toString() {
        Iterator<ADElement> i = this.elements.iterator();
        if (i.hasNext()) {
            return i.next().toString();
        }
        return super.toString();
    }

    void merge(ADElement element) {
        this.elements.add(element);
    }

    public int getElementsNumber() {
        return this.elements.size();
    }
}

