/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;

public class IdHash {
    private static final int GLOBAL_CONTEXT_SCALING = 3;
    private static final int FUNCTION_PARAMETER_SCALING = 3;
    private static final int PARENT_SCALING = 47;
    private static final int PART_SCALING = 3;
    private static final int SPECIALIZATION_SCALING = 5;

    public static int createChildHash(@Nullable ElementId parentId, @Nullable String name) {
        long hash = 0L;
        if (parentId != null) {
            hash += 47L * IdHash.longValueOf(parentId.hashCode());
        }
        if (name != null) {
            hash += IdHash.longValueOf(name.hashCode());
        }
        return (int)hash;
    }

    public static int createGlobalHash(@Nullable Class<? extends ElementId> globalContext, @Nullable String name) {
        long hash = 0L;
        if (globalContext != null) {
            hash += 3L * IdHash.longValueOf(globalContext.getName().hashCode());
        }
        if (name != null) {
            hash += IdHash.longValueOf(name.hashCode());
        }
        return (int)hash;
    }

    public static int createParametersHash(@NonNull Class<?> globalContext, @NonNull ElementId @NonNull [] typeIds) {
        long hash = 0L;
        ElementId[] elementIdArray = typeIds;
        int n = typeIds.length;
        int n2 = 0;
        while (n2 < n) {
            ElementId typeId = elementIdArray[n2];
            hash = 3L * hash + IdHash.longValueOf(typeId.hashCode());
            ++n2;
        }
        return (int)hash + globalContext.getName().hashCode();
    }

    public static int createSpecialization(ElementId ... elementIds) {
        long hash = 0L;
        int i = 0;
        while (i < elementIds.length) {
            hash = 5L * hash + IdHash.longValueOf(elementIds[i].hashCode());
            ++i;
        }
        return (int)hash;
    }

    public static int createTupleHash(@NonNull String name, @NonNull TuplePartId @NonNull [] orderedParts) {
        int hash = 0;
        TuplePartId[] tuplePartIdArray = orderedParts;
        int n = orderedParts.length;
        int n2 = 0;
        while (n2 < n) {
            TuplePartId partId = tuplePartIdArray[n2];
            hash = 3 * hash + partId.hashCode();
            ++n2;
        }
        return hash += IdHash.createGlobalHash(TupleTypeId.class, name);
    }

    public static long longValueOf(long signedValue) {
        if (signedValue >= 0L) {
            return signedValue;
        }
        return signedValue + 0x100000000L;
    }
}

