/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.http.internal.common.HTTPConnector;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.ExtendedIOAdapter;
import org.eclipse.net4j.util.io.ExtendedIOHandler;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.spi.net4j.InternalChannel;

public class HTTPClientConnector
extends HTTPConnector {
    private String url;
    private HttpClient httpClient;
    private int maxIdleTime = -1;
    private int pollInterval = 5000;
    private long lastRequest = System.currentTimeMillis();
    private boolean requesting;
    private Worker poller = new Worker(){

        protected void work(Worker.WorkContext context) throws Exception {
            boolean moreBuffers = HTTPClientConnector.this.tryOperationsRequest();
            context.nextWork((long)(moreBuffers ? 0 : 1000));
        }
    };

    public ILocationAware.Location getLocation() {
        return ILocationAware.Location.CLIENT;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void multiplexChannel(InternalChannel channel) {
        super.multiplexChannel(channel);
        this.tryOperationsRequest();
    }

    public String toString() {
        if (this.getUserID() == null) {
            return MessageFormat.format("HTTPClientConnector[{0}]", this.getURL());
        }
        return MessageFormat.format("HTTPClientConnector[{1}@{0}]", this.getURL(), this.getUserID());
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkArg(this.url, "url == null");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.poller.setDaemon(true);
        this.poller.activate();
        this.httpClient = this.createHTTPClient();
        this.doConnect();
    }

    protected void doDeactivate() throws Exception {
        this.doDisconnect();
        LifecycleUtil.deactivate((Object)this.poller, (OMLogger.Level)OMLogger.Level.WARN);
        this.httpClient = null;
        super.doDeactivate();
    }

    protected HttpClient createHTTPClient() {
        return new HttpClient();
    }

    protected PostMethod createHTTPMethod(String url) {
        return new PostMethod(url);
    }

    private void doConnect() throws IOException {
        this.request(new ExtendedIOHandler(){

            public void handleOut(ExtendedDataOutputStream out) throws IOException {
                out.writeByte(1);
                out.writeString(HTTPClientConnector.this.getUserID());
            }

            public void handleIn(ExtendedDataInputStream in) throws IOException {
                String connectorID = in.readString();
                HTTPClientConnector.this.maxIdleTime = in.readInt();
                HTTPClientConnector.this.setConnectorID(connectorID);
                HTTPClientConnector.this.leaveConnecting();
            }
        });
    }

    private void doDisconnect() throws IOException {
        this.request((ExtendedIOHandler)new ExtendedIOAdapter(){

            public void handleOut(ExtendedDataOutputStream out) throws IOException {
                out.writeByte(2);
                out.writeString(HTTPClientConnector.this.getConnectorID());
            }
        });
    }

    private void request(ExtendedIOHandler handler) throws IOException, HttpException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExtendedDataOutputStream out = new ExtendedDataOutputStream((OutputStream)baos);
        handler.handleOut(out);
        out.flush();
        PostMethod method = this.createHTTPMethod(this.url);
        method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(baos.toByteArray()));
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            InputStream bodyInputStream = method.getResponseBodyAsStream();
            ExtendedDataInputStream in = new ExtendedDataInputStream(bodyInputStream);
            handler.handleIn(in);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryOperationsRequest() {
        Worker worker;
        boolean bl;
        Worker worker2 = this.poller;
        synchronized (worker2) {
            block16: {
                block15: {
                    if (!this.requesting) break block15;
                    return false;
                }
                if (!this.getOutputQueue().isEmpty() || System.currentTimeMillis() - this.lastRequest >= (long)this.pollInterval) break block16;
                return false;
            }
            this.requesting = true;
        }
        try {
            final boolean[] moreOperations = new boolean[1];
            this.request(new ExtendedIOHandler(){

                public void handleOut(ExtendedDataOutputStream out) throws IOException {
                    out.writeByte(3);
                    out.writeString(HTTPClientConnector.this.getConnectorID());
                    moreOperations[0] = HTTPClientConnector.this.writeOutputOperations(out);
                }

                public void handleIn(ExtendedDataInputStream in) throws IOException {
                    HTTPClientConnector.this.readInputOperations(in);
                }
            });
            this.lastRequest = System.currentTimeMillis();
            bl = moreOperations[0];
            worker = this.poller;
        }
        catch (IOException ex) {
            try {
                throw new IORuntimeException((Throwable)ex);
            }
            catch (Throwable throwable) {
                Worker worker3 = this.poller;
                synchronized (worker3) {
                    this.requesting = false;
                }
                throw throwable;
            }
        }
        synchronized (worker) {
            this.requesting = false;
        }
        return bl;
    }
}

