/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.hprof.GZIPInputStream2;
import org.eclipse.mat.hprof.HprofPlugin;
import org.eclipse.mat.util.MessageUtil;

public class SeekableStream
extends InputStream
implements Closeable,
AutoCloseable {
    Supplier<InputStream> genstream;
    long nextseq = 0L;
    int cleanup;
    TreeSet<PosStream> ts = new TreeSet();
    PosStream current;
    int cachesize;
    long estlen;
    long lastpos;
    RandomAccessInputStream underlying;
    SeekableByteChannel underlyingChannel;
    private final boolean verbose = Platform.inDebugMode() && HprofPlugin.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mat.hprof/debug/gzip"));

    public SeekableStream(Supplier<InputStream> genstream, RandomAccessInputStream underlying, int cachesize, long estlen) throws IOException {
        this.genstream = genstream;
        this.cachesize = cachesize;
        this.estlen = estlen;
        this.underlying = underlying;
        this.cleanup = this.initcleanup();
        this.seek(0L);
    }

    private int initcleanup() {
        return (int)Math.pow(this.cachesize + 1, 0.75);
    }

    public SeekableStream(Supplier<InputStream> genstream, SeekableByteChannel underlying, int cachesize, long estlen) throws IOException {
        this.genstream = genstream;
        this.cachesize = cachesize;
        this.estlen = estlen;
        this.underlyingChannel = underlying;
        this.cleanup = this.initcleanup();
        this.seek(0L);
    }

    public SeekableStream(Supplier<InputStream> genstream, int cachesize) throws IOException {
        this.genstream = genstream;
        this.cachesize = cachesize;
        this.cleanup = this.initcleanup();
        this.seek(0L);
    }

    long underlyingPosition() throws IOException {
        if (this.underlying != null) {
            return this.underlying.position();
        }
        if (this.underlyingChannel != null) {
            return this.underlyingChannel.position();
        }
        return -1L;
    }

    void underlyingPosition(long pos) throws IOException {
        if (this.underlying != null) {
            this.underlying.seek(pos);
        } else if (this.underlyingChannel != null) {
            this.underlyingChannel.position(pos);
        }
    }

    boolean underlyingClose() throws IOException {
        if (this.underlying != null) {
            this.underlying.close();
            return true;
        }
        if (this.underlyingChannel != null) {
            this.underlyingChannel.close();
            return true;
        }
        return false;
    }

    void streamClose(PosStream pos) throws IOException {
        pos.close();
    }

    boolean underlying() {
        if (this.underlying != null) {
            return true;
        }
        return this.underlyingChannel != null;
    }

    void clearEntry() throws IOException {
        if (this.ts.isEmpty()) {
            return;
        }
        if (this.nextseq % (long)this.cleanup == 0L) {
            this.clearClosest();
            return;
        }
        PosStream last = this.ts.last();
        if (last != null) {
            PosStream first = this.ts.first();
            PosStream toremove = last;
            PosStream lastbutone = this.ts.lower(last);
            if (lastbutone != null && first.position() < last.position() - lastbutone.position()) {
                toremove = first;
            }
            this.ts.remove(toremove);
            this.streamClose(toremove);
        }
    }

    void clearClosest() throws IOException {
        if (this.ts.size() == 0) {
            return;
        }
        long pos = 0L;
        PosStream best = null;
        long bestgap = Long.MAX_VALUE;
        Iterator<PosStream> ip = this.ts.iterator();
        while (ip.hasNext()) {
            PosStream p = ip.next();
            if (p.isCleared()) {
                ip.remove();
                continue;
            }
            if (p.position() - pos < bestgap) {
                best = p;
                bestgap = p.position() - pos;
            }
            pos = p.position();
        }
        if (best != null) {
            this.ts.remove(best);
            this.streamClose(best);
        }
    }

    public void seek(long pos) throws IOException {
        long toSkip;
        PosStream found;
        long then = System.currentTimeMillis();
        if (this.current != null) {
            this.current.basepos = this.underlyingPosition();
            this.current.setActive(false);
            this.ts.add(this.current);
        }
        PosStream dummy = new PosStream(pos, this.nextseq);
        while ((found = this.ts.floor(dummy)) != null && !found.setActive(true) && this.ts.remove(found)) {
        }
        if (found != null) {
            PosStream copy = found.copy(this.nextseq);
            if (copy != null) {
                ++this.nextseq;
                this.ts.remove(found);
                copy.setActive(false);
                this.ts.add(copy);
                if (this.ts.size() > this.cachesize) {
                    this.clearEntry();
                }
            } else {
                this.ts.remove(found);
            }
            this.underlyingPosition(found.basepos);
        } else {
            if (this.ts.size() > this.cachesize) {
                this.clearEntry();
            }
            this.underlyingPosition(0L);
            try {
                found = new PosStream(this.genstream.get(), this.nextseq++);
            }
            catch (UncheckedIOException e) {
                if (this.current != null) {
                    this.ts.remove(this.current);
                    this.underlyingPosition(this.current.basepos);
                    if (!this.current.setActive(true)) {
                        this.current = null;
                    }
                }
                throw e.getCause();
            }
        }
        this.current = found;
        long toSkip1 = toSkip = pos - found.position();
        while (toSkip > 0L) {
            long skipNow = this.ts.size() < this.cachesize ? (this.lastpos > 0L ? Math.min(toSkip, this.lastpos / (long)(this.cachesize - this.ts.size())) : (this.estlen > 0L ? Math.min(toSkip, this.estlen / (long)(this.cachesize - this.ts.size())) : Math.min(toSkip, 0x40000000L))) : toSkip;
            long skipped = this.skip(skipNow);
            if (skipped == 0L) {
                throw new IOException();
            }
            if ((toSkip -= skipped) <= 0L || this.ts.size() >= this.cachesize) continue;
            this.current.basepos = this.underlyingPosition();
            PosStream extra = this.current.copy(this.nextseq);
            if (extra == null) continue;
            ++this.nextseq;
            extra.setActive(false);
            this.ts.add(extra);
        }
        long now = System.currentTimeMillis();
        if (this.verbose && now - then > 1000L) {
            System.out.println(MessageUtil.format((String)"Slow gzip seek to offset {0} by {1} cache size {2} took {3}ms", (Object[])new Object[]{pos, toSkip1, this.ts.size(), now - then}));
        }
    }

    public long position() {
        return this.current != null ? this.current.pos : this.lastpos;
    }

    @Override
    public int read() throws IOException {
        if (this.current == null) {
            return -1;
        }
        int r = this.current.read();
        if (r < 0) {
            this.lastpos = this.current.position();
            this.streamClose(this.current);
            this.current = null;
        }
        return r;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.current == null) {
            return -1;
        }
        int r = this.current.read(buffer, offset, length);
        if (r < 0) {
            this.lastpos = this.current.position();
            this.streamClose(this.current);
            this.current = null;
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        Iterator<PosStream> it = this.ts.iterator();
        while (it.hasNext()) {
            PosStream ps = it.next();
            this.streamClose(ps);
            it.remove();
        }
        if (this.current != null) {
            this.lastpos = this.current.position();
            this.streamClose(this.current);
        }
        this.current = null;
    }

    public String toString() {
        long pos = this.current != null ? this.current.position() : this.lastpos;
        return String.valueOf(this.getClass().getName()) + " " + pos + " " + this.ts;
    }

    static class PosStream
    extends FilterInputStream
    implements Comparable<PosStream> {
        private long pos;
        long seq;
        long basepos;
        boolean eof;
        SoftReference<InputStream> savedStream;

        protected PosStream(InputStream in, long seq1) {
            super(in);
            this.seq = seq1;
            this.savedStream = new SoftReference<InputStream>(in);
        }

        protected PosStream(long pos, long seq1) {
            super(null);
            this.pos = pos;
            this.seq = seq1;
        }

        protected PosStream copy(long seq) throws IOException {
            if (this.in instanceof GZIPInputStream2) {
                PosStream ret = new PosStream(new GZIPInputStream2((GZIPInputStream2)this.in), seq);
                ret.basepos = this.basepos;
                ret.pos = this.pos;
                return ret;
            }
            return null;
        }

        @Override
        public int read() throws IOException {
            int r = super.read();
            if (r != -1) {
                ++this.pos;
            } else {
                this.eof = true;
            }
            return r;
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            int r = super.read(buf, off, len);
            if (r != -1) {
                this.pos += (long)r;
            } else {
                this.eof = true;
            }
            return r;
        }

        @Override
        public int compareTo(PosStream o) {
            if (this.pos < o.pos) {
                return -1;
            }
            if (this.pos > o.pos) {
                return 1;
            }
            return Long.compare(this.seq, o.seq);
        }

        public boolean equals(Object o) {
            return o instanceof PosStream && this.compareTo((PosStream)o) == 0;
        }

        public int hashCode() {
            return (int)this.pos ^ (int)this.seq;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " " + this.pos + " (" + this.seq + ")" + (this.eof ? "EOF" : "");
        }

        long position() {
            return this.pos;
        }

        void position(long pos) {
            this.pos = pos;
        }

        boolean setActive(boolean state) {
            if (state) {
                this.in = this.savedStream.get();
                return this.in != null;
            }
            return true;
        }

        boolean isCleared() {
            return this.savedStream.get() == null;
        }

        @Override
        public void close() throws IOException {
            if (this.setActive(true)) {
                super.close();
            }
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    public static abstract class RandomAccessInputStream
    extends FilterInputStream {
        protected RandomAccessInputStream(InputStream in) {
            super(in);
        }

        abstract long position() throws IOException;

        abstract void seek(long var1) throws IOException;
    }

    public static class UnclosableInputStream
    extends FilterInputStream {
        public UnclosableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

