/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.util;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MModelURIMapPackage;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MappingContainer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.URIMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriMappingAwareResourceSet
implements ResourceSet {
    private final ResourceSet myDelegate;
    private MappingContainer myUriMap;

    public UriMappingAwareResourceSet(ResourceSet delegate, IFile myTransfFile) throws IOException {
        this.myDelegate = delegate;
        IProject project = myTransfFile.getProject();
        this.myUriMap = UriMappingAwareResourceSet.loadMappings(project);
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        if (EmfUtil.isUriMapped((ResourceSet)this.myDelegate, (URI)uri)) {
            return this.myDelegate.getResource(uri, loadOnDemand);
        }
        if (uri != null && this.myUriMap != null) {
            for (URIMapping uriMapping : this.myUriMap.getMapping()) {
                URI mappedUri;
                if (uriMapping.getSourceURI() == null || !uri.equals(mappedUri = URI.createURI((String)uriMapping.getSourceURI())) || uriMapping.getTargetURI() == null) continue;
                URI targetUri = URI.createURI((String)uriMapping.getTargetURI());
                return this.myDelegate.getResource(targetUri, loadOnDemand);
            }
        }
        return this.myDelegate.getResource(uri, loadOnDemand);
    }

    private static MappingContainer loadMappings(IProject project) throws IOException {
        MModelURIMapPackage.eINSTANCE.getNsURI();
        Resource res = MetamodelURIMappingHelper.createMappingResource((IProject)project);
        if (MetamodelURIMappingHelper.hasMappingResource((IProject)project)) {
            res.load(null);
        }
        return res.getContents().isEmpty() ? null : MetamodelURIMappingHelper.getMappings((Resource)res);
    }

    public Resource createResource(URI uri, String contentType) {
        return this.myDelegate.createResource(uri, contentType);
    }

    public Resource createResource(URI uri) {
        return this.myDelegate.createResource(uri);
    }

    public EList<Adapter> eAdapters() {
        return this.myDelegate.eAdapters();
    }

    public boolean eDeliver() {
        return this.myDelegate.eDeliver();
    }

    public void eNotify(Notification notification) {
        this.myDelegate.eNotify(notification);
    }

    public void eSetDeliver(boolean deliver) {
        this.myDelegate.eSetDeliver(deliver);
    }

    public EList<AdapterFactory> getAdapterFactories() {
        return this.myDelegate.getAdapterFactories();
    }

    public TreeIterator<Notifier> getAllContents() {
        return this.myDelegate.getAllContents();
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        return this.myDelegate.getEObject(uri, loadOnDemand);
    }

    public Map<Object, Object> getLoadOptions() {
        return this.myDelegate.getLoadOptions();
    }

    public EPackage.Registry getPackageRegistry() {
        return this.myDelegate.getPackageRegistry();
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        return this.myDelegate.getResourceFactoryRegistry();
    }

    public EList<Resource> getResources() {
        return this.myDelegate.getResources();
    }

    public URIConverter getURIConverter() {
        return this.myDelegate.getURIConverter();
    }

    public void setPackageRegistry(EPackage.Registry packageRegistry) {
        this.myDelegate.setPackageRegistry(packageRegistry);
    }

    public void setResourceFactoryRegistry(Resource.Factory.Registry resourceFactoryRegistry) {
        this.myDelegate.setResourceFactoryRegistry(resourceFactoryRegistry);
    }

    public void setURIConverter(URIConverter converter) {
        this.myDelegate.setURIConverter(converter);
    }
}

