/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.m2e.editor.pom.PomTemplate;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;

public class PomTemplateProposal
extends TemplateProposal
implements IRelevanceCompletionProposal {
    public PomTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.getReplaceOffset();
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                if (!content.isEmpty() && content.charAt(0) == '<') {
                    content = content.substring(1);
                }
                return this.getMatchValue().toLowerCase().startsWith(content.toLowerCase());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        super.apply(viewer, trigger, stateMask, offset);
        if (this.retriggerOnApply()) {
            Display.getDefault().asyncExec(() -> ((ITextOperationTarget)viewer).doOperation(13));
        }
    }

    private boolean retriggerOnApply() {
        if (this.getTemplate() instanceof PomTemplate) {
            return ((PomTemplate)this.getTemplate()).isRetriggerOnApply();
        }
        return false;
    }

    private String getMatchValue() {
        String matchValue = null;
        if (this.getTemplate() instanceof PomTemplate) {
            matchValue = ((PomTemplate)this.getTemplate()).getMatchValue();
        }
        if (matchValue == null) {
            return this.getTemplate().getName();
        }
        return matchValue;
    }
}

