/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.components;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.maven.model.Model;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.util.ParentGatherer;
import org.eclipse.m2e.core.ui.internal.util.ParentHierarchyEntry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomHierarchyComposite
extends Composite
implements IInputSelectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PomHierarchyComposite.class);
    private TreeViewer pomsViewer;
    private List<ParentHierarchyEntry> hierarchy;

    public PomHierarchyComposite(Composite parent, int style) {
        super(parent, style);
        this.build();
    }

    private void build() {
        this.setLayout((Layout)new FillLayout(256));
        this.pomsViewer = new TreeViewer((Composite)this, 0);
        this.pomsViewer.setLabelProvider((IBaseLabelProvider)new DepLabelProvider());
        this.pomsViewer.setContentProvider((IContentProvider)new PomHeirarchyContentProvider());
    }

    public void setEnabled(boolean bool) {
        this.pomsViewer.getTree().setEnabled(bool);
        super.setEnabled(bool);
    }

    public void computeHeirarchy(IMavenProjectFacade project, IRunnableContext context) {
        try {
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            context.run(false, true, monitor -> {
                try {
                    this.computeHeirarchy(project, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (Exception e) {
            LOG.error("An error occurred building pom heirarchy", (Throwable)e);
        }
    }

    void computeHeirarchy(IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        LinkedList<ParentHierarchyEntry> hierarchy = new LinkedList<ParentHierarchyEntry>();
        hierarchy.addAll(new ParentGatherer(projectFacade).getParentHierarchy(monitor));
        this.setHierarchy(hierarchy);
    }

    public void setHierarchy(List<ParentHierarchyEntry> hierarchy) {
        this.hierarchy = hierarchy;
        this.pomsViewer.setInput(hierarchy);
        this.pomsViewer.expandAll();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.pomsViewer.addSelectionChangedListener(listener);
    }

    public Object getInput() {
        return this.pomsViewer.getInput();
    }

    public ISelection getSelection() {
        return this.pomsViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.pomsViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.pomsViewer.setSelection(selection);
    }

    public List<ParentHierarchyEntry> getHierarchy() {
        return this.hierarchy;
    }

    public ParentHierarchyEntry fromSelection() {
        Object obj;
        ISelection selection = this.pomsViewer.getSelection();
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof ParentHierarchyEntry) {
            return (ParentHierarchyEntry)obj;
        }
        return null;
    }

    public ParentHierarchyEntry getProject() {
        return this.hierarchy.get(0);
    }

    public static class DepLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public String getText(Object element) {
            ParentHierarchyEntry project = null;
            if (element instanceof ParentHierarchyEntry) {
                project = (ParentHierarchyEntry)element;
            } else if (element instanceof Object[]) {
                project = (ParentHierarchyEntry)((Object[])element)[0];
            } else {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            Model model = project.getProject().getModel();
            buffer.append(model.getGroupId()).append(" : ").append(model.getArtifactId()).append(" : ").append(model.getVersion());
            return buffer.toString();
        }

        public Color getForeground(Object element) {
            ParentHierarchyEntry project;
            if (element instanceof ParentHierarchyEntry && (project = (ParentHierarchyEntry)element).getFacade() == null) {
                return Display.getDefault().getSystemColor(16);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof ParentHierarchyEntry) {
                ParentHierarchyEntry project = (ParentHierarchyEntry)element;
                if (project.getFacade() == null) {
                    return MavenImages.getOverlayImage("jar_obj.gif", "lock_ovr.gif", 2);
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
            return null;
        }
    }

    public static class PomHeirarchyContentProvider
    implements ITreeContentProvider {
        private List<ParentHierarchyEntry> projects;

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this.projects = (List)newInput;
            }
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children.length != 0;
        }

        public Object getParent(Object element) {
            if (element instanceof ParentHierarchyEntry) {
                int i = 1;
                while (i < this.projects.size()) {
                    if (this.projects.get(i) == element) {
                        return this.projects.get(i - 1);
                    }
                    ++i;
                }
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List projects = (List)inputElement;
                if (projects.isEmpty()) {
                    return new Object[0];
                }
                return new Object[]{projects.get(projects.size() - 1)};
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ParentHierarchyEntry) {
                ParentHierarchyEntry parent = (ParentHierarchyEntry)parentElement;
                if (this.projects.size() == 1) {
                    return new Object[0];
                }
                if (this.projects.get(0).equals(parent)) {
                    return new Object[0];
                }
                ListIterator<ParentHierarchyEntry> iter = this.projects.listIterator();
                while (iter.hasNext()) {
                    ParentHierarchyEntry next = iter.next();
                    if (!next.equals(parent)) continue;
                    iter.previous();
                    ParentHierarchyEntry previous = iter.previous();
                    return new Object[]{previous};
                }
            }
            return new Object[0];
        }
    }
}

