/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePullPushPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePushPageModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ImagePushPage
extends ImagePullPushPage<ImagePushPageModel> {
    public ImagePushPage(IDockerImage image, String selectedImageName) {
        super(WizardMessages.getString("ImagePush.name"), WizardMessages.getString("ImagePush.title"), new ImagePushPageModel(image, selectedImageName));
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public String getSelectedImageName() {
        return ((ImagePushPageModel)this.getModel()).getSelectedImageName();
    }

    public IRegistry getSelectedRegistryAccount() {
        return ((ImagePushPageModel)this.getModel()).getSelectedRegistry();
    }

    public boolean isForceTagging() {
        return ((ImagePushPageModel)this.getModel()).isForceTagging();
    }

    public boolean isKeepTaggedImage() {
        return ((ImagePushPageModel)this.getModel()).isKeepTaggedImage();
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)container);
        IObservableValue<IRegistry> registryAccountObservable = super.createRegistrySelectionControls(container);
        IObservableValue<String> imageNameObservable = this.createImageSelectionControls(container);
        Button forceTaggingButton = new Button(container, 32);
        forceTaggingButton.setText(WizardMessages.getString("ImagePushPage.forcetagging.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)forceTaggingButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)forceTaggingButton), BeanProperties.value(ImagePushPageModel.class, (String)"forceTagging").observe((Object)((ImagePushPageModel)this.getModel())));
        Button keepTaggedImageButton = new Button(container, 32);
        keepTaggedImageButton.setText(WizardMessages.getString("ImagePushPage.keeptaggedimage.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)keepTaggedImageButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)keepTaggedImageButton), BeanProperties.value(ImagePushPageModel.class, (String)"keepTaggedImage").observe((Object)((ImagePushPageModel)this.getModel())));
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        ImagePushPageModel imagePushPageModel = (ImagePushPageModel)this.getModel();
        imagePushPageModel.getClass();
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new ImagePushPageModel.ImagePushValidator(imagePushPageModel, imageNameObservable, registryAccountObservable));
        this.setControl((Control)container);
    }

    private IObservableValue<String> createImageSelectionControls(Composite container) {
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(WizardMessages.getString("ImagePullPushPage.name.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)nameLabel);
        Combo imageNameCombo = new Combo(container, 4);
        imageNameCombo.setToolTipText(WizardMessages.getString("ImagePushName.toolTip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)imageNameCombo);
        ComboViewer imageNameComboViewer = new ComboViewer(imageNameCombo);
        imageNameComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        imageNameComboViewer.setInput((Object)((ImagePushPageModel)this.getModel()).getImage().repoTags());
        IObservableValue imageNameObservable = BeanProperties.value(ImagePushPageModel.class, (String)"selectedImageName", String.class).observe((Object)((ImagePushPageModel)this.getModel()));
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)imageNameCombo), imageNameObservable);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)new Label(container, 0));
        return imageNameObservable;
    }
}

