/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.IOSGIFrameworkInstance;
import org.eclipse.libra.framework.core.Messages;
import org.eclipse.libra.framework.core.internal.dependency.DependencyUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.model.ServerDelegate;

public abstract class FrameworkInstanceDelegate
extends ServerDelegate
implements IOSGIFrameworkInstance {
    public static final String DEFAULT_DEPLOYDIR = "auto";
    private FrameworkInstanceConfiguration configuration;

    public IModule[] getChildModules(IModule[] module) {
        if (module == null) {
            return null;
        }
        if ("osgi.bundle".equalsIgnoreCase(module[0].getModuleType().getId())) {
            IPluginModelBase[] plugins;
            IPluginModelBase modelBase = null;
            IPluginModelBase[] iPluginModelBaseArray = plugins = PluginRegistry.getActiveModels();
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase iPluginModelBase = iPluginModelBaseArray[n2];
                if (module[0].getName().equalsIgnoreCase(iPluginModelBase.getBundleDescription().getName())) {
                    modelBase = iPluginModelBase;
                    break;
                }
                ++n2;
            }
            if (modelBase != null) {
                Object[] dependents = DependencyUtil.getDependencies(modelBase.getBundleDescription());
                ArrayList<IModule> modules = new ArrayList<IModule>();
                Object[] objectArray = dependents;
                int n3 = dependents.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object dep = objectArray[n4];
                    BundleDescription depBundle = (BundleDescription)dep;
                    ModelEntry entry = PluginRegistry.findEntry((String)depBundle.getSymbolicName());
                    if (entry.hasWorkspaceModels()) {
                        IModule[] iModules;
                        IPluginModelBase base = entry.getModel();
                        IModule[] iModuleArray = iModules = ((Module)module[0]).getModuleFactory().getModules(base.getUnderlyingResource().getProject(), (IProgressMonitor)new NullProgressMonitor());
                        int n5 = iModules.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IModule iModule = iModuleArray[n6];
                            modules.add(iModule);
                            ++n6;
                        }
                    }
                    ++n4;
                }
                IModule[] moduleArr = new IModule[modules.size()];
                modules.toArray(moduleArr);
                return moduleArr;
            }
        }
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        if (module == null) {
            return null;
        }
        if ("osgi.bundle".equalsIgnoreCase(module.getModuleType().getId())) {
            IPluginModelBase[] plugins;
            IPluginModelBase modelBase = null;
            IPluginModelBase[] iPluginModelBaseArray = plugins = PluginRegistry.getActiveModels();
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase iPluginModelBase = iPluginModelBaseArray[n2];
                if (module.getName().equalsIgnoreCase(iPluginModelBase.getBundleDescription().getName())) {
                    modelBase = iPluginModelBase;
                    break;
                }
                ++n2;
            }
        }
        return new IModule[]{module};
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IModule module = add[i];
                if (!"osgi.bundle".equals(module.getModuleType().getId())) {
                    return new Status(4, "org.eclipse.libra.framework.core", 0, Messages.errorOSGiBundlesOnly, null);
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public FrameworkInstanceConfiguration getFrameworkInstanceConfiguration() throws CoreException {
        if (this.configuration == null) {
            IFolder folder = this.getServer().getServerConfiguration();
            if (folder == null || !folder.exists()) {
                String path = null;
                if (folder != null) {
                    path = folder.getFullPath().toOSString();
                    IProject project = folder.getProject();
                    if (project != null && project.exists() && !project.isOpen()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.libra.framework.core", 0, NLS.bind((String)Messages.errorConfigurationProjectClosed, (Object)path, (Object)project.getName()), null));
                    }
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.libra.framework.core", 0, NLS.bind((String)Messages.errorNoConfiguration, (Object)path), null));
            }
            this.configuration = new FrameworkInstanceConfiguration(folder, this);
            try {
                this.configuration.load(folder, null);
            }
            catch (CoreException ce) {
                this.configuration = null;
                throw ce;
            }
        }
        return this.configuration;
    }

    public String getInstanceDirectory() {
        return this.getAttribute("instanceDir", null);
    }

    public String getDeployDirectory() {
        return this.getAttribute("deployDir", "bundles");
    }

    public void setInstanceDirectory(String instanceDir) {
        this.setAttribute("instanceDir", instanceDir);
    }

    public void setDeployDirectory(String deployDir) {
        this.setAttribute("deployDir", deployDir);
    }

    public boolean isDebug() {
        return this.getAttribute("debug", false);
    }

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        this.setDeployDirectory(DEFAULT_DEPLOYDIR);
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        super.importRuntimeConfiguration(runtime, monitor);
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        IStatus status = this.canModifyModules(add, remove);
        if (status == null || !status.isOK()) {
            throw new CoreException(status);
        }
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                ++i;
            }
        }
        if (remove != null) {
            int size2 = remove.length;
            int j = 0;
            while (j < size2) {
                ++j;
            }
        }
    }

    public void setJavaProfile(String profileID) {
        this.setAttribute("JAVA_PROFILE", profileID);
    }

    public String getJavaPofile() {
        return this.getAttribute("JAVA_PROFILE", "JavaSE-1.6");
    }

    public void setJMXPort(int port) {
        this.setAttribute("jmxPort", "" + port);
    }

    public int getJMXPort() {
        int port = 12345;
        String portNo = this.getAttribute("jmxPort", "12345");
        port = Integer.parseInt(portNo);
        return port;
    }

    public void setJMXEnabled(boolean isEnabled) {
        this.setAttribute("jmxEnabled", isEnabled);
    }

    public boolean getJMXEnabled() {
        return this.getAttribute("jmxEnabled", true);
    }

    public abstract ITargetDefinition createDefaultTarget() throws CoreException;
}

