/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.util;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalScreenshotUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LocalScreenshotUtil.class);

    private LocalScreenshotUtil() {
    }

    public static BufferedImage createScreenCapture(Rectangle screenRect) {
        try {
            return new Robot().createScreenCapture(screenRect);
        }
        catch (AWTException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public static BufferedImage createFullScreenCapture() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Rectangle screenRect = new Rectangle(screenSize);
        return LocalScreenshotUtil.createScreenCapture(screenRect);
    }
}

