/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.editor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.ui.CDOContentProvider;
import org.eclipse.emf.cdo.internal.ui.RunnableViewerRefresh;
import org.eclipse.emf.cdo.internal.ui.ViewerUtil;
import org.eclipse.emf.cdo.internal.ui.actions.TransactionalBackgroundAction;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.dialogs.BulkAddDialog;
import org.eclipse.emf.cdo.internal.ui.dialogs.RollbackTransactionDialog;
import org.eclipse.emf.cdo.internal.ui.dialogs.SelectClassDialog;
import org.eclipse.emf.cdo.internal.ui.editor.CDOActionBarContributor;
import org.eclipse.emf.cdo.internal.ui.editor.EditorEditorAdvisor;
import org.eclipse.emf.cdo.internal.ui.editor.PluginDelegator;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOEditorInput2;
import org.eclipse.emf.cdo.ui.CDOEditorInput3;
import org.eclipse.emf.cdo.ui.CDOEventHandler;
import org.eclipse.emf.cdo.ui.CDOInvalidRootAgent;
import org.eclipse.emf.cdo.ui.CDOLabelProvider;
import org.eclipse.emf.cdo.ui.CDOTreeExpansionAgent;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.ValidationException;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IInputProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;

public class CDOEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider {
    public static final List<String> FILE_EXTENSION_FILTERS = CDOEditor.prefixExtensions(Arrays.asList(PluginDelegator.INSTANCE.getString("_UI_CDOEditorFilenameExtensions").split("\\s*,\\s*")), "*.");
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOEditor.class);
    private static final Image ERROR_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    private static final Field PROPERTY_SHEET_PAGE_VIEWER_FIELD = CDOEditor.getPropertySheetPageViewerField();
    private static final Field CONTENT_OUTLINE_PAGE_VIEWER_FIELD = CDOEditor.getContentOutlinePageViewerField();
    private static final boolean SHOW_BULK_ADD_ACTION = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.ui.editor.SHOW_BULK_ADD_ACTION");
    protected CDOView view;
    protected Object viewerInput;
    protected CDOInvalidRootAgent invalidRootAgent;
    protected CDOTreeExpansionAgent treeExpansionAgent;
    protected CDOEventHandler eventHandler;
    protected CDOObjectHandler objectHandler = new CDOObjectHandler(){

        public void objectStateChanged(CDOView view, CDOObject object, CDOState oldState, CDOState newState) {
            if (object == CDOEditor.this.viewerInput && newState == CDOState.INVALID) {
                CDOEditor.this.closeEditor();
            }
        }
    };
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == CDOEditor.this.contentOutlinePage) {
                    CDOEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)CDOEditor.this);
                    CDOEditor.this.setCurrentViewer((Viewer)CDOEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (CDOEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    CDOEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)CDOEditor.this);
                    CDOEditor.this.handleActivate();
                }
            } else if (p == CDOEditor.this && CDOEditor.this.pagesCreated.get()) {
                CDOEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = CDOEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            CDOEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            CDOEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!CDOEditor.this.updateProblemIndication) return;
                        CDOEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CDOEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            CDOEditor.this.resourceToDiagnosticMap.remove(target);
            if (CDOEditor.this.updateProblemIndication) {
                CDOEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CDOEditor.this.updateProblemIndication();
                    }
                });
            }
        }
    };
    protected final AtomicBoolean pagesCreated = new AtomicBoolean();

    private static List<String> prefixExtensions(List<String> extensions, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String extension : extensions) {
            result.add(String.valueOf(prefix) + extension);
        }
        return Collections.unmodifiableList(result);
    }

    protected void handleActivateGen() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleActivate() {
        this.handleActivateGen();
        this.setCurrentViewer((Viewer)this.selectionViewer);
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.cdo.ui", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    PluginDelegator.INSTANCE.log((Object)exception);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)CDOEditor.getString("_UI_FileConflict_label"), (String)CDOEditor.getString("_WARN_FileConflict"));
    }

    public CDOEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomainGen() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                CDOEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CDOEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            CDOEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator<PropertySheetPage> i = (this).CDOEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = i.next();
                            if (propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = CDOEditor.createAdapterFactory(true);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (CDOEditor.this.currentViewer != null) {
                        CDOEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        CDOEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public CDOView getView() {
        return this.view;
    }

    @Deprecated
    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    protected AdapterFactoryEditingDomain createEditingDomain(BasicCommandStack commandStack, ResourceSet resourceSet) {
        return new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, resourceSet);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.cdo.ui", 0, CDOEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.emf.cdo.ui", 0, CDOEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    @Deprecated
    public void createPagesGen() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, CDOEditor.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CDOEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    CDOEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CDOEditor.this.updateProblemIndication();
            }
        });
    }

    public void createPages() {
        final CDOEditorInput editorInput = (CDOEditorInput)this.getEditorInput();
        CDOView view = editorInput.getView();
        final String resourcePath = editorInput.getResourcePath();
        final IEditingDomainProvider domainProvider = (IEditingDomainProvider)AdapterUtil.adapt((Object)editorInput, IEditingDomainProvider.class);
        if (view != null) {
            CDOID objectID = editorInput instanceof CDOEditorInput2 ? ((CDOEditorInput2)editorInput).getObjectID() : null;
            this.createPages(view, resourcePath, objectID, domainProvider);
        } else if (editorInput instanceof CDOEditorInput3) {
            final Display display = this.getSite().getShell().getDisplay();
            final Label progressLabel = new Label(this.getContainer(), 0);
            progressLabel.setBackground(display.getSystemColor(25));
            progressLabel.setText("Operation in progress...");
            this.addPage(0, (Control)progressLabel);
            this.setActivePage(0);
            this.hideTabs();
            new Job("Open view"){

                protected IStatus run(IProgressMonitor monitor) {
                    ProgressMonitorWrapper monitorWrapper = new ProgressMonitorWrapper(monitor){

                        public void beginTask(String name, int totalWork) {
                            display.asyncExec(() -> progressLabel.setText(name));
                            super.beginTask(name, totalWork);
                        }

                        public void setTaskName(String name) {
                            display.asyncExec(() -> progressLabel.setText(name));
                            super.setTaskName(name);
                        }
                    };
                    try {
                        CDOView view = ((CDOEditorInput3)editorInput).openView((IProgressMonitor)monitorWrapper);
                        if (view != null) {
                            display.asyncExec(() -> {
                                try {
                                    CDOEditor.this.removePage(0);
                                    CDOEditor.this.showTabs();
                                    CDOID objectID = editorInput instanceof CDOEditorInput2 ? ((CDOEditorInput2)editorInput).getObjectID() : null;
                                    CDOEditor.this.createPages(view, resourcePath, objectID, domainProvider);
                                    CDOEditor.this.handleActivate();
                                    CDOActionBarContributor actionBarContributor = (CDOActionBarContributor)CDOEditor.this.getActionBarContributor();
                                    actionBarContributor.activate();
                                    CDOEditor.this.firePropertyChange(258);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                    catch (Throwable ex) {
                        return OM.BUNDLE.getStatus((Object)ex);
                    }
                }
            }.schedule();
        }
    }

    protected void createPages(final CDOView view, String resourcePath, CDOID objectID, IEditingDomainProvider domainProvider) {
        try {
            BasicCommandStack commandStack;
            this.view = view;
            ResourceSet resourceSet = view.getResourceSet();
            resourceSet.eAdapters().add((Object)new EditingDomainProviderAdapter());
            this.invalidRootAgent = new CDOInvalidRootAgent(view){

                @Override
                protected Object getRootFromUI() {
                    if (CDOEditor.this.selectionViewer != null) {
                        return CDOEditor.this.selectionViewer.getInput();
                    }
                    return null;
                }

                @Override
                protected void setRootToUI(Object root) {
                    if (CDOEditor.this.selectionViewer != null) {
                        CDOEditor.this.selectionViewer.setInput(root);
                    }
                }

                @Override
                protected void closeUI() {
                    CDOEditor.this.closeEditor();
                }
            };
            if (domainProvider != null && domainProvider.getEditingDomain() instanceof AdapterFactoryEditingDomain) {
                this.editingDomain = (AdapterFactoryEditingDomain)domainProvider.getEditingDomain();
                commandStack = this.editingDomain.getCommandStack();
                if (this.editingDomain.getAdapterFactory() instanceof ComposedAdapterFactory) {
                    this.adapterFactory = (ComposedAdapterFactory)this.editingDomain.getAdapterFactory();
                } else {
                    this.adapterFactory.addAdapterFactory(this.editingDomain.getAdapterFactory());
                }
            } else {
                commandStack = new BasicCommandStack();
                this.editingDomain = this.createEditingDomain(commandStack, resourceSet);
            }
            commandStack.addCommandStackListener(new CommandStackListener(){

                public void commandStackChanged(final EventObject event) {
                    Composite container = CDOEditor.this.getContainer();
                    if (!container.isDisposed()) {
                        container.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CDOEditor.this.firePropertyChange(257);
                                Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                                if (mostRecentCommand != null) {
                                    CDOEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                                }
                                Iterator<PropertySheetPage> i = (this).CDOEditor.this.propertySheetPages.iterator();
                                while (i.hasNext()) {
                                    PropertySheetPage propertySheetPage = i.next();
                                    if (propertySheetPage.getControl().isDisposed()) {
                                        i.remove();
                                        continue;
                                    }
                                    propertySheetPage.refresh();
                                }
                            }
                        });
                    }
                }
            });
            if (resourcePath == null) {
                this.viewerInput = resourceSet;
            } else {
                if (CDOIDUtil.isNull((CDOID)objectID)) {
                    URI resourceURI = CDOURIUtil.createResourceURI((CDOView)view, (String)resourcePath);
                    this.viewerInput = resourceSet.getResource(resourceURI, true);
                } else {
                    InternalCDOObject inputObject = (InternalCDOObject)view.getObject(objectID);
                    this.viewerInput = inputObject.cdoInternalInstance();
                }
                if (!view.isReadOnly()) {
                    view.addObjectHandler(this.objectHandler);
                }
            }
            this.viewerInput = resourceSet;
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new SafeTreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider(this.createContentProvider());
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
            this.selectionViewer.setInput(this.viewerInput);
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IStructuredContentProvider structuredContentProvider;
                        Object[] elements;
                        IContentProvider contentProvider = CDOEditor.this.selectionViewer.getContentProvider();
                        if (contentProvider instanceof IStructuredContentProvider && (elements = (structuredContentProvider = (IStructuredContentProvider)contentProvider).getElements(CDOEditor.this.viewerInput)) != null && elements.length != 0) {
                            CDOEditor.this.setSelectionToViewer(Collections.singleton(elements[0]));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, CDOEditor.getString("_UI_SelectionPage_label"));
            this.setActivePage(0);
            this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
                boolean guard = false;

                public void controlResized(ControlEvent event) {
                    if (!this.guard) {
                        this.guard = true;
                        CDOEditor.this.hideTabs();
                        this.guard = false;
                    }
                }
            });
            this.updateProblemIndication();
            this.eventHandler = new CDOEventHandler(view, this.selectionViewer){

                @Override
                protected void objectInvalidated(InternalCDOObject cdoObject) {
                    if (CDOUtil.isLegacyObject((EObject)cdoObject)) {
                        CDOStateMachine.INSTANCE.read(cdoObject);
                    }
                    block2: for (PropertySheetPage propertySheetPage : CDOEditor.this.propertySheetPages) {
                        IInputProvider inputProvider;
                        Object input;
                        Object object;
                        List<Object> objects;
                        block7: {
                            objects = null;
                            try {
                                if (propertySheetPage instanceof ExtendedPropertySheetPage) {
                                    ExtendedPropertySheetPage extendedPropertySheetPage = (ExtendedPropertySheetPage)propertySheetPage;
                                    objects = extendedPropertySheetPage.getInput();
                                }
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                if (PROPERTY_SHEET_PAGE_VIEWER_FIELD != null) break block7;
                                throw noSuchMethodError;
                            }
                        }
                        if (objects == null && (object = ReflectUtil.getValue((Field)PROPERTY_SHEET_PAGE_VIEWER_FIELD, (Object)propertySheetPage)) instanceof IInputProvider && (input = (inputProvider = (IInputProvider)object).getInput()) instanceof Object[]) {
                            objects = Arrays.asList((Object[])input);
                        }
                        if (objects == null) continue;
                        for (Object e : objects) {
                            if (e != cdoObject) continue;
                            propertySheetPage.refresh();
                            continue block2;
                        }
                    }
                }

                @Override
                protected void viewConflict(CDOObject conflictingObject, boolean firstConflict) {
                    CDOEditor.this.refreshViewer(conflictingObject);
                }

                @Override
                protected void viewClosed() {
                    CDOEditor.this.closeEditor();
                }

                @Override
                protected void viewDirtyStateChanged() {
                    CDOResource resource;
                    if (CDOEditor.this.viewerInput instanceof CDOResource && !view.isObjectRegistered((resource = (CDOResource)CDOEditor.this.viewerInput).cdoID())) {
                        CDOEditor.this.closeEditor();
                        return;
                    }
                    CDOEditor.this.fireDirtyPropertyChange();
                }
            };
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            throw ex;
        }
        if (view.isReadOnly()) {
            this.treeExpansionAgent = new CDOTreeExpansionAgent(view, this.selectionViewer);
        }
        this.getViewer().getControl().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                try {
                    CDOEditor.this.getSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.pagesCreated.set(true);
    }

    protected IContentProvider createContentProvider() {
        class DelegateContentProvider
        extends AdapterFactoryContentProvider {
            public DelegateContentProvider(AdapterFactory adapterFactory) {
                super(adapterFactory);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                super.inputChanged(viewer, oldInput, newInput);
                this.viewerRefresh = viewer != null ? new RunnableViewerRefresh(viewer) : null;
            }

            public RunnableViewerRefresh getViewerRefresh() {
                return (RunnableViewerRefresh)this.viewerRefresh;
            }

            public boolean hasChildren(Object object) {
                try {
                    return super.hasChildren(object);
                }
                catch (Exception ex) {
                    if (TRACER.isEnabled()) {
                        TRACER.trace((Throwable)ex);
                    }
                    return false;
                }
            }
        }
        final DelegateContentProvider delegate = new DelegateContentProvider((AdapterFactory)this.adapterFactory);
        return new CDOContentProvider<CDOView>(){
            {
            }

            @Override
            public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
                super.inputChanged(newViewer, oldInput, newInput);
                delegate.inputChanged(newViewer, oldInput, newInput);
            }

            @Override
            protected Object adapt(Object target, Object type) {
                return CDOEditor.this.adapterFactory.adapt(target, type);
            }

            @Override
            protected Object[] modifyChildren(Object parent, Object[] children) {
                return children;
            }

            @Override
            protected ITreeContentProvider getContentProvider(Object object) {
                return delegate;
            }

            @Override
            protected RunnableViewerRefresh getViewerRefresh() {
                return delegate.getViewerRefresh();
            }

            @Override
            protected boolean isContext(Object object) {
                return false;
            }

            @Override
            protected CDOContentProvider.ContextState getContextState(CDOView view) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void openContext(CDOView view) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void closeContext(CDOView view) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected Object getRootObject(CDOView view) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected ILabelProvider createLabelProvider() {
        return new DecoratingLabelProvider((ILabelProvider)new CDOLabelProvider((AdapterFactory)this.adapterFactory, this.view, this.selectionViewer), this.createLabelDecorator()){

            public Image getImage(Object element) {
                block4: {
                    try {
                        if (element instanceof ViewerUtil.Pending) {
                            return ContainerItemProvider.PENDING_IMAGE;
                        }
                        Image image = super.getImage(element);
                        if (image != null) {
                            return image;
                        }
                    }
                    catch (Exception ex) {
                        if (!TRACER.isEnabled()) break block4;
                        TRACER.trace((Throwable)ex);
                    }
                }
                return ERROR_IMAGE;
            }

            public String getText(Object element) {
                block7: {
                    try {
                        if (element instanceof ViewerUtil.Pending) {
                            ViewerUtil.Pending pending = (ViewerUtil.Pending)element;
                            return pending.getText();
                        }
                        String text = super.getText(element);
                        if (!StringUtil.isEmpty((String)text)) {
                            return text;
                        }
                    }
                    catch (Exception ex) {
                        if (!TRACER.isEnabled()) break block7;
                        TRACER.trace((Throwable)ex);
                    }
                }
                try {
                    EObject eObject;
                    EClass eClass;
                    String text;
                    if (element instanceof EObject && !StringUtil.isEmpty((String)(text = this.getText(eClass = (eObject = (EObject)element).eClass())))) {
                        return text;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return element.getClass().getSimpleName();
            }
        };
    }

    protected ILabelDecorator createLabelDecorator() {
        return PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() != null && !this.getContainer().isDisposed() && this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, CDOEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() != null && !this.getContainer().isDisposed() && this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public <T> T getAdapter(Class<T> key) {
        if (key.equals(IContentOutlinePage.class)) {
            return (T)(this.showOutlineView() ? this.getContentOutlinePage() : null);
        }
        if (key.equals(IPropertySheetPage.class)) {
            return (T)this.getPropertySheetPage();
        }
        return (T)super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                private CDOInvalidRootAgent invalidRootAgent;

                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    if (CONTENT_OUTLINE_PAGE_VIEWER_FIELD == null) {
                        super.createControl(parent);
                    } else {
                        SafeTreeViewer treeViewer = new SafeTreeViewer(parent, this.getTreeStyle());
                        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                        ReflectUtil.setValue((Field)CONTENT_OUTLINE_PAGE_VIEWER_FIELD, (Object)((Object)this), (Object)((Object)treeViewer));
                    }
                    CDOEditor.this.contentOutlineViewer = this.getTreeViewer();
                    CDOEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    CDOEditor.this.contentOutlineViewer.setContentProvider(CDOEditor.this.createContentProvider());
                    CDOEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)CDOEditor.this.createLabelProvider());
                    try {
                        CDOEditor.this.contentOutlineViewer.setInput(CDOEditor.this.viewerInput);
                    }
                    catch (Exception ex) {
                        CDOEditor.this.contentOutlineViewer.setInput(null);
                    }
                    if (CDOEditor.this.view.isReadOnly()) {
                        this.invalidRootAgent = new CDOInvalidRootAgent(CDOEditor.this.view){

                            @Override
                            protected Object getRootFromUI() {
                                return ((MyContentOutlinePage)this).CDOEditor.this.contentOutlineViewer.getInput();
                            }

                            @Override
                            protected void setRootToUI(Object root) {
                                ((MyContentOutlinePage)this).CDOEditor.this.contentOutlineViewer.setInput(root);
                            }

                            @Override
                            protected void closeUI() {
                                CDOEditor.this.closeEditor();
                            }
                        };
                    }
                    CDOEditor.this.createContextMenuFor((StructuredViewer)CDOEditor.this.contentOutlineViewer);
                    if (!CDOUtil.getResources((ResourceSet)CDOEditor.this.editingDomain.getResourceSet()).isEmpty()) {
                        CDOEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(CDOUtil.getResources((ResourceSet)CDOEditor.this.editingDomain.getResourceSet()).get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    CDOEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    CDOEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }

                public void dispose() {
                    if (this.invalidRootAgent != null) {
                        this.invalidRootAgent.dispose();
                        this.invalidRootAgent = null;
                    }
                    super.dispose();
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CDOEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPageGen() {
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

            public void setSelectionToViewer(List<?> selection) {
                CDOEditor.this.setSelectionToViewer(selection);
                CDOEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                CDOEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){
            {
                this.setSorter(new PropertySheetSorter(){

                    public void sort(IPropertySheetEntry[] entries) {
                    }
                });
            }

            public void setSelectionToViewer(List<?> selection) {
                CDOEditor.this.setSelectionToViewer(selection);
                CDOEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                CDOEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                try {
                    super.selectionChanged(part, selection);
                }
                catch (Exception ex) {
                    if (TRACER.isEnabled()) {
                        TRACER.trace((Throwable)ex);
                    }
                    super.selectionChanged(part, (ISelection)StructuredSelection.EMPTY);
                }
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    public boolean isDirty() {
        if (this.view != null) {
            return this.view.isDirty();
        }
        return false;
    }

    public void doSaveGen(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : CDOEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !CDOEditor.this.isPersisted(resource) || CDOEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            CDOEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        CDOEditor.this.resourceToDiagnosticMap.put(resource, CDOEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            PluginDelegator.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        Display.getCurrent().asyncExec(null);
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                boolean first = true;
                EList resources = CDOUtil.getResources((ResourceSet)CDOEditor.this.editingDomain.getResourceSet());
                try {
                    for (Resource resource : resources) {
                        if (!first && resource.getContents().isEmpty() && !CDOEditor.this.isPersisted(resource) || CDOEditor.this.editingDomain.isReadOnly(resource)) continue;
                        try {
                            CDOView resourceView;
                            CDOEditor.this.savedResources.add(resource);
                            if (resource instanceof CDOResource && ((resourceView = ((CDOResource)resource).cdoView()) == CDOEditor.this.view || resourceView.isReadOnly())) continue;
                            resource.save(saveOptions);
                        }
                        catch (Exception exception) {
                            OM.LOG.error((Throwable)exception);
                            CDOEditor.this.resourceToDiagnosticMap.put(resource, CDOEditor.this.analyzeResourceProblems(resource, exception));
                        }
                        first = false;
                    }
                    if (!CDOEditor.this.view.isReadOnly()) {
                        final CDOTransaction transaction = (CDOTransaction)CDOEditor.this.view;
                        try {
                            transaction.commit(monitor);
                        }
                        catch (Exception exception) {
                            OM.LOG.error((Throwable)exception);
                            Shell shell = CDOEditor.this.getSite().getShell();
                            shell.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    String title = Messages.getString("CDOEditor.17");
                                    String message = exception instanceof ValidationException ? MessageFormat.format(Messages.getString("CDOEditor.19"), exception.getLocalizedMessage()) : Messages.getString("CDOEditor.18");
                                    RollbackTransactionDialog dialog = new RollbackTransactionDialog(CDOEditor.this.getEditorSite().getPage(), title, message, transaction);
                                    if (dialog.open() == 0) {
                                        transaction.rollback();
                                    }
                                }
                            });
                        }
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
        }
        catch (Exception exception) {
            PluginDelegator.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isSaveAsAllowedGen() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        String[] filters = FILE_EXTENSION_FILTERS.toArray(new String[FILE_EXTENSION_FILTERS.size()]);
        String[] files = EditorEditorAdvisor.openFilePathDialog(this.getSite().getShell(), 8192, filters);
        if (files.length > 0) {
            URI uri = URI.createFileURI((String)files[0]);
            this.doSaveAs(uri, (IEditorInput)new URIEditorInput(uri));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        throw new UnsupportedOperationException();
    }

    public void initGen(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        this.setInputWithNotify(editorInput);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            try {
                listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            }
            catch (Exception ex) {
                if (!TRACER.isEnabled()) continue;
                TRACER.trace((Throwable)ex);
            }
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(CDOEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        Object element = collection.iterator().next();
                        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory);
                        String text = null;
                        try {
                            text = adapterFactoryItemDelegator.getText(element);
                        }
                        catch (Exception ex) {
                            if (TRACER.isEnabled()) {
                                TRACER.trace((Throwable)ex);
                            }
                            text = null;
                        }
                        try {
                            if (StringUtil.isEmpty((String)text) && element instanceof EObject) {
                                EObject eObject = (EObject)element;
                                EClass eClass = eObject.eClass();
                                text = adapterFactoryItemDelegator.getText((Object)eClass);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (StringUtil.isEmpty((String)text)) {
                            text = element.getClass().getSimpleName();
                        }
                        statusLineManager.setMessage(CDOEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(CDOEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    public void menuAboutToShowGen(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        Object element;
        IStructuredSelection sel;
        Resource resource;
        this.menuAboutToShowGen(menuManager);
        final IWorkbenchPage page = this.getSite().getPage();
        MenuManager submenuManager = new MenuManager(Messages.getString("CDOEditor.23"));
        NewRootMenuPopulator populator = new NewRootMenuPopulator(this.view.getSession().getPackageRegistry()){

            @Override
            protected IAction createAction(EObject object) {
                return new CreateRootAction(object);
            }
        };
        if (populator.populateMenu((IMenuManager)submenuManager)) {
            menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        }
        if ((resource = this.getSelectedResource()) instanceof CDOResource) {
            final CDOResource parent = (CDOResource)resource;
            String text = String.valueOf(Messages.getString("CDOEditor.29")) + SafeAction.INTERACTIVE;
            submenuManager.add((IContributionItem)new Separator());
            submenuManager.add((IAction)new TransactionalBackgroundAction(page, text, null, null, (CDOObject)parent){
                private EObject newObject;

                protected void preRun() throws Exception {
                    SelectClassDialog dialog = new SelectClassDialog(page, "New Root Object", "Select a package and a class for the new root object.");
                    if (dialog.open() == 0) {
                        EClass eClass = dialog.getSelectedClass();
                        this.newObject = EcoreUtil.create((EClass)eClass);
                    } else {
                        this.cancel();
                    }
                }

                @Override
                protected void doRun(CDOTransaction transaction, CDOObject object, IProgressMonitor progressMonitor) throws Exception {
                    EList contents = parent.getContents();
                    contents.add((Object)this.newObject);
                }
            });
        }
        if ((sel = (IStructuredSelection)this.editorSelection).size() == 1 && (element = sel.getFirstElement()) instanceof EObject) {
            final EObject object = (EObject)element;
            final ArrayList<EReference> features = new ArrayList<EReference>();
            for (EReference containment : object.eClass().getEAllContainments()) {
                if (!containment.isMany()) continue;
                features.add(containment);
            }
            if (SHOW_BULK_ADD_ACTION && !features.isEmpty()) {
                menuManager.insertBefore("edit", (IAction)new LongRunningAction(page, String.valueOf(Messages.getString("CDOEditor.26")) + SafeAction.INTERACTIVE){
                    protected EReference feature;
                    protected int instances;

                    protected void preRun() throws Exception {
                        BulkAddDialog dialog = new BulkAddDialog(page, features);
                        if (dialog.open() == 0) {
                            this.feature = dialog.getFeature();
                            this.instances = dialog.getInstances();
                        } else {
                            this.cancel();
                        }
                    }

                    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
                        ArrayList<EObject> children = new ArrayList<EObject>();
                        int i = 0;
                        while (i < this.instances) {
                            EObject child = EcoreUtil.create((EClass)this.feature.getEReferenceType());
                            children.add(child);
                            ++i;
                        }
                        EList list = (EList)object.eGet((EStructuralFeature)this.feature);
                        list.addAll(children);
                    }
                });
            }
        }
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void disposeGen() {
        this.updateProblemIndication = false;
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void dispose() {
        this.updateProblemIndication = false;
        if (this.treeExpansionAgent != null) {
            this.treeExpansionAgent.dispose();
            this.treeExpansionAgent = null;
        }
        if (this.invalidRootAgent != null) {
            this.invalidRootAgent.dispose();
            this.invalidRootAgent = null;
        }
        if (this.view != null && !this.view.isClosed()) {
            try {
                if (this.objectHandler != null) {
                    this.view.removeObjectHandler(this.objectHandler);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            try {
                if (this.eventHandler != null) {
                    this.eventHandler.dispose();
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            try {
                if (this.adapterFactory != null) {
                    this.adapterFactory.dispose();
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        if (((CDOEditorInput)this.getEditorInput()).isViewOwned()) {
            LifecycleUtil.deactivate((Object)this.view);
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return true;
    }

    protected void fireDirtyPropertyChange() {
        try {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        CDOEditor.this.firePropertyChange(257);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void closeEditor() {
        try {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        CDOEditor.this.getSite().getPage().closeEditor((IEditorPart)CDOEditor.this, false);
                        CDOEditor.this.dispose();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void refreshViewer(final Object element) {
        try {
            this.selectionViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (element == null) {
                            CDOEditor.this.selectionViewer.refresh(true);
                        } else {
                            CDOEditor.this.selectionViewer.refresh(element, true);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private Resource getSelectedResource() {
        IStructuredSelection ssel = (IStructuredSelection)this.editorSelection;
        if (ssel.isEmpty()) {
            if (this.viewerInput instanceof Resource) {
                return (Resource)this.viewerInput;
            }
        } else if (ssel.size() == 1) {
            Object element = ssel.getFirstElement();
            if (element instanceof Resource) {
                return (Resource)element;
            }
            if (element instanceof EObject) {
                return ((EObject)element).eResource();
            }
        }
        return null;
    }

    public static ComposedAdapterFactory createAdapterFactory(boolean reflective) {
        ComposedAdapterFactory.Descriptor.Registry registry = EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(registry);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        if (reflective) {
            adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        }
        return adapterFactory;
    }

    public static String getLabelText(AdapterFactory adapterFactory, Object object) {
        try {
            String text;
            IItemLabelProvider labelProvider = (IItemLabelProvider)adapterFactory.adapt(object, IItemLabelProvider.class);
            if (labelProvider != null && (text = labelProvider.getText(object)) != null) {
                return text;
            }
        }
        catch (Exception labelProvider) {
            // empty catch block
        }
        if (object != null) {
            String text = object.getClass().getSimpleName();
            if (text.endsWith("Impl")) {
                text = text.substring(0, text.length() - "Impl".length());
            }
            return text;
        }
        return "";
    }

    public static Object getLabelImage(AdapterFactory adapterFactory, Object object) {
        try {
            IItemLabelProvider labelProvider = (IItemLabelProvider)adapterFactory.adapt(object, IItemLabelProvider.class);
            if (labelProvider != null) {
                return labelProvider.getImage(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getString(String key) {
        return PluginDelegator.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return PluginDelegator.INSTANCE.getString(key, new Object[]{s1});
    }

    private static Field getPropertySheetPageViewerField() {
        try {
            return ReflectUtil.getField(PropertySheetPage.class, (String)"viewer");
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private static Field getContentOutlinePageViewerField() {
        try {
            return ReflectUtil.getField(ContentOutlinePage.class, (String)"treeViewer");
        }
        catch (Throwable ex) {
            return null;
        }
    }

    protected class CreateRootAction
    extends LongRunningAction {
        protected EObject newObject;

        protected CreateRootAction(EObject object) {
            super(CDOEditor.this.getEditorSite().getPage(), object.eClass().getName(), ExtendedImageRegistry.getInstance().getImageDescriptor(CDOEditor.getLabelImage((AdapterFactory)CDOEditor.this.adapterFactory, object)));
            this.newObject = object;
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            Resource resource = CDOEditor.this.getSelectedResource();
            if (resource != null) {
                if (this.newObject instanceof InternalCDOObject) {
                    this.newObject = ((InternalCDOObject)this.newObject).cdoInternalInstance();
                }
                resource.getContents().add((Object)this.newObject);
            }
        }
    }

    protected class EditingDomainProviderAdapter
    implements Adapter,
    IEditingDomainProvider {
        protected EditingDomainProviderAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == IEditingDomainProvider.class;
        }

        public EditingDomain getEditingDomain() {
            return CDOEditor.this.editingDomain;
        }

        public Notifier getTarget() {
            return null;
        }

        public void notifyChanged(Notification notification) {
        }

        public void setTarget(Notifier newTarget) {
        }
    }

    public static abstract class NewRootMenuPopulator {
        private final CDOPackageRegistry packageRegistry;

        public NewRootMenuPopulator(CDOPackageRegistry packageRegistry) {
            this.packageRegistry = packageRegistry;
        }

        public boolean populateMenu(IMenuManager menuManager) {
            boolean populated = false;
            Map.Entry[] entryArray = EMFUtil.getSortedRegistryEntries((EPackage.Registry)this.packageRegistry);
            int n = entryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Map.Entry entry = entryArray[n2];
                IContributionItem item = this.populateSubMenu((String)entry.getKey(), entry.getValue(), this.packageRegistry);
                if (item != null) {
                    menuManager.add(item);
                    populated = true;
                }
                ++n2;
            }
            return populated;
        }

        protected IContributionItem populateSubMenu(String nsURI, Object value, final CDOPackageRegistry packageRegistry) {
            if (value instanceof EPackage) {
                EPackage ePackage = (EPackage)value;
                CDOPackageInfo packageInfo = packageRegistry.getPackageInfo(ePackage);
                CDOPackageUnit packageUnit = packageInfo.getPackageUnit();
                if (packageUnit.isResource()) {
                    return null;
                }
                ImageDescriptor imageDescriptor = SharedIcons.getDescriptor((String)"obj16/EPackage.gif");
                MenuManager submenuManager = new MenuManager(nsURI, imageDescriptor, nsURI);
                this.populateSubMenu(ePackage, (IMenuManager)submenuManager);
                return submenuManager;
            }
            ImageDescriptor imageDescriptor = SharedIcons.getDescriptor((String)"obj16/EPackageUnknown.gif");
            final MenuManager submenuManager = new MenuManager(nsURI, imageDescriptor, nsURI);
            submenuManager.setRemoveAllWhenShown(true);
            submenuManager.add((IAction)new Action(Messages.getString("CDOEditor.27")){});
            submenuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    String nsURI = submenuManager.getMenuText();
                    EPackage ePackage = packageRegistry.getEPackage(nsURI);
                    if (ePackage != null) {
                        this.populateSubMenu(ePackage, (IMenuManager)submenuManager);
                    } else {
                        OM.LOG.warn(MessageFormat.format(Messages.getString("CDOEditor.28"), nsURI));
                    }
                }
            });
            return submenuManager;
        }

        protected void populateSubMenu(EPackage ePackage, IMenuManager submenuManager) {
            ArrayList<EObject> objects = new ArrayList<EObject>();
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || eClass.isInterface()) continue;
                objects.add(EcoreUtil.create((EClass)eClass));
            }
            if (!objects.isEmpty()) {
                Collections.sort(objects, new Comparator<EObject>(){

                    @Override
                    public int compare(EObject o1, EObject o2) {
                        return o1.eClass().getName().compareTo(o2.eClass().getName());
                    }
                });
                for (EObject object : objects) {
                    IAction action = this.createAction(object);
                    submenuManager.add(action);
                }
            }
        }

        protected abstract IAction createAction(EObject var1);
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }

    private static final class SafeTreeViewer
    extends TreeViewer {
        public SafeTreeViewer(Tree tree) {
            super(tree);
        }

        public SafeTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
            block2: {
                try {
                    super.doUpdateItem(widget, element, fullMap);
                }
                catch (Exception ex) {
                    if (!TRACER.isEnabled()) break block2;
                    TRACER.trace((Throwable)ex);
                }
            }
        }

        protected void doUpdateItem(Item item, Object element) {
            block2: {
                try {
                    super.doUpdateItem(item, element);
                }
                catch (Exception ex) {
                    if (!TRACER.isEnabled()) break block2;
                    TRACER.trace((Throwable)ex);
                }
            }
        }

        public boolean isExpandable(Object element) {
            try {
                return super.isExpandable(element);
            }
            catch (Exception ex) {
                if (TRACER.isEnabled()) {
                    TRACER.trace((Throwable)ex);
                }
                return false;
            }
        }
    }
}

