/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.util;

import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.parsers.sql.postparse.PostParseProcessorConfiguration;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParseResult;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManager;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManagerProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ISQLDialectInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;

public class SQLParserUtil {
    public static QueryStatement parseForDifferentDialect(SQLBuilderEditorInput editorInput, SQLDomainModel domainModel) {
        QueryStatement sqlStatement = null;
        String strSQL = editorInput.getSQL();
        strSQL = strSQL.trim();
        try {
            sqlStatement = SQLParserUtil.parse(strSQL, editorInput, domainModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sqlStatement;
    }

    protected static QueryStatement parse(String sqlStr, SQLBuilderEditorInput editorInput, SQLDomainModel domainModel) throws SQLParserException, SQLParserInternalException {
        SQLQueryParseResult parseResult;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{sqlStr});
        }
        QueryStatement parsedStatement = null;
        SQLQueryParserManager parserManager = SQLParserUtil.getParserManager(editorInput, domainModel);
        if (parserManager != null && (parseResult = parserManager.parseQuery(sqlStr)) != null) {
            parsedStatement = parseResult.getQueryStatement();
        }
        return (QueryStatement)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(parsedStatement);
    }

    protected static SQLQueryParserManager getParserManager(SQLBuilderEditorInput editorInput, SQLDomainModel domainModel) {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        ISQLDialectInfo dialectInfo = editorInput.getSQLStatementInfo().getSQLDialectInfo();
        SQLQueryParserManager parserManager = null;
        String dbProduct = dialectInfo.getProduct();
        String dbVersion = dialectInfo.getVersion();
        parserManager = SQLQueryParserManagerProvider.getInstance().getParserManager(dbProduct, dbVersion);
        SQLQuerySourceFormat srcFormat = SQLParserUtil.getSqlSourceFormat(editorInput.getSQLStatementInfo().getSQLDialectInfo());
        parserManager.setSourceFormat(srcFormat);
        PostParseProcessorConfiguration p3config = SQLParserUtil.getPostParseProcessorConfiguration(domainModel);
        parserManager.configPostParseProcessors(p3config);
        return (SQLQueryParserManager)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)parserManager);
    }

    protected static SQLQuerySourceFormat getSqlSourceFormat(ISQLDialectInfo sqlDialectInfo) {
        SQLQuerySourceFormat sqlSourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
        String omitSchema = sqlDialectInfo.getOmitSchema();
        sqlSourceFormat.setOmitSchema(omitSchema);
        DatabaseDefinition dbDef = SQLParserUtil.getDatabaseDefinition(sqlDialectInfo);
        if (dbDef != null && dbDef.getIdentifierQuoteString() != null && dbDef.getIdentifierQuoteString().length() == 1) {
            sqlSourceFormat.setDelimitedIdentifierQuote(dbDef.getIdentifierQuoteString().charAt(0));
        }
        return (SQLQuerySourceFormat)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)sqlSourceFormat);
    }

    private static DatabaseDefinition getDatabaseDefinition(ISQLDialectInfo dialectInfo) {
        DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(dialectInfo.getProduct(), dialectInfo.getVersion());
        return dbDef;
    }

    protected static PostParseProcessorConfiguration getPostParseProcessorConfiguration(SQLDomainModel domainModel) {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        Database db = domainModel.getDatabase();
        String currentSchemaName = domainModel.getCurrentSchema();
        PostParseProcessorConfiguration p3config = new PostParseProcessorConfiguration(db, currentSchemaName);
        return (PostParseProcessorConfiguration)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)p3config);
    }

    public static String generateSQL(QueryStatement sqlStatement, SQLBuilderEditorInput editorInput) {
        return sqlStatement.getSQL();
    }
}

