/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.build.CBuilder;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tools.templates.freemarker.FMProjectGenerator;
import org.eclipse.tools.templates.freemarker.SourceRoot;
import org.eclipse.tools.templates.freemarker.TemplateManifest;
import org.osgi.framework.Bundle;

public class MakefileProjectGenerator
extends FMProjectGenerator {
    public MakefileProjectGenerator(String manifestPath) {
        super(manifestPath);
    }

    protected Bundle getSourceBundle() {
        return MakeCorePlugin.getDefault().getBundle();
    }

    protected void initProjectDescription(IProjectDescription description) throws CoreException {
        description.setNatureIds(new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature", MakeProjectNature.NATURE_ID});
        ICommand command = description.newCommand();
        CBuilder.setupBuilder((ICommand)command);
        description.setBuildSpec(new ICommand[]{command});
    }

    public void generate(Map<String, Object> model, IProgressMonitor monitor) throws CoreException {
        super.generate(model, monitor);
        ArrayList<Object> entries = new ArrayList<Object>();
        IProject project = this.getProject();
        IFolder buildFolder = this.getProject().getFolder("build");
        TemplateManifest manifest = this.getManifest();
        if (manifest != null) {
            List srcRoots = this.getManifest().getSrcRoots();
            if (srcRoots != null && !srcRoots.isEmpty()) {
                for (SourceRoot srcRoot : srcRoots) {
                    IFolder sourceFolder = project.getFolder(srcRoot.getDir());
                    if (!sourceFolder.exists()) {
                        sourceFolder.create(true, true, monitor);
                    }
                    entries.add(CoreModel.newSourceEntry((IPath)sourceFolder.getFullPath(), (IPath[])new IPath[]{buildFolder.getFullPath()}));
                }
            } else {
                entries.add(CoreModel.newSourceEntry((IPath)this.getProject().getFullPath()));
            }
        }
        entries.add(CoreModel.newOutputEntry((IPath)buildFolder.getFullPath()));
        CoreModel.getDefault().create(project).setRawPathEntries(entries.toArray(new IPathEntry[entries.size()]), monitor);
    }
}

