/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.details.IOngoingChange;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.Throw;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetFaultNameCommand;
import org.eclipse.bpel.ui.commands.SetFaultNamespaceCommand;
import org.eclipse.bpel.ui.commands.SetVariableCommand;
import org.eclipse.bpel.ui.dialogs.VariableSelectorDialog;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.ChangeTracker;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.bpel.ui.util.NamespaceUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class FaultThrowNameSection
extends BPELPropertySection {
    protected static final int NAME_BUILTIN_CONTEXT = 0;
    protected static final int NAMESPACE_CONTEXT = 1;
    protected static final int VARIABLE_CONTEXT = 2;
    protected static final int BUILTINRADIO_CONTEXT = 3;
    protected static final int USERDEFRADIO_CONTEXT = 4;
    protected static final int NAME_USERDEF_CONTEXT = 5;
    protected static final int FAULT_VARIABLE_CONTEXT = 6;
    protected int lastChangeContext = -1;
    protected boolean isCatch;
    protected boolean isFaultTypeEnabled;
    protected Composite parentComposite;
    protected Composite faultTypeComposite;
    protected Composite namespaceComposite;
    protected Composite faultNameComposite;
    protected Composite faultUserDefNameComposite;
    protected Composite faultVariableNameComposite;
    protected Button builtinRadio;
    protected Button userdefRadio;
    protected Button variableBrowseButton;
    protected Text faultNamespaceText;
    protected Text faultUserDefText;
    protected Text variableNameText;
    protected CCombo faultNameCombo;
    protected Label variableName;
    protected ChangeTracker faultNameTracker;
    protected ChangeTracker faultNamespaceTracker;
    protected ChangeTracker faultUserDefNameTracker;
    protected ChangeTracker variableNameTracker;

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                if (ModelHelper.isFaultNameAffected(FaultThrowNameSection.this.getInput(), n) && FaultThrowNameSection.this.builtinRadio.getSelection()) {
                    FaultThrowNameSection.this.updateFaultNameWidgets();
                } else if (ModelHelper.isFaultNameAffected(FaultThrowNameSection.this.getInput(), n) && FaultThrowNameSection.this.userdefRadio.getSelection()) {
                    FaultThrowNameSection.this.updateUserDefFaultNameWidgets();
                }
                if (FaultThrowNameSection.this.isFaultTypeEnabled && ModelHelper.isFaultNamespaceAffected(FaultThrowNameSection.this.getInput(), n)) {
                    FaultThrowNameSection.this.updateFaultNamespaceWidgets();
                }
                if (ModelHelper.isVariableAffected(FaultThrowNameSection.this.getInput(), n, 0)) {
                    FaultThrowNameSection.this.updateFaultVariableWidgets();
                    FaultThrowNameSection.this.updateVariableWidgets();
                }
            }
        }};
    }

    protected boolean isNamespaceUserDef() {
        return this.isFaultTypeEnabled && this.userdefRadio.getSelection();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected void doChildLayout() {
        FlatFormData data = null;
        FlatFormData data1 = null;
        if (this.isFaultTypeEnabled) {
            if (this.isNamespaceUserDef()) {
                data = (FlatFormData)this.faultUserDefNameComposite.getLayoutData();
                data.top = new FlatFormAttachment((Control)this.namespaceComposite, 4);
                data1 = (FlatFormData)this.faultVariableNameComposite.getLayoutData();
                data1.top = new FlatFormAttachment((Control)this.faultUserDefNameComposite, 4);
            } else {
                data = (FlatFormData)this.faultNameComposite.getLayoutData();
                data.top = new FlatFormAttachment((Control)this.faultTypeComposite, 4);
                data1 = (FlatFormData)this.faultVariableNameComposite.getLayoutData();
                data1.top = new FlatFormAttachment((Control)this.faultNameComposite, 4);
            }
        } else {
            data.top = new FlatFormAttachment(0, 0);
        }
        this.faultTypeComposite.setVisible(this.isFaultTypeEnabled);
        this.namespaceComposite.setVisible(this.isNamespaceUserDef());
        this.faultNameComposite.setVisible(!this.isNamespaceUserDef());
        this.faultUserDefNameComposite.setVisible(this.isNamespaceUserDef());
        this.faultVariableNameComposite.setVisible(true);
        this.parentComposite.layout(true);
    }

    @Override
    protected void basicSetInput(EObject input) {
        super.basicSetInput(input);
        this.rearrangeWidgets();
    }

    protected void rearrangeWidgets() {
        EObject maybeInvoke;
        FaultHandler faultHandler;
        this.isCatch = this.getInput() instanceof Catch;
        this.isFaultTypeEnabled = true;
        if (this.isCatch && (faultHandler = (FaultHandler)this.getInput().eContainer()) != null && (maybeInvoke = faultHandler.eContainer()) instanceof Invoke) {
            this.isFaultTypeEnabled = false;
        }
        this.doChildLayout();
    }

    protected void createFaultTypeWidgets(Composite parent) {
        Composite composite = this.faultTypeComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment(0, 0);
        composite.setLayoutData((Object)data);
        Label faultTypeLabel = this.fWidgetFactory.createLabel(composite, Messages.FaultThrowNameDetails_Fault_Type__13);
        this.builtinRadio = this.fWidgetFactory.createButton(composite, Messages.FaultThrowNameDetails_Built_in_14, 16);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)faultTypeLabel, 105));
        data.top = new FlatFormAttachment(0, 2);
        this.builtinRadio.setLayoutData((Object)data);
        this.builtinRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SetFaultNameCommand cmd1;
                if (!FaultThrowNameSection.this.builtinRadio.getSelection()) {
                    return;
                }
                FaultThrowNameSection.this.doChildLayout();
                CompoundCommand compound = new CompoundCommand();
                SetFaultNamespaceCommand cmd = new SetFaultNamespaceCommand((EObject)FaultThrowNameSection.this.getInput(), BPELConstants.NAMESPACE);
                if (cmd.canExecute()) {
                    compound.add((Command)cmd);
                }
                if ((cmd1 = new SetFaultNameCommand((EObject)FaultThrowNameSection.this.getInput(), BPELConstants.standardFaults[0])).canExecute()) {
                    compound.add((Command)cmd1);
                }
                FaultThrowNameSection.this.lastChangeContext = 3;
                FaultThrowNameSection.this.getCommandFramework().execute(FaultThrowNameSection.this.wrapInShowContextCommand((Command)compound));
                FaultThrowNameSection.this.updateUserDefFaultNameWidgets();
                FaultThrowNameSection.this.updateFaultNameWidgets();
                FaultThrowNameSection.this.updateFaultNamespaceWidgets();
                FaultThrowNameSection.this.updateFaultVariableWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.userdefRadio = this.fWidgetFactory.createButton(composite, Messages.FaultThrowNameDetails_User_defined_15, 16);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.builtinRadio, 5);
        data.top = new FlatFormAttachment(0, 2);
        this.userdefRadio.setLayoutData((Object)data);
        this.userdefRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!FaultThrowNameSection.this.userdefRadio.getSelection()) {
                    return;
                }
                FaultThrowNameSection.this.doChildLayout();
                SetFaultNamespaceCommand cmd = new SetFaultNamespaceCommand((EObject)FaultThrowNameSection.this.getInput(), FaultThrowNameSection.this.getProcess().getTargetNamespace());
                FaultThrowNameSection.this.lastChangeContext = 4;
                FaultThrowNameSection.this.getCommandFramework().execute(FaultThrowNameSection.this.wrapInShowContextCommand((Command)cmd));
                FaultThrowNameSection.this.updateUserDefFaultNameWidgets();
                FaultThrowNameSection.this.updateFaultNameWidgets();
                FaultThrowNameSection.this.updateFaultNamespaceWidgets();
                FaultThrowNameSection.this.updateFaultVariableWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.builtinRadio, -5);
        data.top = new FlatFormAttachment((Control)this.builtinRadio, 0, 0x1000000);
        faultTypeLabel.setLayoutData((Object)data);
    }

    protected void createChangeTrackers() {
        Object change = new IOngoingChange(){

            public String getLabel() {
                return IBPELUIConstants.CMD_EDIT_FAULTNAME;
            }

            public Command createApplyCommand() {
                String name = FaultThrowNameSection.this.faultNameCombo.getText();
                FaultThrowNameSection.this.lastChangeContext = 0;
                CompoundCommand c = new CompoundCommand();
                c.add((Command)new SetFaultNameCommand((EObject)FaultThrowNameSection.this.getInput(), "".equals(name) ? null : name));
                SetFaultNamespaceCommand c2 = new SetFaultNamespaceCommand((EObject)FaultThrowNameSection.this.getInput(), BPELConstants.NAMESPACE);
                if (c2.canExecute()) {
                    c.add((Command)c2);
                }
                CompoundCommand command = c;
                return FaultThrowNameSection.this.wrapInShowContextCommand((Command)command);
            }

            public void restoreOldState() {
                FaultThrowNameSection.this.updateFaultNameWidgets();
            }
        };
        this.faultNameTracker = new ChangeTracker((Control)this.faultNameCombo, (IOngoingChange)change, this.getCommandFramework());
        change = new IOngoingChange(){

            public String getLabel() {
                return IBPELUIConstants.CMD_EDIT_FAULTNAME;
            }

            public Command createApplyCommand() {
                String s = FaultThrowNameSection.this.faultNamespaceText.getText();
                FaultThrowNameSection.this.lastChangeContext = 1;
                return FaultThrowNameSection.this.wrapInShowContextCommand((Command)new SetFaultNamespaceCommand((EObject)FaultThrowNameSection.this.getInput(), "".equals(s) ? null : s));
            }

            public void restoreOldState() {
                FaultThrowNameSection.this.updateFaultNameWidgets();
            }
        };
        this.faultNamespaceTracker = new ChangeTracker((Control)this.faultNamespaceText, (IOngoingChange)change, this.getCommandFramework());
        change = new IOngoingChange(){

            public String getLabel() {
                return IBPELUIConstants.CMD_EDIT_FAULTNAME;
            }

            public Command createApplyCommand() {
                String s = FaultThrowNameSection.this.faultUserDefText.getText();
                FaultThrowNameSection.this.lastChangeContext = 5;
                return FaultThrowNameSection.this.wrapInShowContextCommand((Command)new SetFaultNameCommand((EObject)FaultThrowNameSection.this.getInput(), "".equals(s) ? null : s));
            }

            public void restoreOldState() {
                FaultThrowNameSection.this.updateUserDefFaultNameWidgets();
            }
        };
        this.faultUserDefNameTracker = new ChangeTracker((Control)this.faultUserDefText, (IOngoingChange)change, this.getCommandFramework());
    }

    protected void createFaultNameWidgets(Composite parent) {
        Composite composite = this.faultNameComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.namespaceComposite, 4);
        composite.setLayoutData((Object)data);
        Label faultNameLabel = this.fWidgetFactory.createLabel(composite, Messages.FaultThrowNameDetails_Fault_Name__16);
        this.faultNameCombo = this.fWidgetFactory.createCCombo(composite);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)faultNameLabel, 105));
        data.right = new FlatFormAttachment(50, -60);
        data.top = new FlatFormAttachment(0, 0);
        this.faultNameCombo.setItems(BPELConstants.standardFaults);
        this.faultNameCombo.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.faultNameCombo, -5);
        data.top = new FlatFormAttachment((Control)this.faultNameCombo, 0, 0x1000000);
        faultNameLabel.setLayoutData((Object)data);
    }

    protected void createNamespaceWidgets(Composite parent) {
        Composite composite = this.namespaceComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.faultTypeComposite, 4);
        composite.setLayoutData((Object)data);
        Label faultNamespaceLabel = this.fWidgetFactory.createLabel(composite, Messages.FaultThrowNameDetails_Namespace__21);
        this.faultNamespaceText = this.fWidgetFactory.createText(composite, "");
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)faultNamespaceLabel, 105));
        data.right = new FlatFormAttachment(50, -60);
        data.top = new FlatFormAttachment(0, 1);
        data.bottom = new FlatFormAttachment(100, -1);
        this.faultNamespaceText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.faultNamespaceText, -5);
        data.top = new FlatFormAttachment((Control)this.faultNamespaceText, 0, 0x1000000);
        faultNamespaceLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.faultNamespaceText, 5);
        data.right = new FlatFormAttachment(100, 0);
        data.left = new FlatFormAttachment(100, -60);
        data.top = new FlatFormAttachment((Control)this.faultNamespaceText, -1, 128);
        data.bottom = new FlatFormAttachment((Control)this.faultNamespaceText, 1, 1024);
    }

    protected void createUserDefFaultNameWidgets(Composite parent) {
        Composite composite = this.faultUserDefNameComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.namespaceComposite, 4);
        composite.setLayoutData((Object)data);
        Label faultUserDefNameLabel = this.fWidgetFactory.createLabel(composite, Messages.FaultThrowNameDetails_Fault_Name__24);
        this.faultUserDefText = this.fWidgetFactory.createText(composite, "");
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)faultUserDefNameLabel, 105));
        data.right = new FlatFormAttachment(50, -60);
        data.top = new FlatFormAttachment(0, 1);
        this.faultUserDefText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.faultUserDefText, -5);
        data.top = new FlatFormAttachment((Control)this.faultUserDefText, 0, 0x1000000);
        faultUserDefNameLabel.setLayoutData((Object)data);
    }

    protected void createVariableWidgets(Composite parent) {
        final Composite composite = this.faultVariableNameComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.faultNameComposite, 4);
        composite.setLayoutData((Object)data);
        Label variableLabel = this.fWidgetFactory.createLabel(composite, Messages.FaultThrowNameDetails_Fault_Variable__27);
        this.variableName = this.fWidgetFactory.createLabel(composite, "", 0);
        this.variableBrowseButton = this.fWidgetFactory.createButton(composite, Messages.FaultThrowNameSection_Browse_1, 8);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)variableLabel, 105));
        data.right = new FlatFormAttachment((Control)this.variableBrowseButton, -5);
        data.top = new FlatFormAttachment(0, 0);
        data.height = FigureUtilities.getTextExtents((String)this.variableBrowseButton.getText(), (Font)this.variableBrowseButton.getFont()).height + 4;
        this.variableName.setLayoutData((Object)data);
        data = new FlatFormData();
        data.top = new FlatFormAttachment((Control)this.variableName, 0, 128);
        data.bottom = new FlatFormAttachment((Control)this.variableName, 2, 1024);
        data.left = new FlatFormAttachment(50, -BPELUtil.calculateButtonWidth((Widget)this.variableBrowseButton, 45) - 10);
        data.right = new FlatFormAttachment(50, -10);
        this.variableBrowseButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.variableName, -5);
        data.top = new FlatFormAttachment((Control)this.variableName, 0, 0x1000000);
        variableLabel.setLayoutData((Object)data);
        this.variableBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = composite.getShell();
                Object model = FaultThrowNameSection.this.getInput();
                VariableSelectorDialog dialog = new VariableSelectorDialog(shell, (EObject)model, ModelHelper.getVariableType(model, 0));
                dialog.setTitle(Messages.FaultThrowNameSection_Select_Fault_Variable_2);
                if (dialog.open() == 0) {
                    Variable variable = dialog.getVariable();
                    SetVariableCommand command = new SetVariableCommand(FaultThrowNameSection.this.fModelObject, variable, 0);
                    FaultThrowNameSection.this.lastChangeContext = 2;
                    FaultThrowNameSection.this.getCommandFramework().execute(FaultThrowNameSection.this.wrapInShowContextCommand((Command)command));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.parentComposite = this.createFlatFormComposite(parent);
        this.createFaultTypeWidgets(composite);
        this.createUserDefFaultNameWidgets(composite);
        this.createNamespaceWidgets(composite);
        this.createFaultNameWidgets(composite);
        this.createVariableWidgets(composite);
        this.createChangeTrackers();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parentComposite, "org.eclipse.bpel.ui.property_fault");
    }

    protected void updateFaultNameWidgets() {
        Assert.isNotNull(this.getInput());
        this.faultNameTracker.stopTracking();
        try {
            String s = ModelHelper.getFaultName(this.getInput());
            if (s == null) {
                s = "";
            }
            if (!s.equals(this.faultNameCombo.getText())) {
                this.faultNameCombo.setText(s);
            }
        }
        finally {
            this.faultNameTracker.startTracking();
        }
    }

    protected void updateFaultNamespaceWidgets() {
        Assert.isNotNull(this.getInput());
        if (this.isFaultTypeEnabled) {
            this.faultNamespaceTracker.stopTracking();
            try {
                String s = ModelHelper.getFaultNamespace(this.getInput());
                if (s == null) {
                    this.faultNamespaceText.setText("");
                } else if (!s.equals(this.faultNamespaceText.getText())) {
                    this.faultNamespaceText.setText(NamespaceUtils.convertUriToNamespace(s));
                }
            }
            finally {
                this.faultNamespaceTracker.startTracking();
            }
        }
    }

    protected void updateUserDefFaultNameWidgets() {
        Assert.isNotNull(this.getInput());
        this.faultUserDefNameTracker.stopTracking();
        try {
            String s = ModelHelper.getFaultName(this.getInput());
            if (s == null) {
                s = "";
            }
            if (!s.equals(this.faultUserDefText.getText())) {
                this.faultUserDefText.setText(s);
            }
        }
        finally {
            this.faultUserDefNameTracker.startTracking();
        }
    }

    protected void updateFaultTypeWidgets() {
        Assert.isNotNull(this.getInput());
        String faultNamespace = ModelHelper.getFaultNamespace(this.getInput());
        boolean isBuiltin = BPELConstants.NAMESPACE.equals(faultNamespace);
        if (faultNamespace == null && ModelHelper.getFaultName(this.getInput()) == null) {
            isBuiltin = true;
        }
        this.builtinRadio.setSelection(isBuiltin);
        this.userdefRadio.setSelection(!isBuiltin);
        this.doChildLayout();
    }

    protected void updateFaultVariableWidgets() {
        String s;
        Assert.isNotNull(this.getInput());
        Variable v = ((Throw)this.getInput()).getFaultVariable();
        String string = s = v == null ? null : v.getName();
        if (s == null) {
            s = "";
        }
        if (!s.equals(this.variableName.getText())) {
            this.variableName.setText(s);
        }
    }

    protected void updateVariableWidgets() {
        Variable variable = ModelHelper.getVariable(this.getInput(), 0);
        if (variable == null) {
            this.variableName.setText(Messages.FaultThrowNameSection_None_3);
            this.variableName.setEnabled(false);
        } else {
            ILabeledElement labeledElement = BPELUtil.adapt((Object)variable, ILabeledElement.class);
            this.variableName.setText(labeledElement.getLabel(variable));
            this.variableName.setEnabled(true);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateFaultTypeWidgets();
        this.updateFaultNamespaceWidgets();
        this.updateFaultNameWidgets();
        this.updateUserDefFaultNameWidgets();
        this.updateFaultVariableWidgets();
        this.updateVariableWidgets();
    }

    @Override
    public Object getUserContext() {
        return this.lastChangeContext;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        int i = (Integer)userContext;
        switch (i) {
            case 0: {
                this.faultNameCombo.setFocus();
                return;
            }
            case 1: {
                this.faultNamespaceText.setFocus();
                return;
            }
            case 3: {
                this.builtinRadio.setFocus();
                return;
            }
            case 4: {
                this.userdefRadio.setFocus();
                return;
            }
            case 5: {
                this.faultUserDefText.setFocus();
                return;
            }
            case 6: {
                this.variableNameText.setFocus();
                return;
            }
        }
        throw new IllegalStateException();
    }
}

