/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.flatui;

import org.eclipse.bpel.common.ui.flatui.BorderLayout;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class FlatFormLayout
extends BorderLayout {
    public int marginWidth = 0;
    public int marginHeight = 0;

    int computeHeight(FlatFormData data) {
        FlatFormAttachment top = data.getTopAttachment();
        FlatFormAttachment bottom = data.getBottomAttachment();
        FlatFormAttachment height = bottom.minus(top);
        if (height.numerator == 0) {
            if (bottom.numerator == 0) {
                return bottom.offset;
            }
            if (bottom.numerator == bottom.denominator) {
                return -top.offset;
            }
            if (bottom.offset <= 0) {
                return -top.offset * top.denominator / bottom.numerator;
            }
            int divider = bottom.denominator - bottom.numerator;
            return bottom.denominator * bottom.offset / divider;
        }
        return height.solveY(data.cacheHeight);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = this.layout(composite, false, 0, 0, 0, 0, flushCache);
        size.x += this.marginWidth * 2;
        size.y += this.marginHeight * 2;
        return size;
    }

    int computeWidth(FlatFormData data) {
        FlatFormAttachment left = data.getLeftAttachment();
        FlatFormAttachment right = data.getRightAttachment();
        FlatFormAttachment width = right.minus(left);
        if (width.numerator == 0) {
            if (right.numerator == 0) {
                return right.offset;
            }
            if (right.numerator == right.denominator) {
                return -left.offset;
            }
            if (right.offset <= 0) {
                return -left.offset * left.denominator / left.numerator;
            }
            int divider = right.denominator - right.numerator;
            return right.denominator * right.offset / divider;
        }
        return width.solveY(data.cacheWidth);
    }

    Point getSize(Control control, boolean flushCache) {
        int wHint = -1;
        int hHint = -1;
        FlatFormData data = (FlatFormData)control.getLayoutData();
        if (data != null) {
            wHint = data.width;
            hHint = data.height;
        }
        Point pt = control.computeSize(wHint, hHint, flushCache);
        int bshape = BorderShape[FlatFormLayout.getBorderType(data == null ? 0 : data.borderType, control)];
        pt.x += LeftBorderSize[bshape] + RightBorderSize[bshape];
        pt.y += TopBorderSize[bshape] + BottomBorderSize[bshape];
        return pt;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        int x = rect.x + this.marginWidth;
        int y = rect.y + this.marginHeight;
        int width = Math.max(0, rect.width - 2 * this.marginWidth);
        int height = Math.max(0, rect.height - 2 * this.marginHeight);
        this.layout(composite, true, x, y, width, height, flushCache);
    }

    Point layout(Composite composite, boolean move, int x, int y, int width, int height, boolean flushCache) {
        Control child;
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            Point pt = this.getSize(child, false);
            FlatFormData data = (FlatFormData)child.getLayoutData();
            if (data == null) {
                data = new FlatFormData();
                child.setLayoutData((Object)data);
            }
            data.cacheWidth = pt.x;
            data.cacheHeight = pt.y;
            ++i;
        }
        i = 0;
        while (i < children.length) {
            child = children[i];
            FlatFormData data = (FlatFormData)child.getLayoutData();
            int bshape = BorderShape[FlatFormLayout.getBorderType(data == null ? 0 : data.borderType, child)];
            if (data != null) {
                if (move) {
                    int x1 = data.getLeftAttachment().solveX(width) + LeftBorderSize[bshape];
                    int y1 = data.getTopAttachment().solveX(height) + TopBorderSize[bshape];
                    int x2 = data.getRightAttachment().solveX(width) - RightBorderSize[bshape];
                    int y2 = data.getBottomAttachment().solveX(height) - BottomBorderSize[bshape];
                    child.setBounds(x + x1, y + y1, x2 - x1, y2 - y1);
                } else {
                    width = Math.max(this.computeWidth(data), width);
                    height = Math.max(this.computeHeight(data), height);
                }
            }
            ++i;
        }
        return move ? null : new Point(width, height);
    }

    public String toString() {
        String string = String.valueOf(this.getClass().getName()) + " {";
        if (this.marginWidth != 0) {
            string = String.valueOf(string) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = String.valueOf(string) + "marginHeight=" + this.marginHeight + " ";
        }
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }
}

