/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.details.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ComboViewer
extends StructuredViewer {
    private Combo combo;
    private List<Object> comboMap = new ArrayList<Object>();

    public ComboViewer(Composite parent) {
        this(parent, 770);
    }

    public ComboViewer(Composite parent, int style) {
        this(new Combo(parent, style));
    }

    public ComboViewer(Combo combo) {
        this.combo = combo;
        this.hookControl((Control)combo);
    }

    public void add(Object[] elements) {
        Object[] filtered = this.filter(elements);
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        int i = 0;
        while (i < filtered.length) {
            Object element = filtered[i];
            int ix = this.indexForElement(element);
            this.combo.add(labelProvider.getText(element), ix);
            this.comboMap.add(ix, element);
            this.mapElement(element, (Widget)this.combo);
            ++i;
        }
    }

    public void add(Object element) {
        this.add(new Object[]{element});
    }

    protected Widget doFindInputItem(Object element) {
        if (element != null && element.equals(this.getRoot())) {
            return this.getCombo();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (element != null && this.comboMap.contains(element)) {
            return this.getCombo();
        }
        return null;
    }

    protected void doUpdateItem(Widget data, Object element, boolean fullMap) {
        int ix;
        if (element != null && (ix = this.comboMap.indexOf(element)) >= 0) {
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            this.combo.setItem(ix, labelProvider.getText(element));
        }
    }

    public Control getControl() {
        return this.combo;
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.comboMap.size()) {
            return this.comboMap.get(index);
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    public Combo getCombo() {
        return this.combo;
    }

    protected List<Object> getSelectionFromWidget() {
        int idx = this.getCombo().getSelectionIndex();
        if (idx < 0) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> list = new ArrayList<Object>(1);
        Object e = this.getElementAt(idx);
        if (e != null) {
            list.add(e);
        }
        return list;
    }

    protected int indexForElement(Object element) {
        ViewerSorter sorter = this.getSorter();
        if (sorter == null) {
            return this.combo.getItemCount();
        }
        int count = this.combo.getItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.comboMap.get(mid);
            int compare = sorter.compare((Viewer)this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this.comboMap.get(mid);
                    compare = sorter.compare((Viewer)this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.comboMap.clear();
        Object[] children = this.getSortedChildren(this.getRoot());
        int size = children.length;
        Combo combo = this.getCombo();
        combo.removeAll();
        String[] labels = new String[size];
        int i = 0;
        while (i < size) {
            Object el = children[i];
            labels[i] = ((ILabelProvider)this.getLabelProvider()).getText(el);
            this.comboMap.add(el);
            this.mapElement(el, (Widget)combo);
            ++i;
        }
        combo.setItems(labels);
    }

    protected void internalRefresh(Object element) {
        if (element == null || element.equals(this.getRoot())) {
            if (this.comboMap != null) {
                this.comboMap.clear();
            }
            this.unmapAllElements();
            List<Object> selection = this.getSelectionFromWidget();
            this.combo.setRedraw(false);
            this.combo.removeAll();
            Object[] children = this.getSortedChildren(this.getRoot());
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            int i = 0;
            while (i < children.length) {
                Object el = children[i];
                this.combo.add(labelProvider.getText(el), i);
                this.comboMap.add(el);
                this.mapElement(el, (Widget)this.combo);
                ++i;
            }
            this.combo.setRedraw(true);
            this.setSelectionToWidget(selection, false);
        } else {
            this.doUpdateItem((Widget)this.combo, element, true);
        }
    }

    private void internalRemove(Object[] elements) {
        Object input = this.getInput();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(input)) {
                this.setInput(null);
                return;
            }
            int ix = this.comboMap.indexOf(elements[i]);
            if (ix >= 0) {
                this.combo.remove(ix);
                this.comboMap.remove(ix);
                this.unmapElement(elements[i], (Widget)this.combo);
            }
            ++i;
        }
    }

    public void remove(final Object[] elements) {
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                ComboViewer.this.internalRemove(elements);
            }
        });
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    public void reveal(Object element) {
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ILabelProvider));
        super.setLabelProvider(labelProvider);
    }

    protected void setSelectionToWidget(List in, boolean reveal) {
        Combo combo = this.getCombo();
        if (in == null || in.size() == 0) {
            combo.deselectAll();
        } else {
            int n = in.size();
            int[] ixs = new int[n];
            int count = 0;
            int i = 0;
            while (i < n) {
                Object el = in.get(i);
                int ix = this.comboMap.indexOf(el);
                if (ix >= 0) {
                    ixs[count++] = ix;
                }
                ++i;
            }
            if (count < n) {
                int[] nArray = ixs;
                ixs = new int[count];
                System.arraycopy(nArray, 0, ixs, 0, count);
            }
            if (ixs.length > 0) {
                combo.select(ixs[0]);
            }
        }
    }
}

