/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.ui.internal.views;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;

public class ResultRunnable
implements Runnable {
    private static final String XML_PROCESSING_INSTRUCTION = "<?xml";
    private static final String DOCTYPE_HTML = "<!DOCTYPE html";
    private static final String HTML_CONTENT_TYPE_ID = "org.eclipse.wst.html.core.htmlsource";
    private static final String XML_CONTENT_TYPE_ID = "org.eclipse.core.runtime.xml";
    private SourceViewer sourceViewer = null;
    private final String results;
    private IWorkbenchPartSite viewSite = null;

    public ResultRunnable(SourceViewer viewer, String results, IWorkbenchPartSite site) {
        this.sourceViewer = viewer;
        this.results = results;
        this.viewSite = site;
    }

    @Override
    public void run() {
        IDocument document;
        if (this.sourceViewer.getDocument() == null) {
            document = this.createDocument();
            this.sourceViewer.setDocument(document);
        }
        try {
            document = this.sourceViewer.getDocument();
            document.replace(document.getLength(), 0, this.results);
        }
        catch (BadLocationException e) {
            XSLDebugUIPlugin.log((Exception)((Object)e));
        }
        this.sourceViewer.revealRange(this.sourceViewer.getDocument().getLength(), 0);
        this.viewSite.getPage().activate(this.viewSite.getPart());
    }

    protected IDocument createDocument() {
        Object document = this.results.startsWith(DOCTYPE_HTML) ? this.createStructuredDocument(HTML_CONTENT_TYPE_ID) : (this.results.startsWith(XML_PROCESSING_INSTRUCTION) ? this.createStructuredDocument(XML_CONTENT_TYPE_ID) : new JobSafeStructuredDocument());
        return document;
    }

    protected IDocument createStructuredDocument(String contentType) {
        IStructuredModel scratchModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(contentType);
        IStructuredDocument document = scratchModel.getStructuredDocument();
        return document;
    }
}

