/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.wsil.Service;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIServiceInterfaceElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public class FavoritesUDDIServiceInterfaceFolderElement
extends FavoritesFolderElement {
    public FavoritesUDDIServiceInterfaceFolderElement(String name, Model model, NodeManager nodeManager) {
        super(name, model, nodeManager);
    }

    public void init(FavoritesMainElement favMainElement) {
        Service[] services = favMainElement.loadUDDIServiceInterfaces();
        int i = 0;
        while (i < services.length) {
            Service service = services[i];
            FavoritesUDDIServiceInterfaceElement favUDDISerIntElement = new FavoritesUDDIServiceInterfaceElement(service.getServiceNames()[0].getText(), this.getModel(), service);
            this.connect((Element)favUDDISerIntElement, "relUDDIServiceInterfaceNode", "owner");
            ++i;
        }
    }

    public boolean addFavorite(Hashtable table) {
        String serIntName = (String)table.get("UDDIServiceInterfaceName");
        String inquiryAPI = (String)table.get("UDDIServiceInterfaceInquiryAPI");
        String serIntKey = (String)table.get("UDDIServiceInterfaceKey");
        if (serIntName == null || inquiryAPI == null || serIntKey == null) {
            return false;
        }
        FavoritesUDDIServiceInterfaceElement e = this.getFavorite(inquiryAPI, serIntKey);
        if (e != null) {
            this.removeFavorite(e);
        }
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Service service = favMainElement.addUDDIServiceInterface(serIntName, inquiryAPI, serIntKey);
        boolean saved = favMainElement.saveFavorites();
        if (saved) {
            FavoritesUDDIServiceInterfaceElement favUDDISerIntElement = new FavoritesUDDIServiceInterfaceElement(serIntName, this.getModel(), service);
            this.connect((Element)favUDDISerIntElement, "relUDDIServiceInterfaceNode", "owner");
        }
        return saved;
    }

    public boolean favoriteExists(Hashtable table) {
        String inquiryAPI = (String)table.get("UDDIServiceInterfaceInquiryAPI");
        String serIntKey = (String)table.get("UDDIServiceInterfaceKey");
        if (inquiryAPI == null || serIntKey == null) {
            return false;
        }
        return this.getFavorite(inquiryAPI, serIntKey) != null;
    }

    public boolean removeFavoriteByNodeID(int nodeID, String pluginMetadataDirectory) {
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        TreeElement selectedElement = selectedNode.getTreeElement();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (selectedElement instanceof FavoritesUDDIServiceInterfaceElement) {
            return this.removeFavorite((FavoritesUDDIServiceInterfaceElement)selectedElement) && favMainElement.saveFavorites();
        }
        return false;
    }

    private boolean removeFavorite(FavoritesUDDIServiceInterfaceElement element) {
        Service service = element.getService();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (favMainElement.removeService(service)) {
            element.disconnectAll();
            return true;
        }
        return false;
    }

    public boolean removeAllFavorites(String pluginMetadataDirectory) {
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesUDDIServiceInterfaceElement favUDDISerIntElement = (FavoritesUDDIServiceInterfaceElement)((Object)e.nextElement());
            Service service = favUDDISerIntElement.getService();
            favMainElement.removeService(service);
        }
        this.disconnectRel("relUDDIServiceInterfaceNode");
        return favMainElement.saveFavorites();
    }

    public Enumeration getAllFavorites() {
        return this.getElements("relUDDIServiceInterfaceNode");
    }

    private FavoritesUDDIServiceInterfaceElement getFavorite(String inquiryAPI, String serIntKey) {
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesUDDIServiceInterfaceElement serIntElement = (FavoritesUDDIServiceInterfaceElement)((Object)e.nextElement());
            if (!inquiryAPI.equals(serIntElement.getInquiryURL()) || !serIntKey.equals(serIntElement.getServiceInterfaceKey())) continue;
            return serIntElement;
        }
        return null;
    }
}

