/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Variable;

public abstract class VariableBasedAction
implements IObjectActionDelegate,
IActionDelegate2 {
    private final ElementHandler elementHandler;
    private Runnable currentRunnable = null;
    public static final ElementHandler VARIABLE_VIEW_ELEMENT_HANDLER = new ElementHandler(){

        @Override
        public VariableWrapper castElement(Object element) {
            if (!(element instanceof Variable)) {
                return null;
            }
            final Variable variable = (Variable)element;
            return new VariableWrapper(){

                @Override
                public Value getValue() {
                    return variable.getValue().asRealValue();
                }

                @Override
                public Variable getVariable() {
                    return variable;
                }

                @Override
                public IDebugElement getDebugElement() {
                    return variable;
                }

                @Override
                public ConnectedTargetData getConnectedTargetData() {
                    return variable.getConnectedData();
                }
            };
        }
    };
    public static final ElementHandler EXPRESSION_VIEW_ELEMENT_HANDLER = new ElementHandler(){

        @Override
        public VariableWrapper castElement(Object element) {
            if (!(element instanceof IWatchExpression)) {
                return null;
            }
            final IWatchExpression watchExpression = (IWatchExpression)element;
            return new VariableWrapper(){

                @Override
                public Value getValue() {
                    IValue value = watchExpression.getValue();
                    if (!(value instanceof Value)) {
                        return null;
                    }
                    Value chromiumValue = (Value)value;
                    return chromiumValue;
                }

                @Override
                public Variable getVariable() {
                    return null;
                }

                @Override
                public IDebugElement getDebugElement() {
                    return watchExpression;
                }

                @Override
                public ConnectedTargetData getConnectedTargetData() {
                    IDebugTarget debugTarget = watchExpression.getDebugTarget();
                    if (!(debugTarget instanceof DebugTargetImpl)) {
                        return null;
                    }
                    DebugTargetImpl debugTargetImpl = (DebugTargetImpl)debugTarget;
                    return debugTargetImpl.getConnectedOrNull();
                }
            };
        }
    };

    protected VariableBasedAction(ElementHandler elementHandler) {
        this.elementHandler = elementHandler;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.currentRunnable == null) {
            return;
        }
        this.currentRunnable.run();
    }

    public void dispose() {
        this.currentRunnable = null;
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        if (this.currentRunnable == null) {
            return;
        }
        this.currentRunnable.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        VariableWrapper wrapper = VariableBasedAction.getElementFromSelection(selection, this.elementHandler);
        this.currentRunnable = this.createRunnable(wrapper);
        action.setEnabled(this.currentRunnable != null);
    }

    protected abstract Runnable createRunnable(VariableWrapper var1);

    static VariableWrapper getElementFromSelection(ISelection selection, ElementHandler elementHandler) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() != 1) {
            return null;
        }
        Object element = structuredSelection.getFirstElement();
        return elementHandler.castElement(element);
    }

    public static abstract class ElementHandler {
        public abstract VariableWrapper castElement(Object var1);
    }

    public static interface VariableWrapper {
        public Variable getVariable();

        public Value getValue();

        public IDebugElement getDebugElement();

        public ConnectedTargetData getConnectedTargetData();
    }
}

