import { Position, CompletionList, Hover, Range, SymbolInformation, TextEdit, DocumentHighlight, DocumentLink, FoldingRange, SelectionRange, WorkspaceEdit } from 'vscode-languageserver-types';
import { TextDocument } from 'vscode-languageserver-textdocument';
import { Scanner, HTMLDocument, CompletionConfiguration, ICompletionParticipant, HTMLFormatConfiguration, DocumentContext, IHTMLDataProvider, HTMLDataV1, LanguageServiceOptions } from './htmlLanguageTypes';
export * from './htmlLanguageTypes';
export { TextDocument } from 'vscode-languageserver-textdocument';
export * from 'vscode-languageserver-types';
export interface LanguageService {
    createScanner(input: string, initialOffset?: number): Scanner;
    parseHTMLDocument(document: TextDocument): HTMLDocument;
    findDocumentHighlights(document: TextDocument, position: Position, htmlDocument: HTMLDocument): DocumentHighlight[];
    doComplete(document: TextDocument, position: Position, htmlDocument: HTMLDocument, options?: CompletionConfiguration): CompletionList;
    setCompletionParticipants(registeredCompletionParticipants: ICompletionParticipant[]): void;
    doHover(document: TextDocument, position: Position, htmlDocument: HTMLDocument): Hover | null;
    format(document: TextDocument, range: Range | undefined, options: HTMLFormatConfiguration): TextEdit[];
    findDocumentLinks(document: TextDocument, documentContext: DocumentContext): DocumentLink[];
    findDocumentSymbols(document: TextDocument, htmlDocument: HTMLDocument): SymbolInformation[];
    doTagComplete(document: TextDocument, position: Position, htmlDocument: HTMLDocument): string | null;
    getFoldingRanges(document: TextDocument, context?: {
        rangeLimit?: number;
    }): FoldingRange[];
    getSelectionRanges(document: TextDocument, positions: Position[]): SelectionRange[];
    doRename(document: TextDocument, position: Position, newName: string, htmlDocument: HTMLDocument): WorkspaceEdit | null;
    findMatchingTagPosition(document: TextDocument, position: Position, htmlDocument: HTMLDocument): Position | null;
    findSyncedRegions(document: TextDocument, position: Position, htmlDocument: HTMLDocument): Range[] | null;
}
export declare function getLanguageService(options?: LanguageServiceOptions): LanguageService;
export declare function newHTMLDataProvider(id: string, customData: HTMLDataV1): IHTMLDataProvider;
